/*
 * Decompiled with CFR 0.152.
 */
package easyfilepickerdialog.kingfisher.com.library.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import easyfilepickerdialog.kingfisher.com.library.adapter.BaseViewHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class BaseRecyclerArrayAdapter<T>
extends RecyclerView.Adapter<BaseViewHolder<T>>
implements Filterable {
    protected List<T> backupList;
    protected List<T> list;
    protected int layoutId;
    private Filter filter = new Filter(){
        List<T> resultsData = new ArrayList();
        Filter.FilterResults filterResults = new Filter.FilterResults();

        protected Filter.FilterResults performFiltering(CharSequence charSequence) {
            if (TextUtils.isEmpty((CharSequence)charSequence)) {
                this.filterResults.values = new ArrayList(BaseRecyclerArrayAdapter.this.backupList);
            } else {
                this.filterResults.values = this.resultsData;
                this.resultsData.clear();
                String lowerCaseChar = charSequence.toString().toLowerCase();
                for (Object data : BaseRecyclerArrayAdapter.this.backupList) {
                    if (!BaseRecyclerArrayAdapter.this.isMeetCondition(data, lowerCaseChar)) continue;
                    this.resultsData.add(data);
                }
            }
            return this.filterResults;
        }

        protected void publishResults(CharSequence charSequence, Filter.FilterResults filterResults) {
            if (filterResults.values != null) {
                int numberOfItems = BaseRecyclerArrayAdapter.this.list.size();
                BaseRecyclerArrayAdapter.this.list.clear();
                BaseRecyclerArrayAdapter.this.notifyItemRangeRemoved(0, numberOfItems);
                List datas = (List)filterResults.values;
                BaseRecyclerArrayAdapter.this.list.addAll(datas);
                BaseRecyclerArrayAdapter.this.notifyItemRangeInserted(0, datas.size());
            }
        }
    };

    public abstract BaseViewHolder<T> getViewHolder(View var1);

    public boolean isMeetCondition(T data, String sequenceLowerCase) {
        return false;
    }

    public BaseRecyclerArrayAdapter(List<T> list, int layoutId) {
        this.list = list;
        this.layoutId = layoutId;
        this.backupList = new ArrayList<T>(list);
    }

    public void onBindViewHolder(BaseViewHolder<T> holder, int position) {
        holder.setData(this.getItem(position), position);
    }

    public T getItem(int post) {
        if (this.list == null || post < 0 || post >= this.list.size()) {
            return null;
        }
        return this.list.get(post);
    }

    public void addItem(T data) {
        this.list.add(0, data);
        this.backupList.add(0, data);
        this.notifyItemInserted(0);
    }

    public void addItem(Collection<T> datas) {
        int count = this.list.size();
        this.list.addAll(datas);
        this.backupList.addAll(datas);
        this.notifyItemRangeInserted(count, datas.size());
    }

    public void clear() {
        int numberOfItems = this.list.size();
        this.list.clear();
        this.backupList.clear();
        this.notifyItemRangeRemoved(0, numberOfItems);
    }

    public void removeItem(T data) {
        int index = this.list.indexOf(data);
        if (index == -1) {
            return;
        }
        this.list.remove(index);
        this.notifyItemRemoved(index);
        this.backupList.remove(data);
    }

    public void removeItem(Collection<T> datas) {
        for (T data : datas) {
            this.removeItem(data);
        }
    }

    public int getItemCount() {
        int size = this.list == null ? 0 : this.list.size();
        return size;
    }

    public BaseViewHolder<T> onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(this.layoutId, parent, false);
        return this.getViewHolder(view);
    }

    public Filter getFilter() {
        return this.filter;
    }
}

