/*
 * Decompiled with CFR 0.152.
 */
package com.king.view.splitedittext;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.text.InputFilter;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import com.king.view.splitedittext.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class SplitEditText
extends AppCompatEditText {
    private Paint mPaint;
    private float mStrokeWidth;
    private int mBorderColor = -10066330;
    private int mInputBorderColor = -14774017;
    private int mFocusBorderColor;
    private int mBoxBackgroundColor;
    private float mBorderCornerRadius;
    private float mBorderSpacing;
    private float mBoxWidth;
    private float mBoxHeight;
    private int mMaxLength = 6;
    private int mTextLength;
    private Path mPath;
    private RectF mRectF;
    private float[] mRadiusFirstArray;
    private float[] mRadiusLastArray;
    private int mBorderStyle = 0;
    private int mTextStyle = 0;
    private String mCipherMask;
    private boolean isFakeBoldText;
    private static final String DEFAULT_CIPHER_MASK = "*";
    private boolean isDraw;
    private OnTextInputListener mOnTextInputListener;

    public SplitEditText(@NonNull Context context) {
        this(context, null);
    }

    public SplitEditText(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 16842862);
    }

    public SplitEditText(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(@NonNull Context context, @Nullable AttributeSet attrs) {
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.mStrokeWidth = TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)displayMetrics);
        this.mBorderSpacing = TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)displayMetrics);
        this.setPadding(0, 0, 0, 0);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SplitEditText);
        int count = a.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.SplitEditText_setStrokeWidth) {
                this.mStrokeWidth = a.getDimension(attr2, this.mStrokeWidth);
                continue;
            }
            if (attr2 == R.styleable.SplitEditText_setBorderColor) {
                this.mBorderColor = a.getColor(attr2, this.mBorderColor);
                continue;
            }
            if (attr2 == R.styleable.SplitEditText_setInputBorderColor) {
                this.mInputBorderColor = a.getColor(attr2, this.mInputBorderColor);
                continue;
            }
            if (attr2 == R.styleable.SplitEditText_setFocusBorderColor) {
                this.mFocusBorderColor = a.getColor(attr2, this.mFocusBorderColor);
                continue;
            }
            if (attr2 == R.styleable.SplitEditText_setBoxBackgroundColor) {
                this.mBoxBackgroundColor = a.getColor(attr2, this.mBoxBackgroundColor);
                continue;
            }
            if (attr2 == R.styleable.SplitEditText_setBorderCornerRadius) {
                this.mBorderCornerRadius = a.getDimension(attr2, this.mBorderCornerRadius);
                continue;
            }
            if (attr2 == R.styleable.SplitEditText_setBorderSpacing) {
                this.mBorderSpacing = a.getDimension(attr2, this.mBorderSpacing);
                continue;
            }
            if (attr2 == R.styleable.SplitEditText_setMaxLength) {
                this.mMaxLength = a.getInt(attr2, this.mMaxLength);
                continue;
            }
            if (attr2 == R.styleable.SplitEditText_setBorderStyle) {
                this.mBorderStyle = a.getInt(attr2, this.mBorderStyle);
                continue;
            }
            if (attr2 == R.styleable.SplitEditText_setTextStyle) {
                this.mTextStyle = a.getInt(attr2, this.mTextStyle);
                continue;
            }
            if (attr2 == R.styleable.SplitEditText_setCipherMask) {
                this.mCipherMask = a.getString(attr2);
                continue;
            }
            if (attr2 != R.styleable.SplitEditText_setFakeBoldText) continue;
            this.isFakeBoldText = a.getBoolean(attr2, false);
        }
        a.recycle();
        this.mPaint = new Paint(1);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mPath = new Path();
        this.mRadiusFirstArray = new float[8];
        this.mRadiusLastArray = new float[8];
        this.mRectF = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        if (TextUtils.isEmpty((CharSequence)this.mCipherMask)) {
            this.mCipherMask = DEFAULT_CIPHER_MASK;
        } else if (this.mCipherMask.length() > 1) {
            this.mCipherMask = this.mCipherMask.substring(0, 1);
        }
        this.setBackground(null);
        this.setCursorVisible(false);
        this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(this.mMaxLength)});
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int width = w - this.getPaddingLeft() - this.getPaddingRight();
        int height = h - this.getPaddingTop() - this.getPaddingBottom();
        this.updateSizeChanged(width, height);
    }

    private void updateSizeChanged(int width, int height) {
        if (this.mBorderSpacing < 0.0f || (float)(this.mMaxLength - 1) * this.mBorderSpacing > (float)width) {
            this.mBorderSpacing = 0.0f;
        }
        this.mBoxWidth = ((float)width - (float)(this.mMaxLength - 1) * this.mBorderSpacing) / (float)this.mMaxLength - this.mStrokeWidth;
        this.mBoxHeight = (float)height - this.mStrokeWidth;
    }

    protected void onDraw(Canvas canvas) {
        this.drawBorders(canvas);
    }

    private void drawBorders(Canvas canvas) {
        this.isDraw = true;
        for (int i = this.mTextLength; i < this.mMaxLength; ++i) {
            this.drawBorder(canvas, i, this.mBorderColor);
        }
        int color = this.mInputBorderColor != 0 ? this.mInputBorderColor : this.mBorderColor;
        for (int i = 0; i < this.mTextLength; ++i) {
            this.drawBorder(canvas, i, color);
        }
        if (this.mTextLength < this.mMaxLength && this.mFocusBorderColor != 0 && this.isFocused()) {
            this.drawBorder(canvas, this.mTextLength, this.mFocusBorderColor);
        }
    }

    private void drawBorder(Canvas canvas, int position, int borderColor) {
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setFakeBoldText(false);
        this.mPaint.setColor(borderColor);
        float left = (float)this.getPaddingLeft() + this.mStrokeWidth / 2.0f + (this.mBoxWidth + this.mBorderSpacing) * (float)position;
        float top = (float)this.getPaddingTop() + this.mStrokeWidth / 2.0f;
        this.mRectF.set(left, top, left + this.mBoxWidth, top + this.mBoxHeight);
        switch (this.mBorderStyle) {
            case 0: {
                this.drawBorderBox(canvas, position, borderColor);
                break;
            }
            case 1: {
                this.drawBorderLine(canvas);
            }
        }
        if (this.mTextLength > position && !TextUtils.isEmpty((CharSequence)this.getText())) {
            this.drawText(canvas, position);
        }
    }

    private void drawText(Canvas canvas, int position) {
        this.mPaint.setStrokeWidth(0.0f);
        this.mPaint.setColor(this.getCurrentTextColor());
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mPaint.setTextSize(this.getTextSize());
        this.mPaint.setFakeBoldText(this.isFakeBoldText);
        float x = this.mRectF.centerX();
        float y = this.mRectF.centerY() + (this.mPaint.getFontMetrics().bottom - this.mPaint.getFontMetrics().top) / 2.0f - this.mPaint.getFontMetrics().bottom;
        switch (this.mTextStyle) {
            case 0: {
                canvas.drawText(String.valueOf(this.getText().charAt(position)), x, y, this.mPaint);
                break;
            }
            case 1: {
                canvas.drawText(this.mCipherMask, x, y, this.mPaint);
            }
        }
    }

    private void drawBorderBox(Canvas canvas, int position, int borderColor) {
        if (this.mBorderCornerRadius > 0.0f) {
            if (this.mBorderSpacing == 0.0f) {
                if (position == 0 || position == this.mMaxLength - 1) {
                    if (this.mBoxBackgroundColor != 0) {
                        this.mPaint.setStyle(Paint.Style.FILL);
                        this.mPaint.setColor(this.mBoxBackgroundColor);
                        canvas.drawPath(this.getRoundRectPath(this.mRectF, position == 0), this.mPaint);
                    }
                    this.mPaint.setStyle(Paint.Style.STROKE);
                    this.mPaint.setColor(borderColor);
                    canvas.drawPath(this.getRoundRectPath(this.mRectF, position == 0), this.mPaint);
                } else {
                    if (this.mBoxBackgroundColor != 0) {
                        this.mPaint.setStyle(Paint.Style.FILL);
                        this.mPaint.setColor(this.mBoxBackgroundColor);
                        canvas.drawRect(this.mRectF, this.mPaint);
                    }
                    this.mPaint.setStyle(Paint.Style.STROKE);
                    this.mPaint.setColor(borderColor);
                    canvas.drawRect(this.mRectF, this.mPaint);
                }
            } else {
                if (this.mBoxBackgroundColor != 0) {
                    this.mPaint.setStyle(Paint.Style.FILL);
                    this.mPaint.setColor(this.mBoxBackgroundColor);
                    canvas.drawRoundRect(this.mRectF, this.mBorderCornerRadius, this.mBorderCornerRadius, this.mPaint);
                }
                this.mPaint.setStyle(Paint.Style.STROKE);
                this.mPaint.setColor(borderColor);
                canvas.drawRoundRect(this.mRectF, this.mBorderCornerRadius, this.mBorderCornerRadius, this.mPaint);
            }
        } else {
            if (this.mBoxBackgroundColor != 0) {
                this.mPaint.setStyle(Paint.Style.FILL);
                this.mPaint.setColor(this.mBoxBackgroundColor);
                canvas.drawRect(this.mRectF, this.mPaint);
            }
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setColor(borderColor);
            canvas.drawRect(this.mRectF, this.mPaint);
        }
    }

    private void drawBorderLine(Canvas canvas) {
        float y = (float)this.getPaddingTop() + this.mBoxHeight;
        canvas.drawLine(this.mRectF.left, y, this.mRectF.right, y, this.mPaint);
    }

    private Path getRoundRectPath(RectF rectF, boolean isFirst) {
        this.mPath.reset();
        if (isFirst) {
            this.mRadiusFirstArray[0] = this.mBorderCornerRadius;
            this.mRadiusFirstArray[1] = this.mBorderCornerRadius;
            this.mRadiusFirstArray[6] = this.mBorderCornerRadius;
            this.mRadiusFirstArray[7] = this.mBorderCornerRadius;
            this.mPath.addRoundRect(rectF, this.mRadiusFirstArray, Path.Direction.CW);
        } else {
            this.mRadiusLastArray[2] = this.mBorderCornerRadius;
            this.mRadiusLastArray[3] = this.mBorderCornerRadius;
            this.mRadiusLastArray[4] = this.mBorderCornerRadius;
            this.mRadiusLastArray[5] = this.mBorderCornerRadius;
            this.mPath.addRoundRect(rectF, this.mRadiusLastArray, Path.Direction.CW);
        }
        return this.mPath;
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        this.mTextLength = text.length();
        this.refreshView();
        if (this.mOnTextInputListener != null) {
            this.mOnTextInputListener.onTextInputChanged(text.toString(), this.mTextLength);
            if (this.mTextLength == this.mMaxLength) {
                this.mOnTextInputListener.onTextInputCompleted(text.toString());
            }
        }
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        super.onSelectionChanged(selStart, selEnd);
        if (selStart == selEnd) {
            this.setSelection(this.getText() == null ? 0 : this.getText().length());
        }
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        this.refreshView();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.isDraw = false;
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    public int getInputBorderColor() {
        return this.mInputBorderColor;
    }

    public int getFocusBorderColor() {
        return this.mFocusBorderColor;
    }

    public int getBoxBackgroundColor() {
        return this.mBoxBackgroundColor;
    }

    public float getBorderCornerRadius() {
        return this.mBorderCornerRadius;
    }

    public float getBorderSpacing() {
        return this.mBorderSpacing;
    }

    public int getBorderStyle() {
        return this.mBorderStyle;
    }

    public void setBorderColor(int borderColor) {
        this.mBorderColor = borderColor;
        this.refreshView();
    }

    public void setInputBorderColor(int inputBorderColor) {
        this.mInputBorderColor = inputBorderColor;
        this.refreshView();
    }

    public void setFocusBorderColor(int focusBorderColor) {
        this.mFocusBorderColor = focusBorderColor;
        this.refreshView();
    }

    public void setBoxBackgroundColor(int boxBackgroundColor) {
        this.mBoxBackgroundColor = boxBackgroundColor;
        this.refreshView();
    }

    public void setBorderCornerRadius(float borderCornerRadius) {
        this.mBorderCornerRadius = borderCornerRadius;
        this.refreshView();
    }

    public void setBorderSpacing(float borderSpacing) {
        this.mBorderSpacing = borderSpacing;
        this.refreshView();
    }

    public void setBorderStyle(int borderStyle) {
        this.mBorderStyle = borderStyle;
        this.refreshView();
    }

    public int getTextStyle() {
        return this.mTextStyle;
    }

    public void setTextStyle(int textStyle) {
        this.mTextStyle = textStyle;
        this.refreshView();
    }

    public String getCipherMask() {
        return this.mCipherMask;
    }

    public void setFakeBoldText(boolean fakeBoldText) {
        this.isFakeBoldText = fakeBoldText;
        this.refreshView();
    }

    public void setCipherMask(String cipherMask) {
        this.mCipherMask = cipherMask;
        this.refreshView();
    }

    private void refreshView() {
        if (this.isDraw) {
            this.invalidate();
        }
    }

    public void setOnTextInputListener(OnTextInputListener onTextInputListener) {
        this.mOnTextInputListener = onTextInputListener;
    }

    public static interface OnTextInputListener {
        public void onTextInputChanged(String var1, int var2);

        public void onTextInputCompleted(String var1);
    }

    public static abstract class OnSimpleTextInputListener
    implements OnTextInputListener {
        @Override
        public void onTextInputChanged(String text, int length) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TextStyle {
        public static final int PLAIN_TEXT = 0;
        public static final int CIPHER_TEXT = 1;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BorderStyle {
        public static final int BOX = 0;
        public static final int LINE = 1;
    }
}

