/*
 * Decompiled with CFR 0.152.
 */
package com.king.image.imageviewer.loader;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.king.image.imageviewer.ImageDataSource;
import com.king.image.imageviewer.loader.ImageLoader;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.RequestCreator;
import java.io.File;

public class PicassoImageLoader
implements ImageLoader {
    @Override
    public void loadImage(Context context, ImageView imageView, Object data, @Nullable Drawable placeholderDrawable, @Nullable Drawable errorDrawable) {
        RequestCreator requestCreator = data instanceof ImageDataSource ? this.getRequestCreate(((ImageDataSource)data).getDataSource()) : this.getRequestCreate(data);
        if (requestCreator != null) {
            if (placeholderDrawable != null) {
                requestCreator.placeholder(placeholderDrawable);
            }
            if (errorDrawable != null) {
                requestCreator.error(errorDrawable);
            }
            requestCreator.into(imageView);
        }
    }

    private RequestCreator getRequestCreate(Object data) {
        if (data instanceof Uri) {
            return Picasso.get().load((Uri)data);
        }
        if (data instanceof String) {
            return Picasso.get().load((String)data);
        }
        if (data instanceof Integer) {
            return Picasso.get().load(((Integer)data).intValue());
        }
        if (data instanceof File) {
            return Picasso.get().load((File)data);
        }
        return null;
    }
}

