/*
 * Decompiled with CFR 0.152.
 */
package com.king.image.imageviewer.loader;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.king.image.imageviewer.loader.ImageLoader;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.RequestCreator;
import java.io.File;

public class PicassoImageLoader
implements ImageLoader {
    @Override
    public void loadImage(Context context, ImageView imageView, Object data, @Nullable Drawable placeholderDrawable, @Nullable Drawable errorDrawable) {
        RequestCreator requestCreator = null;
        if (data instanceof Uri) {
            requestCreator = Picasso.get().load((Uri)data);
        } else if (data instanceof String) {
            requestCreator = Picasso.get().load((String)data);
        } else if (data instanceof Integer) {
            requestCreator = Picasso.get().load(((Integer)data).intValue());
        } else if (data instanceof File) {
            requestCreator = Picasso.get().load((File)data);
        }
        if (requestCreator != null) {
            if (placeholderDrawable != null) {
                requestCreator.placeholder(placeholderDrawable);
            }
            if (errorDrawable != null) {
                requestCreator.error(errorDrawable);
            }
            requestCreator.into(imageView);
        }
    }
}

