/*
 * Decompiled with CFR 0.152.
 */
package com.king.image.imageviewer;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.github.chrisbanes.photoview.PhotoView;
import com.king.image.imageviewer.R;
import com.king.image.imageviewer.ViewerSpec;
import java.util.ArrayList;
import java.util.List;

public class ImageViewerAdapter
extends RecyclerView.Adapter<ImageHolder> {
    private List<?> mDatas;
    private OnItemClickListener mOnItemClickListener;

    public ImageViewerAdapter(List<?> list) {
        this.mDatas = list != null ? list : new ArrayList();
    }

    @NonNull
    public ImageHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.vp_image_viewer_item, parent, false);
        return new ImageHolder(view);
    }

    public void onBindViewHolder(@NonNull ImageHolder holder, final int position) {
        holder.displayImage(this.mDatas.get(position));
        holder.photoView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ImageViewerAdapter.this.mOnItemClickListener != null) {
                    ImageViewerAdapter.this.mOnItemClickListener.onClick(v, position);
                }
            }
        });
    }

    public int getItemCount() {
        return this.mDatas != null ? this.mDatas.size() : 0;
    }

    void setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    static class ImageHolder
    extends RecyclerView.ViewHolder {
        PhotoView photoView;

        private ImageHolder(@NonNull View itemView) {
            super(itemView);
            this.photoView = (PhotoView)itemView.findViewById(R.id.photoView);
        }

        private void displayImage(Object data) {
            if (ViewerSpec.INSTANCE.imageLoader != null) {
                ViewerSpec.INSTANCE.imageLoader.loadImage(this.photoView.getContext(), (ImageView)this.photoView, data, ViewerSpec.INSTANCE.placeholderDrawable, ViewerSpec.INSTANCE.errorDrawable);
            }
        }
    }

    public static interface OnItemClickListener {
        public void onClick(View var1, int var2);
    }
}

