/*
 * Decompiled with CFR 0.152.
 */
package com.king.image.imageviewer;

import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;
import com.king.image.imageviewer.ImageViewerAdapter;
import com.king.image.imageviewer.R;
import com.king.image.imageviewer.ViewerSpec;

public class ImageViewerActivity
extends AppCompatActivity {
    static final String SHARED_ELEMENT = "shared_element";
    private TextView tvIndicator;
    ImageViewerAdapter mAdapter;
    ViewerSpec mViewerSpec;
    private int mSize;
    private boolean isShowIndicator;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.image_viewer_activity);
        this.init();
    }

    private void init() {
        this.tvIndicator = (TextView)this.findViewById(R.id.tvIndicator);
        ViewPager2 viewPager = (ViewPager2)this.findViewById(R.id.viewPager);
        viewPager.registerOnPageChangeCallback(new ViewPager2.OnPageChangeCallback(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                super.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }

            public void onPageSelected(int position) {
                super.onPageSelected(position);
                if (ImageViewerActivity.this.isShowIndicator) {
                    ImageViewerActivity.this.updateIndicator(position, ImageViewerActivity.this.mSize);
                }
            }

            public void onPageScrollStateChanged(int state) {
                super.onPageScrollStateChanged(state);
            }
        });
        this.mViewerSpec = ViewerSpec.INSTANCE;
        ViewCompat.setTransitionName((View)viewPager, (String)SHARED_ELEMENT);
        this.mAdapter = new ImageViewerAdapter(this.mViewerSpec.listData);
        viewPager.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mAdapter.setOnItemClickListener(new ImageViewerAdapter.OnItemClickListener(){

            @Override
            public void onClick(View v, int position) {
                ImageViewerActivity.this.onBackPressed();
            }
        });
        int position = this.mViewerSpec.position;
        this.mSize = this.mAdapter.getItemCount();
        if (position >= 0) {
            viewPager.setCurrentItem(position, false);
            this.updateIndicator(position, this.mSize);
        }
        boolean bl = this.isShowIndicator = this.mViewerSpec.isShowIndicator && this.mSize > 0;
        if (this.isShowIndicator) {
            this.tvIndicator.setVisibility(0);
        }
    }

    private void updateIndicator(int position, int size) {
        this.tvIndicator.setText((CharSequence)String.format("%s/%s", Math.min(position + 1, size), size));
    }

    protected void onDestroy() {
        if (this.mViewerSpec != null) {
            this.mViewerSpec.imageLoader = null;
        }
        super.onDestroy();
    }
}

