/*
 * Decompiled with CFR 0.152.
 */
package com.king.image.imageviewer;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityOptionsCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.king.image.imageviewer.ImageViewerActivity;
import com.king.image.imageviewer.R;
import com.king.image.imageviewer.ViewerSpec;
import com.king.image.imageviewer.loader.ImageLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class ImageViewer {
    private ViewerSpec mViewerSpec = ViewerSpec.INSTANCE;
    private ActivityOptionsCompat mOptionsCompat;
    private int placeholderDrawableId;
    private int errorDrawableId;

    private ImageViewer(@NonNull List<?> data) {
        this.mViewerSpec.reset();
        this.mViewerSpec.listData = data;
    }

    private ImageViewer(@NonNull Object data) {
        this.mViewerSpec.reset();
        ArrayList listData = new ArrayList();
        listData.add(data);
        this.mViewerSpec.listData = listData;
    }

    public static ImageViewer load(@NonNull List<?> data) {
        return new ImageViewer(data);
    }

    public static ImageViewer load(@NonNull String path) {
        return new ImageViewer(path);
    }

    public static ImageViewer load(@NonNull Uri uri) {
        return new ImageViewer(uri);
    }

    public static ImageViewer load(@DrawableRes int resourceId) {
        return new ImageViewer(resourceId);
    }

    public static ImageViewer load(@NonNull File file) {
        return new ImageViewer(file);
    }

    public ImageViewer selection(int position) {
        this.mViewerSpec.position = position;
        return this;
    }

    public ImageViewer placeholder(@DrawableRes int resourceId) {
        this.placeholderDrawableId = resourceId;
        this.mViewerSpec.placeholderDrawable = null;
        return this;
    }

    public ImageViewer placeholder(@Nullable Drawable drawable) {
        this.mViewerSpec.placeholderDrawable = drawable;
        this.placeholderDrawableId = 0;
        return this;
    }

    public ImageViewer error(@DrawableRes int resourceId) {
        this.errorDrawableId = resourceId;
        this.mViewerSpec.errorDrawable = null;
        return this;
    }

    public ImageViewer error(@Nullable Drawable drawable) {
        this.mViewerSpec.errorDrawable = drawable;
        this.errorDrawableId = 0;
        return this;
    }

    public ImageViewer imageLoader(@NonNull ImageLoader imageLoader) {
        this.mViewerSpec.imageLoader = imageLoader;
        return this;
    }

    public ImageViewer indicator(boolean showIndicator) {
        this.mViewerSpec.isShowIndicator = showIndicator;
        return this;
    }

    public ImageViewer activityOptionsCompat(ActivityOptionsCompat optionsCompat) {
        this.mOptionsCompat = optionsCompat;
        return this;
    }

    private void initResource(Context context) {
        if (this.mViewerSpec.placeholderDrawable == null && this.placeholderDrawableId != 0) {
            this.mViewerSpec.placeholderDrawable = ContextCompat.getDrawable((Context)context, (int)this.placeholderDrawableId);
        }
        if (this.mViewerSpec.errorDrawable == null && this.errorDrawableId != 0) {
            this.mViewerSpec.errorDrawable = ContextCompat.getDrawable((Context)context, (int)this.errorDrawableId);
        }
    }

    public void start(@NonNull Activity activity) {
        this.start(activity, null);
    }

    public void start(@NonNull Activity activity, @Nullable View sharedElement) {
        this.initResource((Context)activity);
        Intent intent = new Intent((Context)activity, ImageViewerActivity.class);
        if (this.mOptionsCompat == null) {
            this.mOptionsCompat = sharedElement != null ? ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)activity, (View)sharedElement, (String)"shared_element") : ActivityOptionsCompat.makeCustomAnimation((Context)activity, (int)R.anim.iv_anim_in, (int)R.anim.iv_anim_out);
        }
        Bundle bundle = null;
        if (this.mOptionsCompat != null) {
            bundle = this.mOptionsCompat.toBundle();
        }
        activity.startActivity(intent, bundle);
    }

    public void start(@NonNull Fragment fragment) {
        this.start(fragment, null);
    }

    public void start(@NonNull Fragment fragment, @Nullable View sharedElement) {
        this.initResource(fragment.getContext());
        Intent intent = new Intent(fragment.getContext(), ImageViewerActivity.class);
        if (this.mOptionsCompat == null) {
            this.mOptionsCompat = sharedElement != null ? ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)fragment.getActivity(), (View)sharedElement, (String)"shared_element") : ActivityOptionsCompat.makeCustomAnimation((Context)fragment.getContext(), (int)R.anim.iv_anim_in, (int)R.anim.iv_anim_out);
        }
        Bundle bundle = null;
        if (this.mOptionsCompat != null) {
            bundle = this.mOptionsCompat.toBundle();
        }
        fragment.startActivity(intent, bundle);
    }
}

