/*
 * Decompiled with CFR 0.152.
 */
package com.king.base.util;

import android.text.TextUtils;
import com.king.base.util.LogUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeUtils {
    private static final String TAG = "TimeUtils";
    public static final String FORMAT_Y_TO_S = "yyyyMMddHHmmss";
    public static final String FORMAT_Y_TO_S_EN = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_Y_TO_M_EN = "yyyy-MM-dd HH:mm";
    public static final String FORMAT_Y_TO_D = "yyyy-MM-dd";
    public static final String FORMAT_Y_TO_S_CN = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2";
    public static final String FORMAT_Y_TO_M_CN = "yyyy\u5e74MM\u6708dd HH\u65f6mm\u5206";
    public static final String FORMAT_Y_TO_D_CN = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String FORMAT_YMD = "yyyyMMdd";
    public static final String FORMAT_HMS = "HHmmss";
    public static final String FORMAT_H_TO_MIN = "HH:mm";
    public static String FORMAT_Y_M_D = "yyyy/MM/dd/ HH:mm:ss";
    public static String FORMAT_H_M_S = "HH:mm:ss";
    private static final int EXCEPTION_TIME = -1;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_MONTH = 2592000000L;
    public static final long ONE_YEAR = 31104000000L;

    private TimeUtils() {
        throw new AssertionError();
    }

    public static String formatDate(String time, String fromFormat, String toFormat) {
        if (TextUtils.isEmpty((CharSequence)time)) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)fromFormat) || TextUtils.isEmpty((CharSequence)toFormat)) {
            return time;
        }
        String dateTime = time;
        String dataStr = null;
        try {
            SimpleDateFormat oldFormat = new SimpleDateFormat(fromFormat);
            SimpleDateFormat newFormat = new SimpleDateFormat(toFormat);
            dataStr = newFormat.format(oldFormat.parse(dateTime));
        }
        catch (ParseException e) {
            LogUtils.w("date format failed: time=" + time + ", fromFormat=" + fromFormat + ", toFormat=" + toFormat, e);
            return time;
        }
        return dataStr;
    }

    public static String formatDate(String time, String toFormat) {
        if (time == null || "".equals(time.trim())) {
            return "";
        }
        String fromFormat = null;
        if (time.length() == 6) {
            fromFormat = FORMAT_HMS;
        } else if (time.length() == 8) {
            fromFormat = FORMAT_YMD;
        } else if (time.length() == 14) {
            fromFormat = FORMAT_Y_TO_S;
        } else {
            return time;
        }
        try {
            SimpleDateFormat oldFormat = new SimpleDateFormat(fromFormat);
            SimpleDateFormat newFormat = new SimpleDateFormat(toFormat);
            return newFormat.format(oldFormat.parse(time));
        }
        catch (ParseException e) {
            LogUtils.w("date format failed: time=" + time + ", fromFormat=" + fromFormat + ", toFormat=" + toFormat, e);
            return time;
        }
    }

    public static String formatDate(long time, String toFormat) {
        try {
            Date date = new Date(time);
            SimpleDateFormat newFormat = new SimpleDateFormat(toFormat);
            return newFormat.format(date);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getCurrentDate(String toFormat) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(toFormat);
            return format.format(new Date());
        }
        catch (Exception e) {
            LogUtils.w(e);
            return "";
        }
    }

    public static String formatDate(Date date, String toFormat) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(toFormat);
            return format.format(date);
        }
        catch (Exception e) {
            LogUtils.w(e);
            return "";
        }
    }

    public static Date parse(String time) {
        if (time == null || "".equals(time.trim())) {
            return null;
        }
        String fromFormat = null;
        if (time.length() == 6) {
            fromFormat = FORMAT_HMS;
        } else if (time.length() == 8) {
            fromFormat = FORMAT_YMD;
        } else if (time.length() == 14) {
            fromFormat = FORMAT_Y_TO_S;
        } else {
            return null;
        }
        try {
            SimpleDateFormat oldFormat = new SimpleDateFormat(fromFormat);
            return oldFormat.parse(time);
        }
        catch (ParseException e) {
            LogUtils.e("date format failed: time=" + time + ", fromFormat=" + fromFormat);
            return null;
        }
    }
}

