/*
 * Decompiled with CFR 0.152.
 */
package com.king.app.updater.util;

import android.content.Context;
import android.support.annotation.RawRes;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLSocketFactoryUtils {
    private SSLSocketFactoryUtils() {
    }

    public static SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory sslSocketFactory = null;
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{SSLSocketFactoryUtils.createTrustAllManager()}, new SecureRandom());
            sslSocketFactory = sslContext.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sslSocketFactory;
    }

    public static X509TrustManager createTrustAllManager() {
        X509TrustManager tm = null;
        try {
            tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tm;
    }

    public static TrustAllHostnameVerifier createTrustAllHostnameVerifier() {
        return new TrustAllHostnameVerifier();
    }

    public static SSLSocketFactory createSSLSocketFactory(Context context, @RawRes int keyServerStoreID) {
        InputStream trustStream = context.getResources().openRawResource(keyServerStoreID);
        return SSLSocketFactoryUtils.createSSLSocketFactory(trustStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SSLSocketFactory createSSLSocketFactory(InputStream ... certificates) {
        SSLSocketFactory mSSLSocketFactory = null;
        if (mSSLSocketFactory != null) return mSSLSocketFactory;
        Class<SSLSocketFactoryUtils> clazz = SSLSocketFactoryUtils.class;
        synchronized (SSLSocketFactoryUtils.class) {
            if (mSSLSocketFactory != null) return mSSLSocketFactory;
            SSLContext sslContext = null;
            try {
                sslContext = SSLContext.getInstance("TLS");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            TrustManager[] turstManager = SSLSocketFactoryUtils.getTurstManager(certificates);
            try {
                sslContext.init(null, turstManager, new SecureRandom());
                return sslContext.getSocketFactory();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            return sslContext.getSocketFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TrustManager[] getTurstManager(InputStream ... certificates) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            int index = 0;
            for (InputStream certificate : certificates) {
                Certificate certificate1;
                if (certificate == null) continue;
                try {
                    certificate1 = certificateFactory.generateCertificate(certificate);
                }
                finally {
                    certificate.close();
                }
                String certificateAlias = Integer.toString(index++);
                keyStore.setCertificateEntry(certificateAlias, certificate1);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception e) {
            e.printStackTrace();
            return SSLSocketFactoryUtils.getTurstAllManager();
        }
    }

    public static TrustManager[] getTurstAllManager() {
        return new X509TrustManager[]{SSLSocketFactoryUtils.createTrustAllManager()};
    }

    public static class TrustAllHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

