/*
 * Decompiled with CFR 0.152.
 */
package com.king.app.updater.util;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;

public enum PermissionUtils {
    INSTANCE;

    private String[] PERMISSIONS_STORAGE = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_PHONE_STATE"};

    public boolean verifyReadAndWritePermissions(@NonNull Activity activity, int requestCode) {
        int readResult = this.checkPermission(activity, "android.permission.READ_EXTERNAL_STORAGE");
        int writeResult = this.checkPermission(activity, "android.permission.WRITE_EXTERNAL_STORAGE");
        int readPhoneState = this.checkPermission(activity, "android.permission.READ_PHONE_STATE");
        if (readResult != 0 || writeResult != 0 || readPhoneState != 0) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])this.PERMISSIONS_STORAGE, (int)requestCode);
            return false;
        }
        return true;
    }

    public int checkPermission(@NonNull Activity activity, @NonNull String permission2) {
        return ActivityCompat.checkSelfPermission((Context)activity, (String)permission2);
    }
}

