/*
 * Decompiled with CFR 0.152.
 */
package com.king.app.updater.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import java.io.File;

public enum AppUtils {
    INSTANCE;


    public String getAppFullName(Context context, String url, String defaultName) {
        if (url.endsWith(".apk")) {
            return url.substring(url.lastIndexOf("/") + 1);
        }
        String filename = this.getAppName(context);
        if (TextUtils.isEmpty((CharSequence)filename)) {
            filename = defaultName;
        }
        return String.format("%s.apk", filename);
    }

    public PackageInfo getPackageInfo(Context context) throws PackageManager.NameNotFoundException {
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
        return packageInfo;
    }

    public String getAppName(Context context) {
        try {
            int labelRes = this.getPackageInfo((Context)context).applicationInfo.labelRes;
            return context.getResources().getString(labelRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getAppIcon(Context context) {
        try {
            return this.getPackageInfo((Context)context).applicationInfo.icon;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void installApk(Context context, File file, String authority) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(0x10000000);
        intent.addCategory("android.intent.category.DEFAULT");
        Uri uriData = null;
        String type = "application/vnd.android.package-archive";
        if (Build.VERSION.SDK_INT >= 24) {
            intent.addFlags(1);
            uriData = FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
        } else {
            uriData = Uri.fromFile((File)file);
        }
        intent.setDataAndType(uriData, type);
        context.startActivity(intent);
    }
}

