/*
 * Decompiled with CFR 0.152.
 */
package com.king.app.updater.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import androidx.core.content.FileProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;

public final class AppUtils {
    private AppUtils() {
        throw new AssertionError();
    }

    public static String getAppFullName(Context context, String url, String defaultName) {
        if (url.endsWith(".apk")) {
            return url.substring(url.lastIndexOf("/") + 1);
        }
        String filename = AppUtils.getAppName(context);
        if (TextUtils.isEmpty((CharSequence)filename)) {
            filename = defaultName;
        }
        return String.format("%s.apk", filename);
    }

    public static PackageInfo getPackageInfo(Context context) throws PackageManager.NameNotFoundException {
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
        return packageInfo;
    }

    public static PackageInfo getPackageInfo(Context context, String archiveFilePath) throws Exception {
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfo = packageManager.getPackageArchiveInfo(archiveFilePath, 1);
        return packageInfo;
    }

    public static String getAppName(Context context) {
        try {
            int labelRes = AppUtils.getPackageInfo((Context)context).applicationInfo.labelRes;
            return context.getResources().getString(labelRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getAppIcon(Context context) {
        try {
            return AppUtils.getPackageInfo((Context)context).applicationInfo.icon;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void installApk(Context context, File file, String authority) {
        Intent intent = AppUtils.getInstallIntent(context, file, authority);
        context.startActivity(intent);
    }

    public static Intent getInstallIntent(Context context, File file, String authority) {
        Uri uriData;
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(0x10000000);
        intent.addCategory("android.intent.category.DEFAULT");
        String type = "application/vnd.android.package-archive";
        if (Build.VERSION.SDK_INT >= 24) {
            intent.addFlags(1);
            uriData = FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
        } else {
            uriData = Uri.fromFile((File)file);
        }
        intent.setDataAndType(uriData, type);
        return intent;
    }

    public static boolean apkExists(Context context, int versionCode, File file) throws Exception {
        if (file != null && file.exists()) {
            ApplicationInfo applicationInfo;
            String packageName = context.getPackageName();
            PackageInfo packageInfo = AppUtils.getPackageInfo(context, file.getAbsolutePath());
            if (packageInfo != null && versionCode == packageInfo.versionCode && (applicationInfo = packageInfo.applicationInfo) != null && packageName.equals(applicationInfo.packageName)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAndroidQFileExists(Context context, String path) {
        return AppUtils.isAndroidQFileExists(context, new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isAndroidQFileExists(Context context, File file) {
        block6: {
            boolean bl;
            AssetFileDescriptor descriptor;
            block5: {
                descriptor = null;
                ContentResolver contentResolver = context.getContentResolver();
                Uri uri = Uri.fromFile((File)file);
                descriptor = contentResolver.openAssetFileDescriptor(uri, "r");
                if (descriptor != null) break block5;
                boolean bl2 = false;
                AppUtils.close(descriptor);
                return bl2;
            }
            try {
                AppUtils.close(descriptor);
                bl = true;
            }
            catch (FileNotFoundException e) {
                AppUtils.close(descriptor);
                break block6;
                catch (Throwable throwable) {
                    AppUtils.close(descriptor);
                    throw throwable;
                }
            }
            AppUtils.close(descriptor);
            return bl;
        }
        return false;
    }

    public static boolean checkFileMD5(File file, String md5) {
        String fileMD5 = AppUtils.getFileMD5(file);
        Log.d((String)"AppUpdater", (String)("FileMD5:" + fileMD5));
        if (!TextUtils.isEmpty((CharSequence)md5)) {
            return md5.equalsIgnoreCase(fileMD5);
        }
        return false;
    }

    public static String getFileMD5(File file) {
        try {
            int length;
            FileInputStream fis = new FileInputStream(file);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) != -1) {
                messageDigest.update(buffer, 0, length);
            }
            BigInteger bigInteger = new BigInteger(1, messageDigest.digest());
            return bigInteger.toString(16);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void close(AssetFileDescriptor descriptor) {
        if (descriptor != null) {
            try {
                descriptor.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

