/*
 * Decompiled with CFR 0.152.
 */
package com.king.app.updater.http;

import android.os.AsyncTask;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.Log;
import com.king.app.updater.http.IHttpManager;
import com.king.app.updater.util.SSLSocketFactoryUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class HttpManager
implements IHttpManager {
    private static final int DEFAULT_TIME_OUT = 20000;
    private int mTimeout;
    private boolean isCancel;
    private static volatile HttpManager INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<HttpManager> clazz = HttpManager.class;
        synchronized (HttpManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new HttpManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private HttpManager() {
        this(20000);
    }

    public HttpManager(int timeout) {
        this.mTimeout = timeout;
    }

    @Override
    public void download(String url, String path, String filename, @Nullable Map<String, String> requestProperty, IHttpManager.DownloadCallback callback) {
        this.isCancel = false;
        new DownloadTask(url, path, filename, requestProperty, callback).execute(new Void[0]);
    }

    @Override
    public void cancel() {
        this.isCancel = true;
    }

    private class DownloadTask
    extends AsyncTask<Void, Long, File> {
        private String url;
        private String path;
        private String filename;
        private Map<String, String> requestProperty;
        private IHttpManager.DownloadCallback callback;
        private Exception exception;

        public DownloadTask(String url, String path, @Nullable String filename, Map<String, String> requestProperty, IHttpManager.DownloadCallback callback) {
            this.url = url;
            this.path = path;
            this.filename = filename;
            this.callback = callback;
            this.requestProperty = requestProperty;
        }

        protected File doInBackground(Void ... voids) {
            try {
                HttpsURLConnection.setDefaultSSLSocketFactory(SSLSocketFactoryUtils.createSSLSocketFactory());
                HttpsURLConnection.setDefaultHostnameVerifier(SSLSocketFactoryUtils.createTrustAllHostnameVerifier());
                HttpURLConnection connect = (HttpURLConnection)new URL(this.url).openConnection();
                connect.setRequestMethod("GET");
                connect.setRequestProperty("Accept-Encoding", "identity");
                connect.setReadTimeout(HttpManager.this.mTimeout);
                connect.setConnectTimeout(HttpManager.this.mTimeout);
                if (this.requestProperty != null) {
                    for (Map.Entry<String, String> entry : this.requestProperty.entrySet()) {
                        connect.setRequestProperty(entry.getKey(), entry.getValue());
                    }
                }
                connect.connect();
                int responseCode = connect.getResponseCode();
                Log.d((String)"AppUpdater", (String)("Content-Type:" + connect.getContentType()));
                if (responseCode == 200) {
                    int len;
                    InputStream is = connect.getInputStream();
                    long length = connect.getContentLength();
                    if (Build.VERSION.SDK_INT >= 24) {
                        length = connect.getContentLengthLong();
                    }
                    Log.d((String)"AppUpdater", (String)("contentLength:" + length));
                    long progress = 0L;
                    byte[] buffer = new byte[8192];
                    File file = new File(this.path, this.filename);
                    FileOutputStream fos = new FileOutputStream(file);
                    while ((len = is.read(buffer)) != -1) {
                        if (HttpManager.this.isCancel) {
                            this.cancel(true);
                            break;
                        }
                        fos.write(buffer, 0, len);
                        progress += (long)len;
                        if (length <= 0L) continue;
                        this.publishProgress(new Long[]{progress, length});
                    }
                    fos.flush();
                    fos.close();
                    is.close();
                    connect.disconnect();
                    return file;
                }
                throw new ConnectException(String.format("responseCode = %d", responseCode));
            }
            catch (Exception e) {
                this.exception = e;
                e.printStackTrace();
                return null;
            }
        }

        protected void onPreExecute() {
            super.onPreExecute();
            if (this.callback != null) {
                this.callback.onStart(this.url);
            }
        }

        protected void onPostExecute(File file) {
            super.onPostExecute((Object)file);
            if (this.callback != null) {
                if (file != null) {
                    this.callback.onFinish(file);
                } else {
                    this.callback.onError(this.exception);
                }
            }
        }

        protected void onProgressUpdate(Long ... values) {
            super.onProgressUpdate((Object[])values);
            if (this.callback != null && !this.isCancelled()) {
                this.callback.onProgress(values[0], values[1]);
            }
        }

        protected void onCancelled() {
            super.onCancelled();
            if (this.callback != null) {
                this.callback.onCancel();
            }
        }
    }
}

