/*
 * Decompiled with CFR 0.152.
 */
package com.king.app.updater;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Parcelable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.king.app.updater.UpdateConfig;
import com.king.app.updater.callback.UpdateCallback;
import com.king.app.updater.http.IHttpManager;
import com.king.app.updater.service.DownloadService;
import com.king.app.updater.util.PermissionUtils;
import java.util.Map;

public class AppUpdater {
    private Context mContext;
    private UpdateConfig mConfig;
    private UpdateCallback mCallback;
    private IHttpManager mHttpManager;
    private ServiceConnection mServiceConnection;

    public AppUpdater(@NonNull Context context, @NonNull UpdateConfig config) {
        this.mContext = context;
        this.mConfig = config;
    }

    public AppUpdater(@NonNull Context context, @NonNull String url) {
        this.mContext = context;
        this.mConfig = new UpdateConfig();
        this.mConfig.setUrl(url);
    }

    public AppUpdater setUpdateCallback(UpdateCallback callback) {
        this.mCallback = callback;
        return this;
    }

    public AppUpdater setHttpManager(IHttpManager httpManager) {
        this.mHttpManager = httpManager;
        return this;
    }

    public void start() {
        if (this.mConfig != null && !TextUtils.isEmpty((CharSequence)this.mConfig.getUrl())) {
            if (this.mContext instanceof Activity && !TextUtils.isEmpty((CharSequence)this.mConfig.getPath())) {
                PermissionUtils.verifyReadAndWritePermissions((Activity)this.mContext, 102);
            }
            if (this.mConfig.isShowNotification() && !PermissionUtils.isNotificationEnabled(this.mContext)) {
                Log.w((String)"AppUpdater", (String)"Notification permission not enabled.");
            }
        } else {
            throw new NullPointerException("Url = null");
        }
        this.startDownloadService();
    }

    private void startDownloadService() {
        Intent intent = new Intent(this.mContext, DownloadService.class);
        if (this.mCallback != null || this.mHttpManager != null) {
            this.mServiceConnection = new ServiceConnection(){

                public void onServiceConnected(ComponentName name, IBinder service) {
                    DownloadService.DownloadBinder binder = (DownloadService.DownloadBinder)service;
                    binder.start(AppUpdater.this.mConfig, AppUpdater.this.mHttpManager, AppUpdater.this.mCallback);
                }

                public void onServiceDisconnected(ComponentName name) {
                }
            };
            this.mContext.getApplicationContext().bindService(intent, this.mServiceConnection, 1);
        } else {
            intent.putExtra("app_update_config", (Parcelable)this.mConfig);
            this.mContext.startService(intent);
        }
    }

    public void stop() {
        this.stopDownloadService();
    }

    private void stopDownloadService() {
        Intent intent = new Intent(this.mContext, DownloadService.class);
        intent.putExtra("stop_download_service", true);
        this.mContext.startService(intent);
    }

    public static class Builder {
        private UpdateConfig mConfig = new UpdateConfig();

        public Builder serUrl(@NonNull String url) {
            this.mConfig.setUrl(url);
            return this;
        }

        public Builder setPath(String path) {
            this.mConfig.setPath(path);
            return this;
        }

        public Builder setFilename(String filename) {
            this.mConfig.setFilename(filename);
            return this;
        }

        public Builder setShowNotification(boolean isShowNotification) {
            this.mConfig.setShowNotification(isShowNotification);
            return this;
        }

        public Builder setNotificationId(int notifyId) {
            this.mConfig.setNotificationId(notifyId);
            return this;
        }

        public Builder setChannelId(String channelId) {
            this.mConfig.setChannelId(channelId);
            return this;
        }

        public Builder setChannelName(String channelName) {
            this.mConfig.setChannelName(channelName);
            return this;
        }

        public Builder setNotificationIcon(@DrawableRes int icon) {
            this.mConfig.setNotificationIcon(icon);
            return this;
        }

        public Builder setVibrate(boolean vibrate) {
            this.mConfig.setVibrate(vibrate);
            return this;
        }

        public Builder setSound(boolean sound) {
            this.mConfig.setSound(sound);
            return this;
        }

        public Builder setInstallApk(boolean isInstallApk) {
            this.mConfig.setInstallApk(isInstallApk);
            return this;
        }

        public Builder setAuthority(String authority) {
            this.mConfig.setAuthority(authority);
            return this;
        }

        public Builder setShowPercentage(boolean showPercentage) {
            this.mConfig.setShowPercentage(showPercentage);
            return this;
        }

        public Builder setReDownload(boolean reDownload) {
            this.mConfig.setReDownload(reDownload);
            return this;
        }

        public Builder setReDownloads(int reDownloads) {
            this.mConfig.setReDownloads(reDownloads);
            return this;
        }

        public Builder setVersionCode(Integer versionCode) {
            this.mConfig.setVersionCode(versionCode);
            return this;
        }

        public Builder addHeader(String key, String value) {
            this.mConfig.addHeader(key, value);
            return this;
        }

        public Builder addHeader(Map<String, String> headers) {
            this.mConfig.addHeader(headers);
            return this;
        }

        public Builder setDeleteCancelFile(boolean isDeleteCancelFile) {
            this.mConfig.setDeleteCancelFile(isDeleteCancelFile);
            return this;
        }

        public AppUpdater build(@NonNull Context context) {
            AppUpdater appUpdater = new AppUpdater(context, this.mConfig);
            return appUpdater;
        }
    }
}

