/*
 * Decompiled with CFR 0.152.
 */
package com.king.app.updater.service;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Environment;
import android.os.IBinder;
import android.os.Parcelable;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import android.util.Log;
import com.king.app.updater.R;
import com.king.app.updater.UpdateConfig;
import com.king.app.updater.callback.UpdateCallback;
import com.king.app.updater.constant.Constants;
import com.king.app.updater.http.HttpManager;
import com.king.app.updater.http.IHttpManager;
import com.king.app.updater.util.AppUtils;
import java.io.File;

public class DownloadService
extends Service {
    private DownloadBinder mDownloadBinder = new DownloadBinder();
    private boolean isDownloading;
    private int mLastProgress = -1;
    private long mLastTime;
    private int mCount = 0;

    private Context getContext() {
        return this;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent != null) {
            if (!this.isDownloading) {
                boolean isStop = intent.getBooleanExtra("stop_download_service", false);
                if (isStop) {
                    this.stopService();
                } else {
                    boolean isReDownload = intent.getBooleanExtra("app_update_re_download", false);
                    if (isReDownload) {
                        ++this.mCount;
                    }
                    UpdateConfig config = (UpdateConfig)intent.getParcelableExtra("app_update_config");
                    this.startDownload(config, null, null);
                }
            } else {
                Log.w((String)"AppUpdater", (String)"Please do not repeat the download.");
            }
        }
        return super.onStartCommand(intent, flags, startId);
    }

    public void startDownload(UpdateConfig config, IHttpManager httpManager, UpdateCallback callback) {
        File file;
        File dirFile;
        if (config == null) {
            return;
        }
        if (callback != null) {
            callback.onDownloading(this.isDownloading);
        }
        if (this.isDownloading) {
            Log.w((String)"AppUpdater", (String)"Please do not repeat the download.");
            return;
        }
        String url = config.getUrl();
        String path = config.getPath();
        String filename = config.getFilename();
        if (TextUtils.isEmpty((CharSequence)path)) {
            path = this.getDiskCacheDir(this.getContext());
        }
        if (!(dirFile = new File(path)).exists()) {
            dirFile.mkdir();
        }
        if (TextUtils.isEmpty((CharSequence)filename)) {
            filename = AppUtils.INSTANCE.getAppFullName(this.getContext(), url, this.getResources().getString(R.string.app_name));
        }
        if ((file = new File(path, filename)).exists()) {
            file.delete();
        }
        if (httpManager != null) {
            httpManager.download(url, path, filename, new AppDownloadCallback(config, callback));
        } else {
            HttpManager.getInstance().download(url, path, filename, new AppDownloadCallback(config, callback));
        }
    }

    public String getDiskCacheDir(Context context) {
        if ("mounted".equals(Environment.getExternalStorageState())) {
            return Constants.DEFAULT_DIR_PATH;
        }
        return context.getCacheDir().getAbsolutePath();
    }

    private void stopService() {
        this.mCount = 0;
        this.stopSelf();
    }

    public void onDestroy() {
        this.isDownloading = false;
        super.onDestroy();
    }

    private void showStartNotification(int notifyId, String channelId, String channelName, @DrawableRes int icon, CharSequence title, CharSequence content, boolean isVibrate, boolean isSound) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.createNotificationChannel(channelId, channelName, isVibrate, isSound);
        }
        NotificationCompat.Builder builder = this.buildNotification(channelId, icon, title, content);
        if (isVibrate && isSound) {
            builder.setDefaults(3);
        } else if (isVibrate) {
            builder.setDefaults(2);
        } else if (isSound) {
            builder.setDefaults(1);
        }
        Notification notification = builder.build();
        notification.flags = 40;
        this.notifyNotification(notifyId, notification);
    }

    private void showProgressNotification(int notifyId, String channelId, @DrawableRes int icon, CharSequence title, CharSequence content, int progress, int size) {
        NotificationCompat.Builder builder = this.buildNotification(channelId, icon, title, content, progress, size);
        Notification notification = builder.build();
        notification.flags = 40;
        this.notifyNotification(notifyId, notification);
    }

    private void showFinishNotification(int notifyId, String channelId, @DrawableRes int icon, CharSequence title, CharSequence content, File file, String authority) {
        Uri uriData;
        this.cancelNotification(notifyId);
        NotificationCompat.Builder builder = this.buildNotification(channelId, icon, title, content);
        builder.setAutoCancel(true);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(0x10000000);
        intent.addCategory("android.intent.category.DEFAULT");
        String type = "application/vnd.android.package-archive";
        if (Build.VERSION.SDK_INT >= 24) {
            intent.addFlags(1);
            uriData = FileProvider.getUriForFile((Context)this.getContext(), (String)authority, (File)file);
        } else {
            uriData = Uri.fromFile((File)file);
        }
        intent.setDataAndType(uriData, type);
        PendingIntent clickIntent = PendingIntent.getActivity((Context)this.getContext(), (int)notifyId, (Intent)intent, (int)0x8000000);
        builder.setContentIntent(clickIntent);
        Notification notification = builder.build();
        notification.flags = 16;
        this.notifyNotification(notifyId, notification);
    }

    private void showErrorNotification(int notifyId, String channelId, @DrawableRes int icon, CharSequence title, CharSequence content, boolean isReDownload, UpdateConfig config) {
        NotificationCompat.Builder builder = this.buildNotification(channelId, icon, title, content);
        builder.setAutoCancel(true);
        if (isReDownload) {
            Intent intent = new Intent(this.getContext(), DownloadService.class);
            intent.putExtra("app_update_re_download", true);
            intent.putExtra("app_update_config", (Parcelable)config);
            PendingIntent clickIntent = PendingIntent.getService((Context)this.getContext(), (int)notifyId, (Intent)intent, (int)0x8000000);
            builder.setContentIntent(clickIntent);
        } else {
            PendingIntent clickIntent = PendingIntent.getService((Context)this.getContext(), (int)notifyId, (Intent)new Intent(), (int)0x8000000);
            builder.setContentIntent(clickIntent);
        }
        Notification notification = builder.build();
        notification.flags = 16;
        this.notifyNotification(notifyId, notification);
    }

    private void showNotification(int notifyId, String channelId, @DrawableRes int icon, CharSequence title, CharSequence content, boolean isAutoCancel) {
        NotificationCompat.Builder builder = this.buildNotification(channelId, icon, title, content);
        builder.setAutoCancel(isAutoCancel);
        Notification notification = builder.build();
        notification.flags = 16;
        this.notifyNotification(notifyId, notification);
    }

    private void cancelNotification(int notifyId) {
        this.getNotificationManager().cancel(notifyId);
    }

    private NotificationManager getNotificationManager() {
        return (NotificationManager)this.getSystemService("notification");
    }

    @RequiresApi(api=26)
    private void createNotificationChannel(String channelId, String channelName, boolean isVibrate, boolean isSound) {
        NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)channelName, 3);
        channel.enableVibration(isVibrate);
        if (!isSound) {
            channel.setSound(null, null);
        }
        this.getNotificationManager().createNotificationChannel(channel);
    }

    private NotificationCompat.Builder buildNotification(String channelId, @DrawableRes int icon, CharSequence title, CharSequence content) {
        return this.buildNotification(channelId, icon, title, content, -1, -1);
    }

    private NotificationCompat.Builder buildNotification(String channelId, @DrawableRes int icon, CharSequence title, CharSequence content, int progress, int size) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.getContext(), channelId);
        builder.setSmallIcon(icon);
        builder.setContentTitle(title);
        builder.setContentText(content);
        builder.setOngoing(true);
        if (progress != -1 && size != -1) {
            builder.setProgress(size, progress, false);
        }
        return builder;
    }

    private void notifyNotification(int id, Notification notification) {
        this.getNotificationManager().notify(id, notification);
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return this.mDownloadBinder;
    }

    public class DownloadBinder
    extends Binder {
        public void start(UpdateConfig config) {
            this.start(config, null, null);
        }

        public void start(UpdateConfig config, UpdateCallback callback) {
            this.start(config, null, callback);
        }

        public void start(UpdateConfig config, IHttpManager httpManager, UpdateCallback callback) {
            DownloadService.this.startDownload(config, httpManager, callback);
        }
    }

    public class AppDownloadCallback
    implements IHttpManager.DownloadCallback {
        public UpdateConfig config;
        private boolean isShowNotification;
        private int notifyId;
        private String channelId;
        private String channelName;
        private int notificationIcon;
        private boolean isInstallApk;
        private String authority;
        private boolean isShowPercentage;
        private boolean isReDownload;
        private UpdateCallback callback;

        private AppDownloadCallback(UpdateConfig config, UpdateCallback callback) {
            this.config = config;
            this.callback = callback;
            this.isShowNotification = config.isShowNotification();
            this.notifyId = config.getNotificationId();
            if (Build.VERSION.SDK_INT >= 26) {
                this.channelId = TextUtils.isEmpty((CharSequence)config.getChannelId()) ? "0x66" : config.getChannelId();
                this.channelName = TextUtils.isEmpty((CharSequence)config.getChannelName()) ? "AppUpdater" : config.getChannelName();
            }
            this.notificationIcon = config.getNotificationIcon() <= 0 ? AppUtils.INSTANCE.getAppIcon(DownloadService.this.getContext()) : config.getNotificationIcon();
            this.isInstallApk = config.isInstallApk();
            this.authority = TextUtils.isEmpty((CharSequence)config.getAuthority()) ? DownloadService.this.getContext().getPackageName() + ".fileProvider" : config.getAuthority();
            this.isShowPercentage = config.isShowPercentage();
            this.isReDownload = config.isReDownload();
        }

        @Override
        public void onStart(String url) {
            DownloadService.this.isDownloading = true;
            DownloadService.this.mLastProgress = 0;
            if (this.isShowNotification) {
                DownloadService.this.showStartNotification(this.notifyId, this.channelId, this.channelName, this.notificationIcon, DownloadService.this.getString(R.string.app_updater_start_notification_title), DownloadService.this.getString(R.string.app_updater_start_notification_content), this.config.isVibrate(), this.config.isSound());
            }
            if (this.callback != null) {
                this.callback.onStart(url);
            }
        }

        @Override
        public void onProgress(int progress, int total) {
            boolean isChange = false;
            long curTime = System.currentTimeMillis();
            if (DownloadService.this.mLastTime + 200L < curTime) {
                DownloadService.this.mLastTime = curTime;
                int currProgress = Math.round((float)progress * 1.0f / (float)total * 100.0f);
                if (currProgress != DownloadService.this.mLastProgress) {
                    isChange = true;
                    String percentage = currProgress + "%";
                    if (this.isShowNotification) {
                        DownloadService.this.mLastProgress = currProgress;
                        String content = DownloadService.this.getString(R.string.app_updater_progress_notification_content);
                        if (this.isShowPercentage) {
                            content = content + percentage;
                        }
                        DownloadService.this.showProgressNotification(this.notifyId, this.channelId, this.notificationIcon, DownloadService.this.getString(R.string.app_updater_progress_notification_title), content, progress, total);
                    }
                }
            }
            if (this.callback != null) {
                this.callback.onProgress(progress, total, isChange);
            }
        }

        @Override
        public void onFinish(File file) {
            DownloadService.this.isDownloading = false;
            DownloadService.this.showFinishNotification(this.notifyId, this.channelId, this.notificationIcon, DownloadService.this.getString(R.string.app_updater_finish_notification_title), DownloadService.this.getString(R.string.app_updater_finish_notification_content), file, this.authority);
            if (this.isInstallApk) {
                AppUtils.INSTANCE.installApk(DownloadService.this.getContext(), file, this.authority);
            }
            if (this.callback != null) {
                this.callback.onFinish(file);
            }
            DownloadService.this.stopService();
        }

        @Override
        public void onError(Exception e) {
            DownloadService.this.isDownloading = false;
            boolean isReDownload = this.isReDownload && DownloadService.this.mCount < 3;
            String content = isReDownload ? DownloadService.this.getString(R.string.app_updater_error_notification_content_re_download) : DownloadService.this.getString(R.string.app_updater_error_notification_content);
            DownloadService.this.showErrorNotification(this.notifyId, this.channelId, this.notificationIcon, DownloadService.this.getString(R.string.app_updater_error_notification_title), content, isReDownload, this.config);
            if (this.callback != null) {
                this.callback.onError(e);
            }
            if (!isReDownload) {
                DownloadService.this.stopService();
            }
        }

        @Override
        public void onCancel() {
            DownloadService.this.isDownloading = false;
            DownloadService.this.cancelNotification(this.notifyId);
            if (this.callback != null) {
                this.callback.onCancel();
            }
            DownloadService.this.stopService();
        }
    }
}

