/*
 * Decompiled with CFR 0.152.
 */
package com.king.app.updater.util;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Parcelable;
import androidx.annotation.DrawableRes;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import com.king.app.updater.UpdateConfig;
import com.king.app.updater.service.DownloadService;
import com.king.app.updater.util.AppUtils;
import java.io.File;

public class NotificationUtils {
    private NotificationUtils() {
        throw new AssertionError();
    }

    public static void showStartNotification(Context context, int notifyId, String channelId, String channelName, @DrawableRes int icon, CharSequence title, CharSequence content, boolean isVibrate, boolean isSound) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationUtils.createNotificationChannel(context, channelId, channelName, isVibrate, isSound);
        }
        NotificationCompat.Builder builder = NotificationUtils.buildNotification(context, channelId, icon, title, content);
        builder.setPriority(4);
        if (isVibrate && isSound) {
            builder.setDefaults(3);
        } else if (isVibrate) {
            builder.setDefaults(2);
        } else if (isSound) {
            builder.setDefaults(1);
        }
        Notification notification = builder.build();
        notification.flags = 40;
        NotificationUtils.notifyNotification(context, notifyId, notification);
    }

    public static void showProgressNotification(Context context, int notifyId, String channelId, @DrawableRes int icon, CharSequence title, CharSequence content, int progress, int size) {
        NotificationCompat.Builder builder = NotificationUtils.buildNotification(context, channelId, icon, title, content, progress, size);
        Notification notification = builder.build();
        notification.flags = 40;
        NotificationUtils.notifyNotification(context, notifyId, notification);
    }

    public static void showFinishNotification(Context context, int notifyId, String channelId, @DrawableRes int icon, CharSequence title, CharSequence content, File file, String authority) {
        NotificationUtils.cancelNotification(context, notifyId);
        NotificationCompat.Builder builder = NotificationUtils.buildNotification(context, channelId, icon, title, content);
        builder.setAutoCancel(true);
        Intent intent = AppUtils.getInstallIntent(context, file, authority);
        PendingIntent clickIntent = PendingIntent.getActivity((Context)context, (int)notifyId, (Intent)intent, (int)0x8000000);
        builder.setContentIntent(clickIntent);
        Notification notification = builder.build();
        notification.flags = 16;
        NotificationUtils.notifyNotification(context, notifyId, notification);
    }

    public static void showErrorNotification(Context context, int notifyId, String channelId, @DrawableRes int icon, CharSequence title, CharSequence content, boolean isReDownload, UpdateConfig config) {
        NotificationCompat.Builder builder = NotificationUtils.buildNotification(context, channelId, icon, title, content);
        builder.setAutoCancel(true);
        if (isReDownload) {
            Intent intent = new Intent(context, DownloadService.class);
            intent.putExtra("app_update_re_download", true);
            intent.putExtra("app_update_config", (Parcelable)config);
            PendingIntent clickIntent = PendingIntent.getService((Context)context, (int)notifyId, (Intent)intent, (int)0x8000000);
            builder.setContentIntent(clickIntent);
        } else {
            PendingIntent clickIntent = PendingIntent.getService((Context)context, (int)notifyId, (Intent)new Intent(), (int)0x8000000);
            builder.setContentIntent(clickIntent);
        }
        Notification notification = builder.build();
        notification.flags = 16;
        NotificationUtils.notifyNotification(context, notifyId, notification);
    }

    public static void showNotification(Context context, int notifyId, String channelId, @DrawableRes int icon, CharSequence title, CharSequence content, boolean isAutoCancel) {
        NotificationCompat.Builder builder = NotificationUtils.buildNotification(context, channelId, icon, title, content);
        builder.setAutoCancel(isAutoCancel);
        Notification notification = builder.build();
        notification.flags = 16;
        NotificationUtils.notifyNotification(context, notifyId, notification);
    }

    public static void cancelNotification(Context context, int notifyId) {
        NotificationUtils.getNotificationManager(context).cancel(notifyId);
    }

    public static NotificationManager getNotificationManager(Context context) {
        return (NotificationManager)context.getSystemService("notification");
    }

    @RequiresApi(api=26)
    public static void createNotificationChannel(Context context, String channelId, String channelName, boolean isVibrate, boolean isSound) {
        NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)channelName, 4);
        channel.enableVibration(isVibrate);
        if (!isSound) {
            channel.setSound(null, null);
        }
        NotificationUtils.getNotificationManager(context).createNotificationChannel(channel);
    }

    private static NotificationCompat.Builder buildNotification(Context context, String channelId, @DrawableRes int icon, CharSequence title, CharSequence content) {
        return NotificationUtils.buildNotification(context, channelId, icon, title, content, -1, -1);
    }

    private static NotificationCompat.Builder buildNotification(Context context, String channelId, @DrawableRes int icon, CharSequence title, CharSequence content, int progress, int size) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, channelId);
        builder.setSmallIcon(icon);
        builder.setContentTitle(title);
        builder.setContentText(content);
        builder.setOngoing(true);
        if (progress != -1 && size != -1) {
            builder.setProgress(size, progress, false);
        }
        return builder;
    }

    private static void notifyNotification(Context context, int id, Notification notification) {
        NotificationUtils.getNotificationManager(context).notify(id, notification);
    }
}

