/*
 * Decompiled with CFR 0.152.
 */
package com.king.app.updater.http;

import android.os.AsyncTask;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.king.app.updater.http.HttpManager;
import com.king.app.updater.http.IHttpManager;
import com.king.app.updater.util.SSLSocketFactoryUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.http.conn.ssl.SSLSocketFactory;

public class OkHttpManager
implements IHttpManager {
    private static final int DEFAULT_TIME_OUT = 20000;
    private OkHttpClient okHttpClient;
    private boolean isCancel;
    private static volatile OkHttpManager INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<HttpManager> clazz = HttpManager.class;
        synchronized (HttpManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new OkHttpManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private OkHttpManager() {
        this(20000);
    }

    public OkHttpManager(int timeout) {
        this(new OkHttpClient.Builder().readTimeout((long)timeout, TimeUnit.MILLISECONDS).connectTimeout((long)timeout, TimeUnit.MILLISECONDS).sslSocketFactory(SSLSocketFactoryUtils.createSSLSocketFactory(), SSLSocketFactoryUtils.createTrustAllManager()).hostnameVerifier((HostnameVerifier)SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER).build());
    }

    public OkHttpManager(@NonNull OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    @Override
    public void download(String url, String path, String filename, @Nullable Map<String, String> requestProperty, IHttpManager.DownloadCallback callback) {
        this.isCancel = false;
        new DownloadTask(this.okHttpClient, url, path, filename, requestProperty, callback).execute(new Void[0]);
    }

    @Override
    public void cancel() {
        this.isCancel = true;
    }

    private class DownloadTask
    extends AsyncTask<Void, Long, File> {
        private String url;
        private String path;
        private String filename;
        private Map<String, String> requestProperty;
        private IHttpManager.DownloadCallback callback;
        private Exception exception;
        private OkHttpClient okHttpClient;

        public DownloadTask(OkHttpClient okHttpClient, String url, String path, @Nullable String filename, Map<String, String> requestProperty, IHttpManager.DownloadCallback callback) {
            this.okHttpClient = okHttpClient;
            this.url = url;
            this.path = path;
            this.filename = filename;
            this.callback = callback;
            this.requestProperty = requestProperty;
        }

        protected File doInBackground(Void ... voids) {
            try {
                Call call;
                Response response;
                Request.Builder builder = new Request.Builder().url(this.url).addHeader("Accept-Encoding", "identity").get();
                if (this.requestProperty != null) {
                    for (Map.Entry<String, String> entry : this.requestProperty.entrySet()) {
                        builder.addHeader(entry.getKey(), entry.getValue());
                    }
                }
                if ((response = (call = this.okHttpClient.newCall(builder.build())).execute()).isSuccessful()) {
                    int len;
                    InputStream is = response.body().byteStream();
                    long length = response.body().contentLength();
                    Log.d((String)"AppUpdater", (String)("contentLength:" + length));
                    long progress = 0L;
                    byte[] buffer = new byte[8192];
                    File file = new File(this.path, this.filename);
                    FileOutputStream fos = new FileOutputStream(file);
                    while ((len = is.read(buffer)) != -1) {
                        if (OkHttpManager.this.isCancel) {
                            if (call != null) {
                                call.cancel();
                            }
                            this.cancel(true);
                            break;
                        }
                        fos.write(buffer, 0, len);
                        progress += (long)len;
                        if (length <= 0L) continue;
                        this.publishProgress(new Long[]{progress, length});
                    }
                    fos.flush();
                    fos.close();
                    is.close();
                    response.close();
                    if (progress <= 0L && length <= 0L) {
                        throw new IllegalStateException(String.format("contentLength = %d", length));
                    }
                    return file;
                }
                throw new ConnectException(String.format("responseCode = %d", response.code()));
            }
            catch (Exception e) {
                this.exception = e;
                e.printStackTrace();
                return null;
            }
        }

        protected void onPreExecute() {
            super.onPreExecute();
            if (this.callback != null) {
                this.callback.onStart(this.url);
            }
        }

        protected void onPostExecute(File file) {
            super.onPostExecute((Object)file);
            if (this.callback != null) {
                if (file != null) {
                    this.callback.onFinish(file);
                } else {
                    this.callback.onError(this.exception);
                }
            }
        }

        protected void onProgressUpdate(Long ... values) {
            super.onProgressUpdate((Object[])values);
            if (this.callback != null && !this.isCancelled()) {
                this.callback.onProgress(values[0], values[1]);
            }
        }

        protected void onCancelled() {
            super.onCancelled();
            if (this.callback != null) {
                this.callback.onCancel();
            }
        }
    }
}

