/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.utils;

import android.support.annotation.Nullable;
import java.util.Locale;
import java.util.regex.Pattern;

public class Preconditions {
    private static final String DEFAULT_MESSAGE = "Received an invalid parameter";
    private static final Pattern URL_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9+.-]*://\\S+");

    private Preconditions() {
    }

    public static void checkNotNull(@Nullable Object object, @Nullable String errorMsg) {
        Preconditions.check(object != null, errorMsg);
    }

    public static void checkEmptyString(@Nullable String string, @Nullable String errorMsg) {
        Preconditions.check(string != null && !string.trim().equals(""), errorMsg);
    }

    public static void checkValidUrl(@Nullable String url, @Nullable String errorMsg) {
        Preconditions.checkEmptyString(url, errorMsg);
        Preconditions.check(Preconditions.isUrl(url), errorMsg);
    }

    public static void checkValidOAuthCallback(@Nullable String url, @Nullable String errorMsg) {
        Preconditions.checkEmptyString(url, errorMsg);
        if (url.toLowerCase(Locale.ENGLISH).compareToIgnoreCase("oob") != 0) {
            Preconditions.check(Preconditions.isUrl(url), errorMsg);
        }
    }

    private static boolean isUrl(String url) {
        return URL_PATTERN.matcher(url).matches();
    }

    private static void check(boolean requirements, String error) {
        String message;
        String string = message = error == null || error.trim().length() <= 0 ? DEFAULT_MESSAGE : error;
        if (!requirements) {
            throw new IllegalArgumentException(message);
        }
    }
}

