/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import org.scribe.kii.exceptions.OAuthSignatureException;
import org.scribe.kii.services.Base64Encoder;
import org.scribe.kii.services.SignatureService;

public class RSASha1SignatureService
implements SignatureService {
    private static final String METHOD = "RSA-SHA1";
    private static final String RSA_SHA1 = "SHA1withRSA";
    private static final String UTF8 = "UTF-8";
    private PrivateKey privateKey;

    public RSASha1SignatureService(@NonNull PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    @NonNull
    public String getSignature(@NonNull String baseString, @Nullable String apiSecret, @Nullable String tokenSecret) {
        try {
            Signature signature = Signature.getInstance(RSA_SHA1);
            signature.initSign(this.privateKey);
            signature.update(baseString.getBytes(UTF8));
            return this.bytesToBase64String(signature);
        }
        catch (Exception e) {
            throw new OAuthSignatureException(baseString, e);
        }
    }

    private String bytesToBase64String(Signature signature) throws SignatureException {
        return Base64Encoder.getInstance().encode(signature.sign());
    }

    @Override
    @NonNull
    public String getSignatureMethod() {
        return METHOD;
    }
}

