/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import org.scribe.kii.exceptions.OAuthSignatureException;
import org.scribe.kii.services.SignatureService;
import org.scribe.kii.utils.OAuthEncoder;
import org.scribe.kii.utils.Preconditions;

public class PlaintextSignatureService
implements SignatureService {
    private static final String METHOD = "PLAINTEXT";

    @Override
    @NonNull
    public String getSignature(@Nullable String baseString, @NonNull String apiSecret, @NonNull String tokenSecret) {
        try {
            Preconditions.checkEmptyString(apiSecret, "Api secret cant be null or empty string");
            return OAuthEncoder.encode(apiSecret) + '&' + OAuthEncoder.encode(tokenSecret);
        }
        catch (Exception e) {
            throw new OAuthSignatureException(baseString, e);
        }
    }

    @Override
    @NonNull
    public String getSignatureMethod() {
        return METHOD;
    }
}

