/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.extractors;

import android.support.annotation.NonNull;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scribe.kii.exceptions.OAuthException;
import org.scribe.kii.extractors.AccessTokenExtractor;
import org.scribe.kii.model.Token;
import org.scribe.kii.utils.Preconditions;

public class JsonTokenExtractor
implements AccessTokenExtractor {
    private Pattern accessTokenPattern = Pattern.compile("\"access_token\":\\s*\"(\\S*?)\"");

    @Override
    @NonNull
    public Token extract(@NonNull String response) {
        Preconditions.checkEmptyString(response, "Cannot extract a token from a null or empty String");
        Matcher matcher = this.accessTokenPattern.matcher(response);
        if (matcher.find()) {
            return new Token(matcher.group(1), "", response);
        }
        throw new OAuthException("Cannot extract an acces token. Response was: " + response);
    }
}

