/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.builder.api;

import android.support.annotation.NonNull;
import org.scribe.kii.builder.api.DefaultApi20;
import org.scribe.kii.extractors.AccessTokenExtractor;
import org.scribe.kii.extractors.JsonTokenExtractor;
import org.scribe.kii.model.OAuthConfig;
import org.scribe.kii.utils.OAuthEncoder;
import org.scribe.kii.utils.Preconditions;

public class Foursquare2Api
extends DefaultApi20 {
    private static final String AUTHORIZATION_URL = "https://foursquare.com/oauth2/authenticate?client_id=%s&response_type=code&redirect_uri=%s";

    @Override
    @NonNull
    public String getAccessTokenEndpoint() {
        return "https://foursquare.com/oauth2/access_token?grant_type=authorization_code";
    }

    @Override
    @NonNull
    public String getAuthorizationUrl(@NonNull OAuthConfig config) {
        Preconditions.checkValidUrl(config.getCallback(), "Must provide a valid url as callback. Foursquare2 does not support OOB");
        return String.format(AUTHORIZATION_URL, config.getApiKey(), OAuthEncoder.encode(config.getCallback()));
    }

    @Override
    @NonNull
    public AccessTokenExtractor getAccessTokenExtractor() {
        return new JsonTokenExtractor();
    }
}

