/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.utils;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.json.JSONException;
import org.json.JSONObject;

public class SettingUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject getStorageSDKSettings(Context context) throws IOException, JSONException {
        if (context == null) {
            throw new RuntimeException("Passed context is null");
        }
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new InputStreamReader(context.getResources().getAssets().open("storage_sdk_settings.json")));
            String str = reader.readLine();
            while (str != null) {
                builder.append(str);
                str = reader.readLine();
            }
        }
        return new JSONObject(builder.toString());
    }

    @Nullable
    public static String getKiiAppsBaseUrl(@NonNull Context context) throws IOException, JSONException {
        return SettingUtils.getStorageSDKSettings(context).getString("kiiappsBaseUrl");
    }

    @Nullable
    public static String[] getHttpAuth(@NonNull Context context) throws IOException, JSONException {
        JSONObject settings = SettingUtils.getStorageSDKSettings(context);
        if (settings.has("http_auth_username") && settings.has("http_auth_password")) {
            String[] ret = new String[]{settings.getString("http_auth_username"), settings.getString("http_auth_password")};
            return ret;
        }
        return null;
    }

    @Nullable
    public static String getReservedProvider1(@NonNull Context context) throws IOException, JSONException {
        JSONObject settings = SettingUtils.getStorageSDKSettings(context);
        if (settings.has("reserved_provider1")) {
            return settings.getString("reserved_provider1");
        }
        return null;
    }
}

