/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;

public class MimeUtil {
    private static HashMap<String, String> mimeTypes = new HashMap();

    @Nullable
    public static String getInfoByExt(@NonNull String fileExtension) {
        return mimeTypes.get(fileExtension.toLowerCase(Locale.ENGLISH));
    }

    @Nullable
    public static String getInfoByFileName(@NonNull String fileName) {
        String suffix = MimeUtil.getSuffixOfFile(fileName);
        if (suffix != null) {
            return mimeTypes.get(suffix);
        }
        return "application/octet-stream";
    }

    @NonNull
    public static String getInfoByFile(@NonNull File file) {
        String suffix = MimeUtil.getSuffixOfFile(file.getAbsolutePath());
        String type = null;
        if (suffix != null) {
            type = mimeTypes.get(suffix);
        }
        return type == null ? "application/octet-stream" : type;
    }

    @Nullable
    public static String getInfoByMimeName(@NonNull String mimeType) {
        String mime = mimeType.toLowerCase(Locale.ENGLISH);
        for (String type : mimeTypes.keySet()) {
            if (!type.equalsIgnoreCase(mime)) continue;
            return type;
        }
        return null;
    }

    @Nullable
    public static String getSuffixOfFile(@Nullable String fileName) {
        int dotPos;
        String suffix = null;
        if (!TextUtils.isEmpty((CharSequence)fileName) && (dotPos = fileName.lastIndexOf(".")) >= 0) {
            suffix = fileName.substring(dotPos + 1);
        }
        return suffix;
    }

    static {
        mimeTypes.put("zip", "application/zip");
        mimeTypes.put("pdf", "application/pdf");
        mimeTypes.put("txt", "text/plain");
        mimeTypes.put("bas", "text/plain");
        mimeTypes.put("c", "text/plain");
        mimeTypes.put("h", "text/plain");
        mimeTypes.put("htm", "text/html");
        mimeTypes.put("html", "text/html");
        mimeTypes.put("stm", "text/html");
        mimeTypes.put("doc", "application/msword");
        mimeTypes.put("dot", "application/msword");
        mimeTypes.put("xla", "application/vnd.ms-excel");
        mimeTypes.put("xlc", "application/vnd.ms-excel");
        mimeTypes.put("xlm", "application/vnd.ms-excel");
        mimeTypes.put("xls", "application/vnd.ms-excel");
        mimeTypes.put("xlt", "application/vnd.ms-excel");
        mimeTypes.put("xlw", "application/vnd.ms-excel");
        mimeTypes.put("ppt", "application/vnd.ms-powerpoint");
        mimeTypes.put("pot", "application/vnd.ms-powerpoint");
        mimeTypes.put("pps", "application/vnd.ms-powerpoint");
        mimeTypes.put("swf", "application/x-shockwave-flash");
        mimeTypes.put("apk", "application/vnd.android.package-archive");
        mimeTypes.put("jar", "application/vnd.android.package-archive");
        mimeTypes.put("jad", "application/vnd.android.package-archive");
        mimeTypes.put("jpg", "image/jpeg");
        mimeTypes.put("jpeg", "image/jpeg");
        mimeTypes.put("png", "image/png");
        mimeTypes.put("gif", "image/gif");
        mimeTypes.put("tif", "image/tiff");
        mimeTypes.put("tiff", "image/tiff");
        mimeTypes.put("bm", "image/bmp");
        mimeTypes.put("bmp", "image/bmp");
        mimeTypes.put("3gp", "video/3gpp");
        mimeTypes.put("3g2", "video/3gpp");
        mimeTypes.put("mp4", "video/mp4");
        mimeTypes.put("wmv", "video/wmv");
        mimeTypes.put("avi", "video/avi");
        mimeTypes.put("xvid", "video/x-divx");
        mimeTypes.put("webm", "video/webm");
        mimeTypes.put("m4v", "video/x-m4v");
        mimeTypes.put("au", "audio/basic");
        mimeTypes.put("snd", "audio/basic");
        mimeTypes.put("mid", "audio/midi");
        mimeTypes.put("midi", "audio/midi");
        mimeTypes.put("rmi", "audio/midi");
        mimeTypes.put("mp3", "audio/mpeg");
        mimeTypes.put("aif", "audio/x-aiff");
        mimeTypes.put("aifc", "audio/x-aiff");
        mimeTypes.put("aiff", "audio/x-aiff");
        mimeTypes.put("m3u", "audio/x-mpegurl");
        mimeTypes.put("ra", "audio/x-pn-realaudio");
        mimeTypes.put("ram", "audio/x-pn-realaudio");
        mimeTypes.put("wav", "audio/wav");
        mimeTypes.put("wma", "audio/x-ms-wma");
    }
}

