/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.social.connector;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.social.connector.KiiSocialNetworkConnector;
import com.kii.cloud.storage.utils.Log;
import com.kii.cloud.storage.utils.SettingUtils;
import com.kii.cloud.storage.utils.Utils;
import java.io.IOException;
import org.json.JSONException;

public class KiiSocialNetworkConnectorLoginActivity
extends Activity {
    private static final String TAG = "KiiSocialNetworkConnectorLoginActivity";
    static final String KII_ACCESS_TOKEN = "kii_access_token";
    static final String KII_EXPIRES_IN = "kii_expires_in";
    static final String KII_REFRESH_TOKEN = "kii_refresh_token";
    static final String KII_USER_ID = "kii_user_id";
    static final String KII_SUCCEEDED = "kii_succeeded";
    static final String KII_ERROR_CODE = "kii_error_code";
    static final String KII_NEW_USER = "kii_new_user";
    static final String OAUTH_TOKEN = "oauth_token";
    static final String OAUTH_TOKEN_SECRET = "oauth_token_secret";
    static final String OAUTH_TOKEN_EXPIRES_IN = "oauth_token_expires_in";
    static final String OPEN_ID = "openID";
    static final String PROVIDER_USER_ID = "provider_user_id";
    static final String EXTRA_PROVIDER = "provider";
    static final String DISABLE_JAVASCRIPT = "disable_javascript";
    static final String WEBVIEW_ERROR_CODE = "webview_error_code";
    static final String WEBVIEW_ERROR_DESCRIPTION = "webview_error_description";
    static final String OPEN_ID_TOKEN = "id_token";
    static final String OPEN_ID_REFRESH_TOKEN = "refresh_token";
    private String providerName = null;
    private String mAppsBaseURL = null;
    private ProgressDialog pd;

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent it = this.getIntent();
        if (it == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        WebView webView = new WebView((Context)this);
        webView.setWebViewClient((WebViewClient)new KiiSocialNetworkConnectorWebViewClient());
        webView.getSettings().setSavePassword(false);
        webView.getSettings().setUseWideViewPort(true);
        this.setContentView((View)webView);
        this.providerName = it.getStringExtra(EXTRA_PROVIDER);
        if (KiiSocialNetworkConnector.Provider.GOOGLEPLUS.getProviderName().equals(this.providerName) || KiiSocialNetworkConnector.Provider.GOOGLE.getProviderName().equals(this.providerName)) {
            webView.getSettings().setUserAgentString(this.getUserAgent());
        }
        webView.getSettings().setJavaScriptEnabled(!it.getBooleanExtra(DISABLE_JAVASCRIPT, false));
        String webAuthUrl = Utils.path(this.getKiiAppsBaseUrl((Context)this), "apps", Kii.getAppId(), "integration", "webauth", "connect");
        Uri uri = Uri.parse((String)webAuthUrl).buildUpon().appendQueryParameter("id", this.providerName).build();
        Log.v(TAG, "Url:" + uri.toString());
        webView.loadUrl(uri.toString());
        this.pd = ProgressDialog.show((Context)this, null, null, (boolean)true);
        this.pd.setContentView((View)new ProgressBar((Context)this));
    }

    private String getUserAgent() {
        String product = "KiiSDKAndroid";
        String version = Kii.getSDKVersion();
        return product + "/" + version;
    }

    private synchronized String getKiiAppsBaseUrl(Context context) {
        if (!TextUtils.isEmpty((CharSequence)this.mAppsBaseURL)) {
            return this.mAppsBaseURL;
        }
        String kiiappsBaseUrl = Kii.getKiiAppsBaseURL();
        if (kiiappsBaseUrl != null) {
            this.mAppsBaseURL = kiiappsBaseUrl;
            return this.mAppsBaseURL;
        }
        try {
            this.mAppsBaseURL = SettingUtils.getKiiAppsBaseUrl(context);
            return this.mAppsBaseURL;
        }
        catch (IOException | JSONException e) {
            throw new RuntimeException("Unsupported base URL", e);
        }
    }

    class KiiSocialNetworkConnectorWebViewClient
    extends WebViewClient {
        KiiSocialNetworkConnectorWebViewClient() {
        }

        public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
            try {
                String[] auth = SettingUtils.getHttpAuth(view.getContext());
                if (auth != null) {
                    handler.proceed(auth[0], auth[1]);
                } else {
                    super.onReceivedHttpAuthRequest(view, handler, host, realm);
                }
            }
            catch (IOException | JSONException e) {
                super.onReceivedHttpAuthRequest(view, handler, host, realm);
            }
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            super.onReceivedSslError(view, handler, error);
        }

        public void onLoadResource(WebView view, String url) {
            String resultUrl = Utils.path(KiiSocialNetworkConnectorLoginActivity.this.getKiiAppsBaseUrl(view.getContext()), "apps", Kii.getAppId(), "integration", "webauth", "result");
            Uri uri = Uri.parse((String)url);
            if (uri.toString().startsWith(resultUrl)) {
                view.stopLoading();
            }
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            Intent intent = new Intent();
            intent.putExtra(KiiSocialNetworkConnectorLoginActivity.WEBVIEW_ERROR_CODE, errorCode);
            intent.putExtra(KiiSocialNetworkConnectorLoginActivity.WEBVIEW_ERROR_DESCRIPTION, description);
            KiiSocialNetworkConnectorLoginActivity.this.setResult(1, intent);
            KiiSocialNetworkConnectorLoginActivity.this.finish();
        }

        public void onPageFinished(WebView view, String url) {
            String resultUrl = Utils.path(KiiSocialNetworkConnectorLoginActivity.this.getKiiAppsBaseUrl(view.getContext()), "apps", Kii.getAppId(), "integration", "webauth", "result");
            Uri uri = Uri.parse((String)url);
            if (KiiSocialNetworkConnectorLoginActivity.this.pd.isShowing()) {
                KiiSocialNetworkConnectorLoginActivity.this.pd.dismiss();
            }
            if (!uri.toString().startsWith(resultUrl)) {
                return;
            }
            Log.v(KiiSocialNetworkConnectorLoginActivity.TAG, "Webview finished url:" + url);
            Intent data = new Intent();
            boolean succeeded = Boolean.parseBoolean(uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.KII_SUCCEEDED));
            data.putExtra(KiiSocialNetworkConnectorLoginActivity.KII_SUCCEEDED, succeeded);
            if (succeeded) {
                long expiresIn;
                data.putExtra(KiiSocialNetworkConnectorLoginActivity.KII_ACCESS_TOKEN, uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.KII_ACCESS_TOKEN));
                if (!Utils.isEmpty(uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.KII_EXPIRES_IN))) {
                    expiresIn = Long.parseLong(uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.KII_EXPIRES_IN));
                    data.putExtra(KiiSocialNetworkConnectorLoginActivity.KII_EXPIRES_IN, expiresIn);
                }
                if (!Utils.isEmpty(uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.KII_REFRESH_TOKEN))) {
                    data.putExtra(KiiSocialNetworkConnectorLoginActivity.KII_REFRESH_TOKEN, uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.KII_REFRESH_TOKEN));
                }
                data.putExtra(KiiSocialNetworkConnectorLoginActivity.KII_USER_ID, uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.KII_USER_ID));
                data.putExtra(KiiSocialNetworkConnectorLoginActivity.OAUTH_TOKEN, uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.OAUTH_TOKEN));
                if (!Utils.isEmpty(uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.OAUTH_TOKEN_SECRET))) {
                    data.putExtra(KiiSocialNetworkConnectorLoginActivity.OAUTH_TOKEN_SECRET, uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.OAUTH_TOKEN_SECRET));
                }
                if (!Utils.isEmpty(uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.OAUTH_TOKEN_EXPIRES_IN))) {
                    expiresIn = Long.parseLong(uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.OAUTH_TOKEN_EXPIRES_IN));
                    data.putExtra(KiiSocialNetworkConnectorLoginActivity.OAUTH_TOKEN_EXPIRES_IN, expiresIn);
                }
                data.putExtra(KiiSocialNetworkConnectorLoginActivity.PROVIDER_USER_ID, uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.PROVIDER_USER_ID));
                data.putExtra(KiiSocialNetworkConnectorLoginActivity.KII_NEW_USER, Boolean.parseBoolean(uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.KII_NEW_USER)));
                if (KiiSocialNetworkConnector.Provider.OPENID_CONNECT_SIMPLE.getProviderName().equals(KiiSocialNetworkConnectorLoginActivity.this.providerName)) {
                    data.putExtra(KiiSocialNetworkConnectorLoginActivity.OPEN_ID_TOKEN, uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.OPEN_ID_TOKEN));
                    if (!Utils.isEmpty(uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.OPEN_ID_REFRESH_TOKEN))) {
                        data.putExtra(KiiSocialNetworkConnectorLoginActivity.OPEN_ID_REFRESH_TOKEN, uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.OPEN_ID_REFRESH_TOKEN));
                    }
                } else if (KiiSocialNetworkConnector.Provider.RESERVED1.getProviderName().equals(KiiSocialNetworkConnectorLoginActivity.this.providerName) && !Utils.isEmpty(uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.OPEN_ID_REFRESH_TOKEN))) {
                    data.putExtra(KiiSocialNetworkConnectorLoginActivity.OPEN_ID_REFRESH_TOKEN, uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.OPEN_ID_REFRESH_TOKEN));
                }
            } else {
                data.putExtra(KiiSocialNetworkConnectorLoginActivity.KII_ERROR_CODE, uri.getQueryParameter(KiiSocialNetworkConnectorLoginActivity.KII_ERROR_CODE));
            }
            KiiSocialNetworkConnectorLoginActivity.this.setResult(-1, data);
            KiiSocialNetworkConnectorLoginActivity.this.finish();
        }
    }
}

