/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.social.connector;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.async.executor.KiiTaskExecutor;
import com.kii.cloud.async.executor.KiiUncancelabeTask;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.KiiInternalUtil;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage._KiiUserInternalBridge;
import com.kii.cloud.storage.callback.KiiSocialCallBack;
import com.kii.cloud.storage.engine.ApiResponse;
import com.kii.cloud.storage.engine.KiiCloudEngine;
import com.kii.cloud.storage.exception.IllegalKiiBaseObjectFormatException;
import com.kii.cloud.storage.exception.app.AppException;
import com.kii.cloud.storage.exception.social.OAuthException;
import com.kii.cloud.storage.exception.social.SocialException;
import com.kii.cloud.storage.exception.social.UserCancelException;
import com.kii.cloud.storage.social.KiiSocialConnect;
import com.kii.cloud.storage.social.connector.KiiSocialNetworkConnectorLoginActivity;
import com.kii.cloud.storage.utils.Utils;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.json.JSONException;
import org.json.JSONObject;

public class KiiSocialNetworkConnector
implements KiiSocialConnect {
    private static final String TAG = "KiiSocialNetworkConnector";
    public static final String PROVIDER = "provider";
    public static final String ACCESS_TOKEN = "accessToken";
    public static final String ACCESS_TOKEN_SECRET = "accessTokenSecret";
    public static final String OPEN_ID = "openID";
    public static final String DISABLE_JAVASCRIPT = "disableJavascript";
    public static final int REQUEST_CODE = 32667;
    private KiiSocialCallBack mCallback = null;
    private ThreadPoolExecutor tpe = new ThreadPoolExecutor(10, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
    @Deprecated
    private Class<?> loginActivity = KiiSocialNetworkConnectorLoginActivity.class;

    private KiiSocialNetworkConnector() {
    }

    static KiiSocialNetworkConnector newInstance() {
        return new KiiSocialNetworkConnector();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void logIn(@Nullable Activity activity, @NonNull Bundle options, @NonNull KiiSocialCallBack callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        try {
            Provider provider = this.validateBundle(options);
            JSONObject requestEntity = this.createSocialIntegrationRequest(provider, options);
            if (requestEntity == null) {
                Object disableJavascript = options.get(DISABLE_JAVASCRIPT);
                if (disableJavascript != null) {
                    if (!(disableJavascript instanceof Boolean)) throw new IllegalArgumentException(String.format("value of %s should be boolean", DISABLE_JAVASCRIPT));
                    this.logIn(activity, provider, callback, (Boolean)disableJavascript);
                    return;
                } else {
                    this.logIn(activity, provider, callback);
                }
                return;
            } else {
                this.logInWithSocialProvider(provider, requestEntity, callback);
            }
            return;
        }
        catch (Exception e) {
            callback.onLoginCompleted(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR, null, e);
        }
    }

    private void logInWithSocialProvider(final Provider provider, final JSONObject requestEntity, final KiiSocialCallBack callback) {
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){
            private KiiUser user = null;

            @Override
            public void run() {
                try {
                    if (KiiUser.getCurrentUser() != null) {
                        KiiUser.logOut();
                    }
                    long expiresAt = 0L;
                    try {
                        long tokenExpiration = Kii.getAccessTokenExpiration();
                        if (tokenExpiration > 0L) {
                            expiresAt = KiiInternalUtil.safeCalculateExpiresAt(tokenExpiration, System.currentTimeMillis());
                            requestEntity.put("expiresAt", expiresAt);
                        }
                    }
                    catch (JSONException tokenExpiration) {
                        // empty catch block
                    }
                    String providerName = provider.getProviderName();
                    if (provider == Provider.GOOGLEPLUS) {
                        providerName = Provider.GOOGLE.getProviderName();
                    }
                    String postUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "integration", providerName);
                    HttpPost request = new HttpPost(postUrl);
                    request.setHeader("X-Kii-AppID", Kii.getAppId());
                    request.setHeader("X-Kii-AppKey", Kii.getAppKey());
                    request.setHeader("Content-Type", provider.getAuthRequestContentType());
                    request.setEntity((HttpEntity)new StringEntity(requestEntity.toString(), "UTF-8"));
                    ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
                    if (response == null) {
                        IllegalKiiBaseObjectFormatException ife = new IllegalKiiBaseObjectFormatException("Response format is null");
                        throw ife;
                    }
                    try {
                        JSONObject respObj = new JSONObject(response.body);
                        String userId = respObj.getString("id");
                        String accessToken = respObj.getString("access_token");
                        String refreshToken = respObj.optString("refresh_token", null);
                        String accessTokenSecret = requestEntity.optString(KiiSocialNetworkConnector.ACCESS_TOKEN_SECRET, null);
                        String openID = requestEntity.optString(KiiSocialNetworkConnector.OPEN_ID, null);
                        boolean kiiNewUser = respObj.optBoolean("new_user_created", false);
                        String url = Utils.path("kiicloud://", "users", userId);
                        long expiresIn = respObj.getLong("expires_in");
                        expiresAt = KiiInternalUtil.safeCalculateExpiresAt(expiresIn, System.currentTimeMillis());
                        KiiUser user = KiiUser.createByUri(Uri.parse((String)url));
                        KiiInternalUtil.setCurrentUser(user);
                        KiiCloudEngine.updateAccessToken(accessToken);
                        _KiiUserInternalBridge.updateKiiUserRefreshToken(refreshToken);
                        _KiiUserInternalBridge.updateKiiUserAccessExpires(expiresAt);
                        user.refresh();
                        KiiSocialNetworkConnector.this.updateAccessTokenBundle(requestEntity.getString(KiiSocialNetworkConnector.ACCESS_TOKEN), accessTokenSecret, openID, null, kiiNewUser, null, null, null);
                        this.user = user;
                    }
                    catch (JSONException e) {
                        IllegalKiiBaseObjectFormatException ife = new IllegalKiiBaseObjectFormatException("Response format is invalid");
                        throw ife;
                    }
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onLoginCompleted(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR, this.user, this.getException());
            }
        });
    }

    private Provider validateBundle(Bundle options) {
        if (options == null) {
            throw new IllegalArgumentException("specified option is null");
        }
        if (!options.containsKey(PROVIDER)) {
            throw new IllegalArgumentException("Options does not contain \"provider\"");
        }
        Parcelable p = options.getParcelable(PROVIDER);
        if (!(p instanceof Provider)) {
            throw new IllegalArgumentException("Options should be Provider");
        }
        return (Provider)p;
    }

    private JSONObject createSocialIntegrationRequest(Provider provider, Bundle options) {
        if (options.containsKey(ACCESS_TOKEN)) {
            if (provider == Provider.GOOGLEPLUS || provider == Provider.GOOGLE || provider == Provider.FACEBOOK || provider == Provider.RENREN) {
                if (!Utils.isEmpty(options.getString(ACCESS_TOKEN))) {
                    JSONObject requestEntity = new JSONObject();
                    try {
                        requestEntity.put(ACCESS_TOKEN, (Object)options.getString(ACCESS_TOKEN));
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    return requestEntity;
                }
                throw new IllegalArgumentException("Options does not contain \"accessToken\"");
            }
            if (provider == Provider.TWITTER) {
                if (!Utils.isEmpty(options.getString(ACCESS_TOKEN)) && !Utils.isEmpty(options.getString(ACCESS_TOKEN_SECRET))) {
                    JSONObject requestEntity = new JSONObject();
                    try {
                        requestEntity.put(ACCESS_TOKEN, (Object)options.getString(ACCESS_TOKEN));
                        requestEntity.put(ACCESS_TOKEN_SECRET, (Object)options.getString(ACCESS_TOKEN_SECRET));
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    return requestEntity;
                }
                throw new IllegalArgumentException("Options does not contain \"accessToken\" and \"accessTokenSecret\"");
            }
            if (provider == Provider.QQ) {
                if (!Utils.isEmpty(options.getString(ACCESS_TOKEN)) && !Utils.isEmpty(options.getString(OPEN_ID))) {
                    JSONObject requestEntity = new JSONObject();
                    try {
                        requestEntity.put(ACCESS_TOKEN, (Object)options.getString(ACCESS_TOKEN));
                        requestEntity.put(OPEN_ID, (Object)options.getString(OPEN_ID));
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    return requestEntity;
                }
                throw new IllegalArgumentException("Options does not contain \"accessToken\" and \"openID\"");
            }
            throw new UnsupportedOperationException("login with" + provider.getProviderName() + " access token is not supported");
        }
        return null;
    }

    public void logIn(@NonNull Activity activity, @NonNull Provider provider, @NonNull KiiSocialCallBack callback) {
        this.logIn(activity, provider, callback, Boolean.FALSE);
    }

    private void logIn(@NonNull Activity activity, @NonNull Provider provider, @NonNull KiiSocialCallBack callback, @NonNull Boolean disableJavaScript) {
        if (activity == null) {
            throw new IllegalArgumentException("SocialNetworkConnection called with null activity.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Provider is null");
        }
        if (provider == Provider.QQ) {
            throw new UnsupportedOperationException("QQ is not supported");
        }
        this.mCallback = callback;
        Intent it = new Intent((Context)activity, this.loginActivity);
        it.putExtra("disable_javascript", (Serializable)disableJavaScript);
        it.putExtra(PROVIDER, provider.getProviderName());
        activity.startActivityForResult(it, 32667);
    }

    @Override
    public boolean isLinked() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void link(@Nullable Activity activity, @NonNull Bundle options, @NonNull KiiSocialCallBack callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        try {
            Provider provider = this.validateBundle(options);
            JSONObject requestEntity = this.createSocialIntegrationRequest(provider, options);
            if (requestEntity == null) {
                throw new IllegalArgumentException("Options does not contain \"accessToken\"");
            }
            this.linkSocialProvider(provider, requestEntity, callback);
        }
        catch (Exception e) {
            callback.onLinkCompleted(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR, null, e);
        }
    }

    @Override
    public void unlink(@Nullable Activity activity, @NonNull Bundle options, @NonNull KiiSocialCallBack callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        try {
            Provider provider = this.validateBundle(options);
            if (provider != Provider.GOOGLEPLUS && provider != Provider.GOOGLE && provider != Provider.FACEBOOK && provider != Provider.TWITTER && provider != Provider.RENREN && provider != Provider.QQ) {
                throw new UnsupportedOperationException("unlink with " + provider.getProviderName() + " is not supported");
            }
            this.unlinkSocialProvider(provider, callback);
        }
        catch (Exception e) {
            callback.onUnLinkCompleted(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR, null, e);
        }
    }

    private void linkSocialProvider(final Provider provider, final JSONObject requestEntity, final KiiSocialCallBack callback) {
        try {
            Utils.checkInitialize(true);
        }
        catch (Exception e) {
            callback.onLinkCompleted(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR, KiiUser.getCurrentUser(), e);
            return;
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){
            private KiiUser user = null;

            @Override
            public void run() {
                try {
                    String providerName = provider.getProviderName();
                    if (provider == Provider.GOOGLEPLUS) {
                        providerName = Provider.GOOGLE.getProviderName();
                    }
                    String url = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", "me", providerName, "link");
                    HttpPost request = new HttpPost(url);
                    request.setHeader("X-Kii-AppID", Kii.getAppId());
                    request.setHeader("X-Kii-AppKey", Kii.getAppKey());
                    KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
                    request.setHeader("Content-Type", provider.getLinkRequestContentType());
                    request.setEntity((HttpEntity)new StringEntity(requestEntity.toString(), "UTF-8"));
                    KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
                    KiiUser user = KiiUser.getCurrentUser();
                    user.refresh();
                    String accessTokenSecret = requestEntity.optString(KiiSocialNetworkConnector.ACCESS_TOKEN_SECRET, null);
                    String openID = requestEntity.optString(KiiSocialNetworkConnector.OPEN_ID, null);
                    KiiSocialNetworkConnector.this.updateAccessTokenBundle(requestEntity.getString(KiiSocialNetworkConnector.ACCESS_TOKEN), accessTokenSecret, openID, null, false, null, null, null);
                    this.user = user;
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onLinkCompleted(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR, this.user, this.getException());
            }
        });
    }

    private void unlinkSocialProvider(final Provider provider, final KiiSocialCallBack callback) {
        try {
            Utils.checkInitialize(true);
        }
        catch (Exception e) {
            callback.onUnLinkCompleted(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR, KiiUser.getCurrentUser(), e);
            return;
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){
            private KiiUser user = null;

            @Override
            public void run() {
                try {
                    String providerName = provider.getProviderName();
                    if (provider == Provider.GOOGLEPLUS) {
                        providerName = Provider.GOOGLE.getProviderName();
                    }
                    String url = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", "me", providerName, "unlink");
                    HttpPost request = new HttpPost(url);
                    request.setHeader("X-Kii-AppID", Kii.getAppId());
                    request.setHeader("X-Kii-AppKey", Kii.getAppKey());
                    KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
                    KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
                    KiiUser user = KiiUser.getCurrentUser();
                    user.refresh();
                    _KiiUserInternalBridge.clearSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR);
                    this.user = user;
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onUnLinkCompleted(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR, this.user, this.getException());
            }
        });
    }

    @Override
    public void respondAuthOnActivityResult(int requestCode, int resultCode, @NonNull Intent data) {
        if (requestCode != 32667) {
            return;
        }
        if (resultCode == 0) {
            this.mCallback.onLoginCompleted(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR, null, new UserCancelException());
            return;
        }
        if (data == null) {
            this.mCallback.onLoginCompleted(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR, null, new IllegalArgumentException("data is null"));
            return;
        }
        if (resultCode == 1) {
            String errorMessage = data.getStringExtra("webview_error_description");
            this.mCallback.onLoginCompleted(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR, null, new OAuthException(errorMessage));
            return;
        }
        boolean succeeded = data.getBooleanExtra("kii_succeeded", false);
        if (succeeded) {
            String kiiAccessToken = data.getStringExtra("kii_access_token");
            String kiiRefreshToken = data.getStringExtra("kii_refresh_token");
            long expiresIn = data.getLongExtra("kii_expires_in", 0L);
            if (expiresIn == 0L) {
                expiresIn = Integer.MAX_VALUE;
            }
            long currentTimeMillis = System.currentTimeMillis();
            long expiresAt = KiiInternalUtil.safeCalculateExpiresAt(expiresIn, currentTimeMillis);
            String userId = data.getStringExtra("kii_user_id");
            String accessToken = data.getStringExtra("oauth_token");
            String accessTokenSecret = data.getStringExtra("oauth_token_secret");
            String providerUserId = data.getStringExtra("provider_user_id");
            Long oauthTokenExpiresIn = null;
            if (data.hasExtra("oauth_token_expires_in")) {
                oauthTokenExpiresIn = data.getLongExtra("oauth_token_expires_in", 0L);
            }
            boolean kiiNewUser = data.getBooleanExtra("kii_new_user", false);
            String idToken = data.getStringExtra("id_token");
            String idRefreshToken = data.getStringExtra("refresh_token");
            String url = Utils.path("kiicloud://", "users", userId);
            KiiUser user = KiiUser.createByUri(Uri.parse((String)url));
            KiiInternalUtil.setCurrentUser(user);
            KiiCloudEngine.updateAccessToken(kiiAccessToken);
            _KiiUserInternalBridge.updateKiiUserRefreshToken(kiiRefreshToken);
            _KiiUserInternalBridge.updateKiiUserAccessExpires(expiresAt);
            this.updateAccessTokenBundle(accessToken, accessTokenSecret, null, providerUserId, kiiNewUser, oauthTokenExpiresIn, idToken, idRefreshToken);
            this.refreshUser(user);
        } else {
            String errorCode = data.getStringExtra("kii_error_code");
            if ("UNAUTHORIZED".equals(errorCode)) {
                this.mCallback.onLoginCompleted(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR, null, new OAuthException("authorization credentials are rejected by provider"));
            } else {
                this.mCallback.onLoginCompleted(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR, null, new SocialException("login failed with error: " + errorCode, null));
            }
        }
    }

    private void refreshUser(final KiiUser user) {
        Callable<KiiUser> task = new Callable<KiiUser>(){

            @Override
            public KiiUser call() throws AppException, SocialException, IOException {
                user.refresh();
                return user;
            }
        };
        Future<KiiUser> future = this.tpe.submit(task);
        try {
            KiiUser refreshedUser = future.get();
            this.mCallback.onLoginCompleted(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR, refreshedUser, null);
            return;
        }
        catch (InterruptedException e) {
            this.clearAccessToken();
            this.mCallback.onLoginCompleted(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR, null, new SocialException("Login operation has been interrupted.", e));
            return;
        }
        catch (ExecutionException e) {
            this.clearAccessToken();
            if (e.getCause() != null) {
                this.mCallback.onLoginCompleted(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR, null, (Exception)e.getCause());
            } else {
                this.mCallback.onLoginCompleted(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR, null, new SocialException("Login operation failed.", e));
            }
            return;
        }
    }

    @Override
    @Nullable
    public Bundle getAccessTokenBundle() {
        return _KiiUserInternalBridge.getSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR);
    }

    private void updateAccessTokenBundle(String accessToken, String accessTokenSecret, String openID, String providerUserId, boolean kiiNewUser, Long expiresIn, String id_token, String id_refresh_token) {
        if (accessToken == null) {
            return;
        }
        Bundle b = new Bundle();
        b.putString("oauth_token", accessToken);
        if (accessTokenSecret != null) {
            b.putString("oauth_token_secret", accessTokenSecret);
        }
        if (openID != null) {
            b.putString(OPEN_ID, openID);
        }
        if (providerUserId != null) {
            b.putString("provider_user_id", providerUserId);
        }
        if (expiresIn != null) {
            b.putLong("oauth_token_expires_in", expiresIn.longValue());
        }
        b.putBoolean("kii_new_user", kiiNewUser);
        if (id_token != null) {
            b.putString("id_token", id_token);
        }
        if (id_refresh_token != null) {
            b.putString("refresh_token", id_refresh_token);
        }
        _KiiUserInternalBridge.updateSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR, b);
    }

    @Override
    @Nullable
    public String getAccessToken() {
        Bundle tokenBundle = _KiiUserInternalBridge.getSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR);
        if (tokenBundle == null) {
            return null;
        }
        return tokenBundle.getString("oauth_token");
    }

    void clearAccessToken() {
        _KiiUserInternalBridge.clearSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork.SOCIALNETWORK_CONNECTOR);
    }

    @Override
    public long getAccessExpires() {
        return 0L;
    }

    @Override
    public void initialize(@Nullable String consumerKey, @Nullable String consumerSecret, @Nullable Bundle options) {
    }

    public static enum Provider implements Parcelable
    {
        FACEBOOK("facebook"),
        TWITTER("twitter"),
        LINKEDIN("linkedin"),
        YAHOO("yahoo"),
        GOOGLE("google"),
        GOOGLEPLUS("googleplus"),
        DROPBOX("dropbox"),
        BOX("box"),
        RENREN("renren"),
        SINA("sina"),
        LIVE("live"),
        YOUWILL("youwill"),
        QQ("qq"),
        OPENID_CONNECT_SIMPLE("openidconnect.simple"),
        RESERVED1("reserved1"),
        KII("kii");

        private String providerName;
        public static final Parcelable.Creator<Provider> CREATOR;

        private Provider(String providerName) {
            this.providerName = providerName;
        }

        @NonNull
        public String getProviderName() {
            switch (this) {
                case RESERVED1: {
                    return Kii.getReservedProvider1();
                }
            }
            return this.providerName;
        }

        @NonNull
        public String getLinkRequestContentType() {
            if (this == RENREN) {
                return "application/vnd.kii.LinkRenRenRequest+json";
            }
            if (this == QQ) {
                return "application/vnd.kii.LinkQQRequest+json";
            }
            if (this == GOOGLEPLUS) {
                return "application/vnd.kii.LinkGoogleRequest+json";
            }
            return "application/vnd.kii.Link" + Utils.capitalize(this.providerName) + "Request+json";
        }

        @NonNull
        public String getAuthRequestContentType() {
            if (this == RENREN) {
                return "application/vnd.kii.AuthTokenRenRenRequest+json";
            }
            if (this == QQ) {
                return "application/vnd.kii.AuthTokenQQRequest+json";
            }
            if (this == GOOGLEPLUS) {
                return "application/vnd.kii.AuthTokenGoogleRequest+json";
            }
            return "application/vnd.kii.AuthToken" + Utils.capitalize(this.providerName) + "Request+json";
        }

        @NonNull
        public String getProviderLinkedSocialNetworkName() {
            return this == GOOGLE ? "googleplus" : (this == LIVE ? "hotmail" : this.providerName);
        }

        static Provider providerWithLinkedSocialNetworkName(String name) {
            String providerName;
            String string = "google".equals(name) ? "googleplus" : (providerName = "hotmail".equals(name) ? LIVE.getProviderName() : name);
            if ("openidconnect.simple".equals(name)) {
                providerName = "openid_connect_simple";
            }
            if (providerName.equals(Kii.getReservedProvider1())) {
                return RESERVED1;
            }
            return Provider.valueOf(providerName.toUpperCase(Locale.ENGLISH));
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<Provider>(){

                public Provider createFromParcel(Parcel in) {
                    return Provider.values()[in.readInt()];
                }

                public Provider[] newArray(int size) {
                    return new Provider[size];
                }
            };
        }
    }
}

