/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.social;

import android.app.Activity;
import android.net.Uri;
import android.os.Bundle;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.KiiInternalUtil;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage._KiiUserInternalBridge;
import com.kii.cloud.storage.callback.KiiSocialCallBack;
import com.kii.cloud.storage.engine.ApiResponse;
import com.kii.cloud.storage.engine.KiiCloudEngine;
import com.kii.cloud.storage.exception.IllegalKiiBaseObjectFormatException;
import com.kii.cloud.storage.exception.app.AppException;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.exception.social.SocialException;
import com.kii.cloud.storage.social.KiiSocialConnect;
import com.kii.cloud.storage.utils.Utils;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class KiiBaseSocialConnect {
    private ThreadPoolExecutor tpe = new ThreadPoolExecutor(10, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));

    protected KiiBaseSocialConnect() {
    }

    protected void login(final JSONObject requestObject, final KiiSocialCallBack callback) {
        final Bundle b = new Bundle();
        Callable<KiiUser> loginTask = new Callable<KiiUser>(){

            @Override
            public KiiUser call() throws AppException, SocialException, IOException {
                KiiUser user = KiiBaseSocialConnect.this.loginInner(requestObject, callback, b);
                return user;
            }
        };
        Future<KiiUser> loginFuture = this.tpe.submit(loginTask);
        try {
            KiiUser user = loginFuture.get();
            this.onLoginCompleted(requestObject, b);
            callback.onLoginCompleted(this.getNetwork(), user, null);
            return;
        }
        catch (InterruptedException e) {
            callback.onLoginCompleted(this.getNetwork(), null, e);
            return;
        }
        catch (ExecutionException e) {
            if (e.getCause() != null) {
                callback.onLoginCompleted(this.getNetwork(), null, (Exception)e.getCause());
            } else {
                callback.onLoginCompleted(this.getNetwork(), null, e);
            }
            return;
        }
    }

    private KiiUser loginInner(JSONObject requestObject, KiiSocialCallBack callback, Bundle tokenBundle) throws BadRequestException, ConflictException, ForbiddenException, NotFoundException, UnauthorizedException, UndefinedException, IOException, SocialException {
        if (KiiUser.getCurrentUser() != null) {
            KiiUser.logOut();
        }
        long tokenExpiration = Kii.getAccessTokenExpiration();
        long expiresAt = 0L;
        if (tokenExpiration > 0L) {
            try {
                expiresAt = KiiInternalUtil.safeCalculateExpiresAt(tokenExpiration, System.currentTimeMillis());
                requestObject.put("expiresAt", expiresAt);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        ApiResponse response = null;
        try {
            response = this.requestLoginUFE(requestObject);
        }
        catch (JSONException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Token is invalid");
            throw iae;
        }
        if (response == null) {
            IllegalKiiBaseObjectFormatException ife = new IllegalKiiBaseObjectFormatException("Response format is null");
            throw ife;
        }
        try {
            JSONObject respObj = new JSONObject(response.body);
            String userId = respObj.getString("id");
            String accessToken = respObj.getString("access_token");
            String refreshToken = respObj.optString("refresh_token", null);
            String url = Utils.path("kiicloud://", "users", userId);
            tokenBundle.putBoolean("kii_new_user", respObj.getBoolean("new_user_created"));
            long expiresIn = respObj.getLong("expires_in");
            expiresAt = KiiInternalUtil.safeCalculateExpiresAt(expiresIn, System.currentTimeMillis());
            KiiUser user = KiiUser.createByUri(Uri.parse((String)url));
            KiiInternalUtil.setCurrentUser(user);
            KiiCloudEngine.updateAccessToken(accessToken);
            _KiiUserInternalBridge.updateKiiUserRefreshToken(refreshToken);
            _KiiUserInternalBridge.updateKiiUserAccessExpires(expiresAt);
            user.refresh();
            return user;
        }
        catch (JSONException e) {
            IllegalKiiBaseObjectFormatException ife = new IllegalKiiBaseObjectFormatException("Response format is invalid");
            throw ife;
        }
    }

    private ApiResponse requestLoginUFE(JSONObject requestEntity) throws BadRequestException, ConflictException, ForbiddenException, NotFoundException, UnauthorizedException, UndefinedException, IOException, SocialException, JSONException {
        String postUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "integration", this.getSocialNetworkName());
        HttpPost request = new HttpPost(postUrl);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("Content-Type", this.getLoginContentType());
        request.setEntity((HttpEntity)new StringEntity(requestEntity.toString(), "UTF-8"));
        ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        return response;
    }

    protected void link(final JSONObject requestJson, final KiiSocialCallBack callback) {
        Callable<KiiUser> linkTask = new Callable<KiiUser>(){

            @Override
            public KiiUser call() throws AppException, SocialException, IOException {
                KiiUser user = KiiBaseSocialConnect.this.linkInner(requestJson, callback);
                return user;
            }
        };
        Future<KiiUser> linkFuture = this.tpe.submit(linkTask);
        try {
            KiiUser user = linkFuture.get();
            this.onLinkCompleted(requestJson);
            callback.onLinkCompleted(this.getNetwork(), user, null);
        }
        catch (InterruptedException e) {
            callback.onLinkCompleted(this.getNetwork(), KiiUser.getCurrentUser(), e);
        }
        catch (ExecutionException e) {
            if (e.getCause() != null) {
                callback.onLinkCompleted(this.getNetwork(), KiiUser.getCurrentUser(), (Exception)e.getCause());
            }
            callback.onLinkCompleted(this.getNetwork(), KiiUser.getCurrentUser(), e);
        }
    }

    private KiiUser linkInner(JSONObject requestJson, KiiSocialCallBack callback) throws BadRequestException, ConflictException, ForbiddenException, NotFoundException, UnauthorizedException, UndefinedException, IOException, SocialException {
        try {
            KiiUser user = this.requestLinkUFE(requestJson);
            return user;
        }
        catch (JSONException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Token is invalid");
            throw iae;
        }
    }

    private KiiUser requestLinkUFE(JSONObject requestEntity) throws BadRequestException, ConflictException, ForbiddenException, NotFoundException, UnauthorizedException, UndefinedException, IOException, SocialException, JSONException {
        String postUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", "me", this.getSocialNetworkName(), "link");
        HttpPost request = new HttpPost(postUrl);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("Content-Type", this.getLinkContentType());
        request.setEntity((HttpEntity)new StringEntity(requestEntity.toString(), "UTF-8"));
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        KiiUser user = KiiUser.getCurrentUser();
        user.refresh();
        return user;
    }

    protected void unlink(final Activity activity, final KiiSocialCallBack callback) {
        Callable<KiiUser> unlinkTask = new Callable<KiiUser>(){

            @Override
            public KiiUser call() throws AppException, SocialException, IOException {
                KiiUser user = KiiBaseSocialConnect.this.unlinkInner(activity, callback);
                return user;
            }
        };
        Future<KiiUser> unlinkFuture = this.tpe.submit(unlinkTask);
        try {
            KiiUser user = unlinkFuture.get();
            this.onUnlinkCompleted();
            callback.onUnLinkCompleted(this.getNetwork(), user, null);
        }
        catch (InterruptedException e) {
            callback.onUnLinkCompleted(this.getNetwork(), null, e);
        }
        catch (ExecutionException e) {
            if (e.getCause() != null) {
                callback.onUnLinkCompleted(this.getNetwork(), null, (Exception)e.getCause());
            }
            callback.onUnLinkCompleted(this.getNetwork(), null, e);
        }
    }

    private KiiUser unlinkInner(Activity activity, KiiSocialCallBack callback) throws BadRequestException, ConflictException, ForbiddenException, NotFoundException, UnauthorizedException, UndefinedException, IOException, SocialException {
        this.onPreUnlink(activity);
        KiiUser user = this.requestUnlinkUFE();
        return user;
    }

    private KiiUser requestUnlinkUFE() throws BadRequestException, ConflictException, ForbiddenException, NotFoundException, UnauthorizedException, UndefinedException, IOException, SocialException {
        String postUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", "me", this.getSocialNetworkName(), "unlink");
        HttpPost request = new HttpPost(postUrl);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        KiiUser user = KiiUser.getCurrentUser();
        user.refresh();
        return user;
    }

    protected void callCompleteCallbackOnFailure(KiiSocialCallBack callback, Exception exp, Type type) {
        if (type == Type.LOGIN) {
            callback.onLoginCompleted(this.getNetwork(), null, exp);
        } else {
            callback.onLinkCompleted(this.getNetwork(), KiiUser.getCurrentUser(), exp);
        }
    }

    protected abstract String getSocialNetworkName();

    protected abstract String getLoginContentType();

    protected abstract String getLinkContentType();

    protected abstract KiiSocialConnect.SocialNetwork getNetwork();

    protected abstract void onLoginCompleted(JSONObject var1, Bundle var2);

    protected abstract void onLinkCompleted(JSONObject var1);

    protected abstract void onPreUnlink(Activity var1) throws IOException, SocialException;

    protected abstract void onUnlinkCompleted();

    protected static enum Type {
        LOGIN,
        LINK;

    }
}

