/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import android.net.Uri;
import android.support.annotation.NonNull;
import com.kii.cloud.storage.resumabletransfer.InvalidHolderException;
import com.kii.cloud.storage.resumabletransfer.impl.KiiUploaderImpl;
import java.util.WeakHashMap;
import java.util.concurrent.Semaphore;

public class UploaderSemaphore {
    private static WeakHashMap<Uri, Semaphore> map = new WeakHashMap();

    @NonNull
    public static synchronized Semaphore getSemaphore(@NonNull KiiUploaderImpl uploader) throws InvalidHolderException {
        Uri uri = uploader.getHolderUri();
        if (map.containsKey(uri)) {
            return map.get(uri);
        }
        Uri noncahced_uri = uploader.getFileHolderInternal().getHolderUri();
        if (map.containsKey(noncahced_uri)) {
            return map.get(noncahced_uri);
        }
        Semaphore sem = new Semaphore(1);
        map.put(uri, sem);
        return sem;
    }

    public static synchronized void onRealUriGenerated(@NonNull KiiUploaderImpl uploader, @NonNull Uri realUri) {
        Uri uri = uploader.getHolderUri();
        if (map.containsKey(uri)) {
            Semaphore sem = map.get(uri);
            map.remove(uri);
            map.put(realUri, sem);
        }
    }
}

