/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.FileHolder;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.resumabletransfer.AlreadyStartedException;
import com.kii.cloud.storage.resumabletransfer.InvalidHolderException;
import com.kii.cloud.storage.resumabletransfer.KiiRTransferCallback;
import com.kii.cloud.storage.resumabletransfer.KiiRTransferInfo;
import com.kii.cloud.storage.resumabletransfer.KiiRTransferProgressCallback;
import com.kii.cloud.storage.resumabletransfer.KiiRTransferStatus;
import com.kii.cloud.storage.resumabletransfer.KiiUploader;
import com.kii.cloud.storage.resumabletransfer.NoEntryException;
import com.kii.cloud.storage.resumabletransfer.StateStoreAccessException;
import com.kii.cloud.storage.resumabletransfer.SuspendedException;
import com.kii.cloud.storage.resumabletransfer.TerminatedException;
import com.kii.cloud.storage.resumabletransfer.impl.FileHolderInternal;
import com.kii.cloud.storage.resumabletransfer.impl.HashGenerator;
import com.kii.cloud.storage.resumabletransfer.impl.RTransferCommonLogic;
import com.kii.cloud.storage.resumabletransfer.impl.RTransferUploadInfoStore;
import com.kii.cloud.storage.resumabletransfer.impl.StoreException;
import com.kii.cloud.storage.resumabletransfer.impl.UPNoEntry;
import com.kii.cloud.storage.resumabletransfer.impl.UPOnGoing;
import com.kii.cloud.storage.resumabletransfer.impl.UPState;
import com.kii.cloud.storage.resumabletransfer.impl.UPSuspended;
import com.kii.cloud.storage.resumabletransfer.impl.UploadFutureExecutor;
import com.kii.cloud.storage.resumabletransfer.impl.UploaderInfoImpl;
import com.kii.cloud.storage.resumabletransfer.impl.UploaderLogic;
import com.kii.cloud.storage.resumabletransfer.impl.UploaderLogicFactory;
import com.kii.cloud.storage.resumabletransfer.impl.UploaderSemaphore;
import com.kii.cloud.storage.utils.Log;
import java.io.File;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class KiiUploaderImpl
extends KiiUploader {
    static final int DEFAULT_CHUNK_SIZE = 524288;
    private UPState state;
    private Handler mainHandler = new Handler(Looper.getMainLooper());
    private KiiRTransferCallback callback;
    private KiiRTransferProgressCallback prgCallback;
    private long completedInBytes;
    private long totalInBytes;
    private long sourceLastModified;
    private UploadFutureExecutor uploadFutureManager = new UploadFutureExecutor();
    private File sourceFile;
    private FileHolderInternal fileHolderInternal;
    private Context context;
    private String uploadId;
    private HashGenerator hashGenerator;
    private int chunkSize;
    private Uri holderUri;
    private String key;
    private boolean cancelByTermination;
    private Semaphore cancelSemaphore = new Semaphore(1);
    private Uri initiatorUri;
    private UploaderLogic logic;
    private UploaderLogicFactory<? extends UploaderLogic> logicFactory;
    private RTransferUploadInfoStore transferStore;

    public KiiUploaderImpl(@NonNull Context context, @NonNull FileHolderInternal fileHolderInternal, @NonNull File sourceFile, @NonNull UploaderLogicFactory<? extends UploaderLogic> logicFactory, @NonNull RTransferUploadInfoStore transferStore, @NonNull HashGenerator hashGenerator) {
        this.context = context.getApplicationContext();
        this.fileHolderInternal = fileHolderInternal;
        this.sourceFile = sourceFile;
        this.totalInBytes = sourceFile.length();
        this.sourceLastModified = sourceFile.lastModified();
        this.hashGenerator = hashGenerator;
        this.chunkSize = 524288;
        this.initiatorUri = RTransferCommonLogic.initiatorUri(KiiUser.getCurrentUser());
        this.logic = null;
        this.logicFactory = logicFactory;
        this.transferStore = transferStore;
    }

    Uri getInitiatorUri() {
        return this.initiatorUri;
    }

    synchronized void setState(UPState state) {
        if (state instanceof UPNoEntry) {
            this.setCompletedInBytes(0L);
        }
        this.state = state;
    }

    synchronized UPState getState() {
        return this.state;
    }

    String getUploadId() {
        return this.uploadId;
    }

    void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    private void postToMainThread(Runnable runnable) {
        this.getMainHandler().post(runnable);
    }

    private synchronized Handler getMainHandler() {
        return this.mainHandler;
    }

    void setProgressCallback(KiiRTransferProgressCallback prgCallback) {
        this.prgCallback = prgCallback;
    }

    KiiRTransferProgressCallback getProgressCallback() {
        return this.prgCallback;
    }

    KiiRTransferCallback getCallback() {
        return this.callback;
    }

    long getCompletedInBytes() {
        return this.completedInBytes;
    }

    long getTotalInBytes() {
        return this.totalInBytes;
    }

    void setCompletedInBytes(long completedInBytes) {
        this.completedInBytes = completedInBytes;
    }

    void setTotalInBytes(long totalInBytes) {
        this.totalInBytes = totalInBytes;
    }

    synchronized UploadFutureExecutor getUploadFutureExecutor() {
        return this.uploadFutureManager;
    }

    @Override
    @NonNull
    public File getSourceFile() {
        return this.sourceFile;
    }

    @Override
    @Nullable
    public FileHolder getFileHolder() {
        return this.fileHolderInternal.getFileHolder();
    }

    FileHolderInternal getFileHolderInternal() {
        return this.fileHolderInternal;
    }

    @Override
    public void transfer(@Nullable KiiRTransferProgressCallback progress) throws AlreadyStartedException, SuspendedException, TerminatedException, StateStoreAccessException {
        this.doTransfer(progress);
    }

    @Override
    public void transferAsync(final @Nullable KiiRTransferCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                KiiUploaderImpl.this.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onStart(KiiUploaderImpl.this);
                        }
                    }
                });
                KiiUploaderImpl.this.callback = callback;
                final AtomicReference<Exception> ex = new AtomicReference<Exception>();
                try {
                    KiiUploaderImpl.this.doTransfer(callback);
                }
                catch (Exception e) {
                    ex.set(e);
                }
                KiiUploaderImpl.this.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onTransferCompleted(KiiUploaderImpl.this, (Exception)ex.get());
                        }
                    }
                });
            }
        }).start();
    }

    @Override
    public void suspend() throws NoEntryException, StateStoreAccessException {
        this.doSuspend();
    }

    @Override
    public void suspendAsync(final @Nullable KiiRTransferCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                KiiUploaderImpl.this.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onStart(KiiUploaderImpl.this);
                        }
                    }
                });
                final AtomicReference<Exception> ex = new AtomicReference<Exception>();
                try {
                    KiiUploaderImpl.this.doSuspend();
                }
                catch (Exception e) {
                    ex.set(e);
                }
                KiiUploaderImpl.this.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onSuspendCompleted(KiiUploaderImpl.this, (Exception)ex.get());
                        }
                    }
                });
            }
        }).start();
    }

    @Override
    public void terminate() throws NoEntryException, StateStoreAccessException {
        this.doTerminate();
    }

    @Override
    public void terminateAsync(final @Nullable KiiRTransferCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                KiiUploaderImpl.this.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onStart(KiiUploaderImpl.this);
                        }
                    }
                });
                final AtomicReference<Exception> ex = new AtomicReference<Exception>();
                try {
                    KiiUploaderImpl.this.doTerminate();
                }
                catch (Exception e) {
                    ex.set(e);
                }
                KiiUploaderImpl.this.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onTerminateCompleted(KiiUploaderImpl.this, (Exception)ex.get());
                        }
                    }
                });
            }
        }).start();
    }

    @Override
    @NonNull
    public KiiRTransferInfo info() throws StateStoreAccessException {
        try {
            return this.getTransferStore().findByUploader(this);
        }
        catch (StoreException e) {
            throw new StateStoreAccessException("Failed to access storage");
        }
    }

    @Override
    public void infoAsync(final @NonNull KiiRTransferCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Can't get the result without callback.");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                KiiUploaderImpl.this.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onStart(KiiUploaderImpl.this);
                        }
                    }
                });
                final AtomicReference<StateStoreAccessException> ex = new AtomicReference<StateStoreAccessException>();
                final AtomicReference<KiiRTransferInfo> infoRef = new AtomicReference<KiiRTransferInfo>();
                try {
                    KiiRTransferInfo info = KiiUploaderImpl.this.info();
                    infoRef.set(info);
                }
                catch (StateStoreAccessException e) {
                    ex.set(e);
                }
                KiiUploaderImpl.this.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onInfoCompleted(KiiUploaderImpl.this, (KiiRTransferInfo)infoRef.get(), (Exception)ex.get());
                        }
                    }
                });
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTransfer(KiiRTransferProgressCallback progress) throws AlreadyStartedException, TerminatedException, SuspendedException, StateStoreAccessException {
        Semaphore sem = null;
        try {
            UploaderInfoImpl info;
            if (!this.getSourceFile().exists()) {
                throw new TerminatedException("File does not exist.");
            }
            KiiUploaderImpl kiiUploaderImpl = this;
            synchronized (kiiUploaderImpl) {
                sem = UploaderSemaphore.getSemaphore(this);
                info = this.getTransferStore().findByUploader(this);
                Log.v("UploaderImpl", "sem acquire: " + sem.hashCode());
                if (!sem.tryAcquire()) {
                    throw new AlreadyStartedException("Transfer already started from another thread.");
                }
            }
            this.setProgressCallback(progress);
            UPState state = this.getState();
            Log.v("UploaderImpl", state == null ? "null" : state.getClass().getName());
            if (state == null) {
                state = this.determinStateFromInfo(info);
                this.setState(state);
                if (state instanceof UPSuspended) {
                    this.setUploadId(info.getUploadId());
                    this.setCompletedInBytes(info.getCompletedSizeInBytes());
                }
            }
            File sourceFile = this.getSourceFile();
            if (!(state instanceof UPNoEntry) && this.hasFileChangedFromStoredInfo(info)) {
                this.setTotalInBytes(sourceFile.length());
                this.getTransferStore().remove(this);
                state = new UPNoEntry();
                this.setState(state);
                throw new TerminatedException("File body has been changed.");
            }
            if (state instanceof UPNoEntry) {
                this.setTotalInBytes(sourceFile.length());
                this.sourceLastModified = sourceFile.lastModified();
            }
            this.logic = this.logicFactory.newLogic();
            state.transfer(this);
        }
        catch (StoreException e) {
            throw new StateStoreAccessException("Failed to access storage");
        }
        catch (InvalidHolderException e) {
            throw new TerminatedException("Holder is not exists in the cloud.", e);
        }
        finally {
            if (sem != null) {
                Log.v("UploaderImpl", "sem release");
                sem.release();
            }
        }
    }

    private UPState determinStateFromInfo(UploaderInfoImpl info) throws StoreException {
        if (info.status == KiiRTransferStatus.NOENTRY) {
            return new UPNoEntry();
        }
        if (info.status == KiiRTransferStatus.ONGOING) {
            return new UPOnGoing();
        }
        return new UPSuspended();
    }

    private boolean hasFileChangedFromStoredInfo(UploaderInfoImpl info) {
        if (!this.sourceFile.getAbsolutePath().equals(info.getSourceFilePath())) {
            return true;
        }
        if (this.sourceFile.length() != info.getTotalSizeInBytes()) {
            return true;
        }
        return this.sourceFile.lastModified() != info.getFileModifiedTime();
    }

    private void doSuspend() throws StateStoreAccessException, NoEntryException {
        try {
            this.startCancel(false);
        }
        catch (InterruptedException e1) {
            throw new RuntimeException("Unexpected error", e1);
        }
        UPState state = this.getState();
        if (state == null) {
            boolean stored = false;
            try {
                stored = this.getTransferStore().isStored(this);
            }
            catch (StoreException e) {
                throw new StateStoreAccessException("Failed to access storage");
            }
            state = stored ? new UPSuspended() : new UPNoEntry();
            this.setState(state);
        }
        state.suspend(this);
    }

    private void doTerminate() throws StateStoreAccessException, NoEntryException {
        try {
            this.startCancel(true);
        }
        catch (InterruptedException e1) {
            throw new RuntimeException("Unexpected error", e1);
        }
        UPState state = this.getState();
        if (state == null) {
            boolean stored = false;
            try {
                stored = this.getTransferStore().isStored(this);
            }
            catch (StoreException e) {
                throw new StateStoreAccessException("Failed to access storage");
            }
            state = stored ? new UPSuspended() : new UPNoEntry();
            this.setState(state);
        }
        state.terminate(this);
        this.setCompletedInBytes(0L);
    }

    void executeProgressCallbackOnMainThread() {
        final long completdInBytes = this.getCompletedInBytes();
        final long totalInBytes = this.getTotalInBytes();
        final KiiRTransferProgressCallback pCallback = this.getProgressCallback();
        if (pCallback != null) {
            this.postToMainThread(new Runnable(){

                @Override
                public void run() {
                    pCallback.onProgress(KiiUploaderImpl.this, completdInBytes, totalInBytes);
                }
            });
        }
    }

    boolean hasAllChunkSent() {
        return this.getCompletedInBytes() >= this.getTotalInBytes();
    }

    Context getContext() {
        return this.context;
    }

    HashGenerator getHashGenerator() {
        return this.hashGenerator;
    }

    synchronized boolean doingTransfer() {
        try {
            if (UploaderSemaphore.getSemaphore(this).tryAcquire()) {
                UploaderSemaphore.getSemaphore(this).release();
                return false;
            }
            return true;
        }
        catch (InvalidHolderException e) {
            throw new IllegalStateException("Holder is not exist in the cloud", e);
        }
    }

    void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    void startCancel(boolean terminate) throws InterruptedException {
        this.cancelSemaphore.tryAcquire(5000L, TimeUnit.MILLISECONDS);
        this.cancelByTermination = terminate;
    }

    void cancelDone() {
        this.cancelSemaphore.release();
    }

    boolean cancelledByTermination() {
        return this.cancelByTermination;
    }

    boolean hasFileChangeFromInitiation() {
        long cachedSize = this.totalInBytes;
        long cachedModified = this.sourceLastModified;
        long currentSize = this.sourceFile.length();
        long currentModified = this.sourceFile.lastModified();
        return cachedSize != currentSize || cachedModified != currentModified;
    }

    synchronized Uri getHolderUri() {
        return this.holderUri;
    }

    synchronized void setHolderUri(Uri holderUri) {
        this.holderUri = holderUri;
    }

    void setKey(String key) {
        this.key = key;
    }

    UploaderLogic getLogic() {
        return this.logic;
    }

    RTransferUploadInfoStore getTransferStore() {
        return this.transferStore;
    }
}

