/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.FileHolder;
import com.kii.cloud.storage.resumabletransfer.InvalidHolderException;
import com.kii.cloud.storage.resumabletransfer.impl.KiiCloudFileHolder;
import com.kii.cloud.storage.resumabletransfer.impl.KiiCloudRTransferInfoStore;
import com.kii.cloud.storage.resumabletransfer.impl.KiiDownloaderImpl;
import java.io.File;
import java.util.WeakHashMap;

public class KiiDownloaderFactory {
    static WeakHashMap<String, KiiDownloaderImpl> map = new WeakHashMap();

    @NonNull
    public static synchronized KiiDownloaderImpl newDownloader(@NonNull Context context, @Nullable FileHolder fileHolder, @NonNull File destFile) throws InvalidHolderException {
        KiiCloudFileHolder kiiCloudFileHolder = new KiiCloudFileHolder(fileHolder);
        Uri uri = null;
        try {
            uri = kiiCloudFileHolder.getHolderUri();
        }
        catch (IllegalStateException e) {
            throw new InvalidHolderException("The holder has not created or deleted.");
        }
        if (uri == null) {
            throw new InvalidHolderException("The holder has not created or deleted.");
        }
        String key = KiiDownloaderFactory.getKey(uri, destFile.getAbsolutePath());
        if (map.containsKey(key)) {
            return map.get(key);
        }
        KiiDownloaderImpl downloader = new KiiDownloaderImpl(context, kiiCloudFileHolder, destFile, KiiCloudRTransferInfoStore.getInstance());
        downloader.setHolderUri(uri);
        downloader.setKey(key);
        downloader.setDestFileSize(destFile.length());
        downloader.setLastModified(destFile.lastModified());
        map.put(key, downloader);
        return downloader;
    }

    private static String getKey(Uri uri, String path) {
        return uri.toString() + path;
    }

    public static void discardMap() {
        map = new WeakHashMap();
    }
}

