/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.resumabletransfer.impl;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.resumabletransfer.AlreadyStartedException;
import com.kii.cloud.storage.resumabletransfer.NoEntryException;
import com.kii.cloud.storage.resumabletransfer.StateStoreAccessException;
import com.kii.cloud.storage.resumabletransfer.SuspendedException;
import com.kii.cloud.storage.resumabletransfer.TerminatedException;
import com.kii.cloud.storage.resumabletransfer.impl.DNNoEntry;
import com.kii.cloud.storage.resumabletransfer.impl.DNState;
import com.kii.cloud.storage.resumabletransfer.impl.DNSuspended;
import com.kii.cloud.storage.resumabletransfer.impl.DownloadFutureExecutor;
import com.kii.cloud.storage.resumabletransfer.impl.KiiDownloaderImpl;
import com.kii.cloud.storage.resumabletransfer.impl.StoreException;

public class DNOnGoing
implements DNState {
    @Override
    public void transfer(@Nullable KiiDownloaderImpl downloader) throws AlreadyStartedException, TerminatedException, SuspendedException {
        throw new AlreadyStartedException("Transfer has already started.");
    }

    @Override
    public void suspend(@NonNull KiiDownloaderImpl downloader) throws NoEntryException {
        DownloadFutureExecutor dfm = downloader.getDownloadFutureExecutor();
        try {
            dfm.cancelFuture();
            downloader.setState(new DNSuspended());
        }
        catch (DownloadFutureExecutor.AlreadyDoneException e) {
            downloader.cancelDone();
            throw new NoEntryException("Already done");
        }
    }

    @Override
    public void terminate(@NonNull KiiDownloaderImpl downloader) throws NoEntryException, StateStoreAccessException {
        DownloadFutureExecutor ufm = downloader.getDownloadFutureExecutor();
        try {
            ufm.cancelFuture();
            downloader.getTransferStore().remove(downloader);
            downloader.setState(new DNNoEntry());
        }
        catch (StoreException e) {
            downloader.setState(new DNSuspended());
            throw new StateStoreAccessException("Failed to change status on database");
        }
        catch (DownloadFutureExecutor.AlreadyDoneException e) {
            downloader.cancelDone();
            throw new NoEntryException("Already done");
        }
    }

    @Override
    public void abortChunkDownloading(@Nullable KiiDownloaderImpl downloader, @Nullable Throwable cause) throws SuspendedException, TerminatedException {
        throw new IllegalStateException("Unexpected state.");
    }

    @Override
    public void abortResumableCheck(@Nullable KiiDownloaderImpl downloader, @Nullable Throwable cause) throws TerminatedException, SuspendedException {
        throw new IllegalStateException("Unexpected state.");
    }
}

