/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.query;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.kii.cloud.storage.KiiCallback;
import com.kii.cloud.storage.KiiThing;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.query.KiiThingQuery;
import java.io.IOException;
import java.util.List;

public class KiiThingQueryResult {
    private final KiiThingQuery nextQuery;
    private final List<KiiThing> result;

    public KiiThingQueryResult(@NonNull KiiThingQuery query, @NonNull List<KiiThing> result, @Nullable String paginationKey) {
        this.result = result;
        if (TextUtils.isEmpty((CharSequence)paginationKey)) {
            this.nextQuery = null;
        } else {
            this.nextQuery = new KiiThingQuery(query);
            this.nextQuery.setNextPaginationKey(paginationKey);
        }
    }

    @NonNull
    public List<KiiThing> getResult() {
        return this.result;
    }

    @Nullable
    public KiiThingQuery getNextKiiThingQuery() {
        return this.nextQuery;
    }

    public boolean hasNext() {
        return this.nextQuery != null;
    }

    @WorkerThread
    @NonNull
    public KiiThingQueryResult getNextResult() throws UnauthorizedException, ForbiddenException, BadRequestException, IOException, ConflictException, NotFoundException, UndefinedException {
        if (!this.hasNext()) {
            throw new IllegalStateException("End of the page. no more results.");
        }
        return KiiThing.query(this.getNextKiiThingQuery());
    }

    public void getNextResult(@NonNull KiiCallback<KiiThingQueryResult> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        if (!this.hasNext()) {
            callback.onComplete(null, new IllegalStateException("End of the page. no more results."));
            return;
        }
        KiiThing.query(this.getNextKiiThingQuery(), callback);
    }
}

