/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage.engine;

import android.support.annotation.NonNull;
import com.kii.cloud.okhttp.KiiHttpClient;
import com.kii.cloud.storage.engine._HttpClientFactoryOptions;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.apache.OkApacheClient;
import org.apache.http.client.HttpClient;

public class _HttpClientFactory {
    private static final String TAG = "_HttpClientFactory";
    private static HashMap<_HttpClientFactoryOptions, HttpClient> CLIENTS = new HashMap();

    @NonNull
    public synchronized HttpClient createClient() {
        _HttpClientFactoryOptions options = new _HttpClientFactoryOptions();
        return this.createClient(options);
    }

    @NonNull
    public synchronized HttpClient createClient(_HttpClientFactoryOptions options) {
        HttpClient httpClient = CLIENTS.get(options);
        if (httpClient != null) {
            return httpClient;
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(30L, TimeUnit.SECONDS);
        builder.writeTimeout(30L, TimeUnit.SECONDS);
        builder.readTimeout(30L, TimeUnit.SECONDS);
        OkApacheClient apacheClient = new OkApacheClient(builder.build());
        httpClient = new KiiHttpClient(apacheClient);
        CLIENTS.put(options, httpClient);
        return httpClient;
    }
}

