/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.support.annotation.NonNull;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.engine.KiiCloudHttpEngine;
import com.kii.cloud.storage.exception.CloudExecutionException;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.RefreshTokenFailedException;
import com.kii.cloud.storage.utils.Log;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.http.client.methods.HttpUriRequest;

public class _KiiCloudHttpEngineProxy {
    private static final String TAG = "KiiCloudHttpEngineProxy";
    private final KiiCloudHttpEngine httpEngine;
    private final Object proxy;

    @NonNull
    public static KiiCloudHttpEngine createProxy(@NonNull KiiCloudHttpEngine httpEngine) {
        _KiiCloudHttpEngineProxy p = new _KiiCloudHttpEngineProxy(httpEngine);
        return (KiiCloudHttpEngine)p.proxy;
    }

    private _KiiCloudHttpEngineProxy(KiiCloudHttpEngine httpEngine) {
        this.httpEngine = httpEngine;
        this.proxy = Proxy.newProxyInstance(KiiCloudHttpEngine.class.getClassLoader(), new Class[]{KiiCloudHttpEngine.class}, (InvocationHandler)new RefreshingTokenHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void refreshAccessTokenIfNeed(HttpUriRequest request) throws IOException, CloudExecutionException {
        try {
            if (!Kii.isLoggedIn()) {
                return;
            }
            if (!request.containsHeader("Authorization")) {
                return;
            }
            String accessTokenOwner = null;
            if (request.containsHeader("X-Kii-TokenOwnerUserID")) {
                accessTokenOwner = request.getFirstHeader("X-Kii-TokenOwnerUserID").getValue();
            }
            if (Kii.getRefreshToken() == null) {
                return;
            }
            long expiresAt = KiiUser.getCurrentUser().getAccessTokenExpiresAt();
            if (expiresAt > System.currentTimeMillis() + 300000L) {
                if (accessTokenOwner == null || Kii.getCurrentUser().getID().equals(accessTokenOwner)) {
                    _KiiCloudHttpEngineProxy.overrideAccessToken(request);
                }
                return;
            }
            try {
                if (accessTokenOwner == null || Kii.getCurrentUser().getID().equals(accessTokenOwner)) {
                    Log.i(TAG, "Refresh access token automatically.");
                    Kii.getCurrentUser().refreshAccessToken();
                    _KiiCloudHttpEngineProxy.overrideAccessToken(request);
                }
            }
            catch (BadRequestException e) {
                Kii.logOut();
                throw new RefreshTokenFailedException(e);
            }
        }
        finally {
            request.removeHeaders("X-Kii-TokenOwnerUserID");
        }
    }

    private static HttpUriRequest getHttpUriRequestArg(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof HttpUriRequest)) continue;
            return (HttpUriRequest)arg;
        }
        return null;
    }

    private static void overrideAccessToken(HttpUriRequest request) {
        request.setHeader("Authorization", "Bearer " + Kii.getCurrentUser().getAccessToken());
    }

    private class RefreshingTokenHandler
    implements InvocationHandler {
        private RefreshingTokenHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            HttpUriRequest requestArg = _KiiCloudHttpEngineProxy.getHttpUriRequestArg(args);
            _KiiCloudHttpEngineProxy.refreshAccessTokenIfNeed(requestArg);
            try {
                return method.invoke((Object)_KiiCloudHttpEngineProxy.this.httpEngine, args);
            }
            catch (InvocationTargetException e) {
                Throwable actual = e.getTargetException();
                if (actual instanceof ForbiddenException && "WRONG_TOKEN".equals(((ForbiddenException)actual).getErrorCode())) {
                    Kii.logOut();
                }
                throw actual;
            }
        }
    }
}

