/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.KiiBaseObject;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.LocaleContainer;
import com.kii.cloud.storage.utils.Log;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserFields
extends KiiBaseObject {
    private final HashSet<String> removingKeys = new HashSet();

    public void putDisplayName(@NonNull String displayName) {
        if (!KiiUser.isValidDisplayName(displayName)) {
            throw new IllegalArgumentException("display name is invalid.");
        }
        this.setReserveProperty("displayName", displayName);
    }

    public void putCountry(@NonNull String country) {
        if (!KiiUser.isValidCountry(country)) {
            throw new IllegalArgumentException("country code is invalid.");
        }
        this.setReserveProperty("country", country);
    }

    public void putLocale(@NonNull LocaleContainer locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale is null.");
        }
        this.setReserveProperty("locale", locale.toString());
    }

    public void removeDisplayName() {
        this.removeReserveProperty("displayName");
    }

    public void removeCountry() {
        this.removeReserveProperty("country");
    }

    public void removeLocale() {
        this.removeReserveProperty("locale");
    }

    public void removeFromServer(String key) throws IllegalArgumentException {
        this.assertKey(key);
        this.removingKeys.add(key);
        super.remove(key);
    }

    @Nullable
    public String toString() {
        try {
            return this.toJsonString();
        }
        catch (JSONException e) {
            Log.v("UserFields", "fail to toString()", e);
            return null;
        }
    }

    @Override
    public void set(String key, int value) {
        super.set(key, value);
        this.removingKeys.remove(key);
    }

    @Override
    public void set(String key, long value) {
        super.set(key, value);
        this.removingKeys.remove(key);
    }

    @Override
    public void set(String key, byte[] value) {
        super.set(key, value);
        this.removingKeys.remove(key);
    }

    @Override
    public void set(String key, String value) {
        super.set(key, value);
        this.removingKeys.remove(key);
    }

    @Override
    public void set(String key, Boolean value) {
        super.set(key, value);
        this.removingKeys.remove(key);
    }

    @Override
    public void set(String key, double value) {
        super.set(key, value);
        this.removingKeys.remove(key);
    }

    @Override
    public void set(String key, JSONArray value) {
        super.set(key, value);
        this.removingKeys.remove(key);
    }

    @Override
    public void set(String key, Uri value) {
        super.set(key, value);
        this.removingKeys.remove(key);
    }

    @Override
    public void set(String key, JSONObject value) {
        super.set(key, value);
        this.removingKeys.remove(key);
    }

    @Override
    public void remove(String key) {
        super.remove(key);
        this.removingKeys.remove(key);
    }

    @Override
    boolean isValidKey(String key) {
        return KiiUser.isValidUserFieldKey(key);
    }

    String toJsonString() throws JSONException {
        JSONObject json = new JSONObject(this.mJSON.toString());
        for (String key : this.removingKeys) {
            json.remove(key);
        }
        return json.toString();
    }

    Set<String> getRemovingKeys() {
        return Collections.unmodifiableSet(this.removingKeys);
    }

    public boolean isEmpty() {
        return this.removingKeys.size() == 0 && this.mJSON.length() == 0;
    }
}

