/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.KiiGroup;
import com.kii.cloud.storage.KiiThing;
import com.kii.cloud.storage.KiiTopic;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.PushMessageBundleHelper;
import com.kii.cloud.storage.ReceivedMessage;
import com.kii.cloud.storage.utils.Utils;

public class PushToUserMessage
extends ReceivedMessage {
    private String topicName;
    private String objectScopeGroupId;
    private String objectScopeUserId;
    private String objectScopeThingId;

    PushToUserMessage(Bundle bundle) {
        super(bundle, bundle.getString("sender"), bundle.getString("objectScopeType"));
        this.objectScopeGroupId = bundle.getString("objectScopeGroupID");
        this.objectScopeUserId = bundle.getString("objectScopeUserID");
        this.objectScopeThingId = bundle.getString("objectScopeThingID");
        this.topicName = bundle.getString("topic");
    }

    @Nullable
    public KiiTopic getKiiTopic() {
        if (!this.containsKiiTopic()) {
            return null;
        }
        ReceivedMessage.Scope scope = this.getScope();
        if (ReceivedMessage.Scope.APP.equals((Object)scope)) {
            return new KiiTopic(null, this.topicName);
        }
        if (ReceivedMessage.Scope.APP_AND_GROUP.equals((Object)scope)) {
            KiiGroup group = this.getEventSourceGroup();
            return new KiiTopic(group, this.topicName);
        }
        if (ReceivedMessage.Scope.APP_AND_USER.equals((Object)scope)) {
            KiiUser user = this.getEventSourceUser();
            return new KiiTopic(user, this.topicName);
        }
        if (ReceivedMessage.Scope.APP_AND_THING.equals((Object)scope)) {
            KiiThing thing = this.getEventSourceThing();
            return new KiiTopic(thing, this.topicName);
        }
        throw new RuntimeException("Unexpected Error.");
    }

    public boolean containsKiiTopic() {
        return this.topicName != null && this.getScope() != null;
    }

    @Nullable
    public KiiGroup getEventSourceGroup() {
        if (this.objectScopeGroupId == null) {
            return null;
        }
        return KiiGroup.groupWithID(this.objectScopeGroupId);
    }

    @Nullable
    public KiiUser getEventSourceUser() {
        if (this.objectScopeUserId == null) {
            return null;
        }
        return KiiUser.createByUri(Uri.parse((String)Utils.path("kiicloud://", "users", this.objectScopeUserId)));
    }

    @Nullable
    public KiiThing getEventSourceThing() {
        if (this.objectScopeThingId == null) {
            return null;
        }
        return KiiThing.createByUri(Uri.parse((String)Utils.path("kiicloud://", "things", this.objectScopeThingId)));
    }

    @Override
    @NonNull
    public PushMessageBundleHelper.MessageType pushMessageType() {
        return PushMessageBundleHelper.MessageType.PUSH_TO_USER;
    }
}

