/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.os.Bundle;
import android.support.annotation.NonNull;
import com.kii.cloud.storage.DirectPushMessage;
import com.kii.cloud.storage.PushToAppMessage;
import com.kii.cloud.storage.PushToUserMessage;
import com.kii.cloud.storage.ReceivedMessage;
import com.kii.cloud.storage.utils.Log;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class PushMessageBundleHelper {
    private static final String TAG = "PushMessageBundleHelper";

    @NonNull
    public static ReceivedMessage parse(@NonNull Bundle bundle) {
        if (bundle == null || bundle.isEmpty()) {
            throw new IllegalArgumentException("Bundle is null or empty.");
        }
        Log.v(TAG, bundle.toString());
        Bundle messageBundle = null;
        if (PushMessageBundleHelper.isJPushMessage(bundle)) {
            String message = bundle.getString("cn.jpush.android.MESSAGE");
            try {
                messageBundle = PushMessageBundleHelper.convertJSONtoBundle(new JSONObject(message));
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Bundle contains invalid JSON.", e);
            }
        } else {
            messageBundle = new Bundle(bundle);
        }
        if (PushMessageBundleHelper.isPushToAppMessage(messageBundle)) {
            return new PushToAppMessage(messageBundle);
        }
        if (PushMessageBundleHelper.isPushToUserMessage(messageBundle)) {
            return new PushToUserMessage(messageBundle);
        }
        return new DirectPushMessage(messageBundle);
    }

    @NonNull
    public static ReceivedMessage parse(@NonNull Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("Map is null or empty.");
        }
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return PushMessageBundleHelper.parse(bundle);
    }

    private static boolean isPushToAppMessage(Bundle b) {
        return "EVENT".equals(b.getString("origin")) || b.containsKey("bucketID") || b.containsKey("bucketType");
    }

    private static boolean isPushToUserMessage(Bundle b) {
        return b.containsKey("topic");
    }

    private static boolean isJPushMessage(Bundle b) {
        return b.containsKey("cn.jpush.android.MESSAGE");
    }

    private static Bundle convertJSONtoBundle(JSONObject json) throws JSONException {
        Iterator keys = json.keys();
        Bundle b = new Bundle();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = json.get(key);
            if (value instanceof String) {
                Log.v(TAG, "[Type : String] " + key + " / " + value);
                b.putString(key, (String)value);
                continue;
            }
            if (value instanceof Integer) {
                Log.v(TAG, "[Type : Integer] " + key + " / " + value);
                b.putInt(key, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                Log.v(TAG, "[Type : Long] " + key + " / " + value);
                b.putLong(key, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Double) {
                Log.v(TAG, "[Type : Double] " + key + " / " + value);
                b.putDouble(key, ((Double)value).doubleValue());
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            Log.v(TAG, "[Type : Boolean] " + key + " / " + value);
            b.putBoolean(key, ((Boolean)value).booleanValue());
        }
        return b;
    }

    public static enum MessageType {
        PUSH_TO_APP,
        PUSH_TO_USER,
        DIRECT_PUSH;

    }
}

