/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.kii.cloud.async.executor.KiiTaskExecutor;
import com.kii.cloud.async.executor.KiiUncancelabeTask;
import com.kii.cloud.async.executor.KiiUserTask;
import com.kii.cloud.storage.AlreadyHasIdentityException;
import com.kii.cloud.storage.GCMPushInstallation;
import com.kii.cloud.storage.IdentityData;
import com.kii.cloud.storage.JPushInstallation;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.KiiBaseObject;
import com.kii.cloud.storage.KiiBucket;
import com.kii.cloud.storage.KiiCallback;
import com.kii.cloud.storage.KiiEncryptedBucket;
import com.kii.cloud.storage.KiiGroup;
import com.kii.cloud.storage.KiiInternalUtil;
import com.kii.cloud.storage.KiiListResult;
import com.kii.cloud.storage.KiiPushInstallation;
import com.kii.cloud.storage.KiiPushMessageSender;
import com.kii.cloud.storage.KiiPushSubscription;
import com.kii.cloud.storage.KiiScope;
import com.kii.cloud.storage.KiiSubject;
import com.kii.cloud.storage.KiiThingOwner;
import com.kii.cloud.storage.KiiTopic;
import com.kii.cloud.storage.LocaleContainer;
import com.kii.cloud.storage.SDKClientInfo;
import com.kii.cloud.storage.UserCredentials;
import com.kii.cloud.storage.UserFields;
import com.kii.cloud.storage.callback.KiiUserCallBack;
import com.kii.cloud.storage.callback.KiiUserPutIdentityCallback;
import com.kii.cloud.storage.callback.KiiUserRegisterCallback;
import com.kii.cloud.storage.callback.KiiUserUpdateCallback;
import com.kii.cloud.storage.callback.LoginCallBack;
import com.kii.cloud.storage.engine.ApiResponse;
import com.kii.cloud.storage.engine.KiiCloudEngine;
import com.kii.cloud.storage.exception.IllegalKiiBaseObjectFormatException;
import com.kii.cloud.storage.exception.UserCredentialsNotFoundException;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.social.KiiSocialConnect;
import com.kii.cloud.storage.social.connector.KiiSocialNetworkConnector;
import com.kii.cloud.storage.social.connector.SocialAccountInfo;
import com.kii.cloud.storage.social.connector._KiiSocialNetworkConnectorInternalBridge;
import com.kii.cloud.storage.utils.Log;
import com.kii.cloud.storage.utils.Utils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class KiiUser
extends KiiBaseObject
implements KiiScope,
KiiSubject,
KiiThingOwner,
KiiPushMessageSender,
Parcelable {
    static final String TAG = "KiiUser";
    static final String PROPERTY_USERNAME = "loginName";
    static final String PROPERTY_EMAIL = "emailAddress";
    static final String PROPERTY_PENDING_EMAIL = "_emailAddressPending";
    static final String PROPERTY_PHONE = "phoneNumber";
    static final String PROPERTY_PENDING_PHONE = "_phoneNumberPending";
    static final String PROPERTY_DISPLAYNAME = "displayName";
    static final String PROPERTY_COUNTRY = "country";
    static final String PROPERTY_ID = "userID";
    static final String PROPERTY_INTERNAL_USER_ID = "internalUserID";
    static final String PROPERTY_PHONE_NUMBER_VERIFIED = "phoneNumberVerified";
    static final String PROPERTY_EMAIL_ADDRESS_VERIFIED = "emailAddressVerified";
    static final String PROPERTY_LOCALE = "locale";
    static final String PROPERTY_URI = "_kiireserved_uri";
    static final String PROPERTY_DISABLED = "_disabled";
    private String mId;
    private String mAccessToken;
    private String mRefreshToken;
    private Bundle mSocialAccessTokenBundle;
    private long mAccessTokenExpiresAt;
    private static HashSet<String> reservedKeys = new HashSet();
    public static final Parcelable.Creator<KiiUser> CREATOR;

    private KiiUser() {
        this.mAccessToken = null;
        this.mRefreshToken = null;
        this.mSocialAccessTokenBundle = new Bundle();
    }

    @Nullable
    public String getUsername() {
        return this.mJSON.optString(PROPERTY_USERNAME, null);
    }

    public boolean disabled() {
        return this.mJSON.optBoolean(PROPERTY_DISABLED);
    }

    @Nullable
    public String getEmail() {
        return this.getString(PROPERTY_EMAIL, null);
    }

    @Nullable
    public String getPendingEmail() {
        return this.getString(PROPERTY_PENDING_EMAIL, null);
    }

    @Nullable
    public String getPhone() {
        return this.getString(PROPERTY_PHONE, null);
    }

    @Nullable
    public String getPendingPhone() {
        return this.getString(PROPERTY_PENDING_PHONE, null);
    }

    @Nullable
    public String getDisplayname() {
        return this.getString(PROPERTY_DISPLAYNAME, null);
    }

    @Nullable
    public String getCountry() {
        return this.getString(PROPERTY_COUNTRY, null);
    }

    @Nullable
    public LocaleContainer getLocale() {
        String locale = this.getString(PROPERTY_LOCALE, null);
        if (Utils.isEmpty(locale)) {
            return null;
        }
        return LocaleContainer.fromBcp47Tag(locale);
    }

    public void setLocale(@NonNull LocaleContainer locale) {
        if (locale == null) {
            throw new IllegalArgumentException("Value canot be null.");
        }
        this.setReserveProperty(PROPERTY_LOCALE, locale.toString());
    }

    public void setDisplayname(@NonNull String displayname) {
        if (!KiiUser.isValidDisplayName(displayname)) {
            throw new IllegalArgumentException("Invalid displayName format:" + displayname);
        }
        this.setReserveProperty(PROPERTY_DISPLAYNAME, displayname);
    }

    public void setCountry(@NonNull String country) {
        if (!KiiUser.isValidCountry(country)) {
            throw new IllegalArgumentException("Invalid country format:" + country);
        }
        this.setReserveProperty(PROPERTY_COUNTRY, country);
    }

    @WorkerThread
    @NonNull
    public static KiiUser logIn(@NonNull String userIdentifier, @NonNull String password) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        KiiUser me = new KiiUser();
        JSONObject loginData = KiiUser.createLoginData(userIdentifier, password);
        KiiUser.loginInner(me, loginData);
        return me;
    }

    @WorkerThread
    @NonNull
    public static KiiUser logInWithLocalPhone(@NonNull String localPhoneNumber, @NonNull String password, @NonNull String country) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        KiiUser me = new KiiUser();
        JSONObject loginData = KiiUser.createLoginDataWithLocalPhone(localPhoneNumber, country, password);
        KiiUser.loginInner(me, loginData);
        return me;
    }

    private static void loginInner(KiiUser me, JSONObject loginData) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(false);
        if (KiiUser.getCurrentUser() != null) {
            KiiUser.logOut();
        }
        String postUri = Utils.path(Kii.getBaseURL(), "oauth2", "token");
        HttpPost request = new HttpPost(postUri);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        long expiresAt = 0L;
        long tokenExpiration = Kii.getAccessTokenExpiration();
        if (tokenExpiration > 0L) {
            try {
                expiresAt = KiiInternalUtil.safeCalculateExpiresAt(tokenExpiration, System.currentTimeMillis());
                loginData.put("expiresAt", expiresAt);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        StringEntity entity = new StringEntity(loginData.toString(), "UTF-8");
        entity.setContentType("application/vnd.kii.OauthTokenRequest+json");
        request.setEntity((HttpEntity)entity);
        ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        try {
            String userId;
            JSONObject respObj = new JSONObject(response.body);
            String token = respObj.getString("access_token");
            String refreshToken = respObj.optString("refresh_token");
            me.mId = userId = respObj.getString("id");
            long expiresIn = respObj.getLong("expires_in");
            expiresAt = KiiInternalUtil.safeCalculateExpiresAt(expiresIn, System.currentTimeMillis());
            me.updateAccessTokenExpiresAt(expiresAt);
            if (!Utils.isEmpty(refreshToken)) {
                me.updateRefreshToken(refreshToken);
            }
            Kii.getInstance().setCurrentUser(me);
            KiiCloudEngine.updateAccessToken(token);
            me.refresh();
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    private static JSONObject createLoginData(String userIdentifier, String password) {
        if (!KiiUser.isValidUserIdentifier(userIdentifier)) {
            throw new IllegalArgumentException("User identifier is invalid :" + userIdentifier);
        }
        if (!KiiUser.isValidPassword(password)) {
            throw new IllegalArgumentException("Invalid password format:" + password);
        }
        String identifier = KiiUser.isValidGlobalPhone(userIdentifier) ? KiiUser.formatPhoneNumber(userIdentifier) : userIdentifier;
        JSONObject loginData = new JSONObject();
        try {
            loginData.put("username", (Object)identifier);
            loginData.put("password", (Object)password);
            Log.v(TAG, "request body: " + loginData.toString());
        }
        catch (JSONException e1) {
            throw new IllegalArgumentException("The current user data has problem");
        }
        return loginData;
    }

    private static JSONObject createLoginDataWithLocalPhone(String localPhoneNumber, String country, String password) {
        if (!KiiUser.isValidLocalPhone(localPhoneNumber)) {
            throw new IllegalArgumentException("Local phone number is invalid : " + localPhoneNumber);
        }
        if (!KiiUser.isValidCountry(country)) {
            throw new IllegalArgumentException("Country is invalid :" + country);
        }
        if (!KiiUser.isValidPassword(password)) {
            throw new IllegalArgumentException("Invalid password format:" + password);
        }
        String userIdentifier = KiiUser.createLocalPhoneNumber(localPhoneNumber, country);
        JSONObject loginData = new JSONObject();
        try {
            loginData.put("username", (Object)userIdentifier);
            loginData.put("password", (Object)password);
            Log.v(TAG, "request body: " + loginData.toString());
        }
        catch (JSONException e1) {
            throw new IllegalArgumentException("The current user data has problem");
        }
        return loginData;
    }

    private static String createLocalPhoneNumber(String localPhoneNumber, String country) {
        return "PHONE:" + country + "-" + localPhoneNumber;
    }

    @WorkerThread
    @NonNull
    public static KiiUser loginWithToken(@NonNull String token) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        if (TextUtils.isEmpty((CharSequence)token)) {
            throw new IllegalArgumentException("Specified token is null/empty");
        }
        if (KiiUser.getCurrentUser() != null) {
            KiiUser.logOut();
        }
        Utils.checkInitialize(false);
        String getUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", "me");
        HttpGet request = new HttpGet(getUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request, token);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        try {
            String userId;
            JSONObject respObj = new JSONObject(response.body);
            KiiUser me = new KiiUser();
            me.mId = userId = respObj.getString(PROPERTY_ID);
            me.mJSON = respObj;
            Kii.getInstance().setCurrentUser(me);
            KiiCloudEngine.updateAccessToken(token);
            Long expiresAt = Utils.safeAdd(System.currentTimeMillis(), 2147483647000L);
            me.updateAccessTokenExpiresAt(expiresAt);
            return me;
        }
        catch (JSONException e) {
            Log.e(TAG, e.getMessage());
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    @NonNull
    public static KiiUser loginWithToken(@NonNull String token, long expiresAt) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        KiiUser user = KiiUser.loginWithToken(token);
        user.updateAccessTokenExpiresAt(expiresAt);
        return user;
    }

    @NonNull
    public static KiiUser loginWithToken(@NonNull String token, long expiresAt, @NonNull String refreshToken) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        if (TextUtils.isEmpty((CharSequence)refreshToken)) {
            throw new IllegalArgumentException("Specified refreshToken is null/empty");
        }
        KiiUser user = KiiUser.loginWithToken(token, expiresAt);
        user.updateRefreshToken(refreshToken);
        Kii.storeUserCredentials(UserCredentials.fromKiiUser(user));
        return user;
    }

    public static void loginWithToken(final @NonNull LoginCallBack callback, final @NonNull String token, final long expiresAt) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        if (TextUtils.isEmpty((CharSequence)token)) {
            throw new IllegalArgumentException("Specified token is null/empty");
        }
        Utils.checkInitialize(false);
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){
            private KiiUser user = null;

            @Override
            public void run() {
                try {
                    this.user = KiiUser.loginWithToken(token, expiresAt);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onLoginCompleted(this.user, this.getException());
            }
        });
    }

    public static void loginWithToken(final @NonNull String token, final long expiresAt, final @NonNull String refreshToken, final @NonNull KiiCallback<KiiUser> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        if (TextUtils.isEmpty((CharSequence)token)) {
            throw new IllegalArgumentException("Specified token is null/empty");
        }
        if (TextUtils.isEmpty((CharSequence)refreshToken)) {
            throw new IllegalArgumentException("Specified refreshToken is null/empty");
        }
        Utils.checkInitialize(false);
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){
            private KiiUser user = null;

            @Override
            public void run() {
                try {
                    this.user = KiiUser.loginWithToken(token, expiresAt, refreshToken);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(this.user, this.getException());
            }
        });
    }

    @Nullable
    public String getAccessToken() {
        return this.mAccessToken;
    }

    String getRefreshToken() {
        return this.mRefreshToken;
    }

    long getAccessTokenExpiresAt() {
        return this.mAccessTokenExpiresAt;
    }

    @NonNull
    public static KiiUser loginWithStoredCredentials() throws UserCredentialsNotFoundException {
        if (!Kii.hasApplicationContext()) {
            throw new UserCredentialsNotFoundException("SDK does not have Context. Please initialize the SDK with Context.");
        }
        UserCredentials userCredentials = Kii.loadUserCredentials();
        if (userCredentials == null) {
            throw new UserCredentialsNotFoundException("User credentials has not stored.");
        }
        if (!userCredentials.isValid()) {
            Kii.clearStoredUserCredentials();
            throw new UserCredentialsNotFoundException("Stored UserCredentials is broken.");
        }
        if (!Kii.getBaseURL().equals(userCredentials.getBaseURL()) || !Kii.getAppId().equals(userCredentials.getAppId())) {
            Kii.clearStoredUserCredentials();
            throw new UserCredentialsNotFoundException("User credentials has not stored.");
        }
        KiiUser me = new KiiUser();
        me.mId = userCredentials.getUserId();
        if (!Utils.isEmpty(userCredentials.getUsername())) {
            me.setReserveProperty(PROPERTY_USERNAME, userCredentials.getUsername());
        }
        if (!Utils.isEmpty(userCredentials.getPhoneNumber())) {
            me.setReserveProperty(PROPERTY_PHONE, userCredentials.getPhoneNumber());
        }
        me.setReserveProperty(PROPERTY_PHONE_NUMBER_VERIFIED, userCredentials.getPhoneNumberVerified());
        if (!Utils.isEmpty(userCredentials.getPendingPhoneNumber())) {
            me.setReserveProperty(PROPERTY_PENDING_PHONE, userCredentials.getPendingPhoneNumber());
        }
        if (!Utils.isEmpty(userCredentials.getCountry())) {
            me.setReserveProperty(PROPERTY_COUNTRY, userCredentials.getCountry());
        }
        if (!Utils.isEmpty(userCredentials.getEmailAddress())) {
            me.setReserveProperty(PROPERTY_EMAIL, userCredentials.getEmailAddress());
        }
        me.setReserveProperty(PROPERTY_EMAIL_ADDRESS_VERIFIED, userCredentials.getEmailAddressVerifeid());
        if (!Utils.isEmpty(userCredentials.getPendingEmailAddress())) {
            me.setReserveProperty(PROPERTY_PENDING_EMAIL, userCredentials.getPendingEmailAddress());
        }
        if (!Utils.isEmpty(userCredentials.getDisplayName())) {
            me.setDisplayname(userCredentials.getDisplayName());
        }
        me.updateAccessTokenExpiresAt(userCredentials.getExpiresAt());
        if (!Utils.isEmpty(userCredentials.getRefreshToken())) {
            me.updateRefreshToken(userCredentials.getRefreshToken());
        }
        if (!Utils.isEmpty(userCredentials.getAccessToken())) {
            me.updateAccessToken(userCredentials.getAccessToken());
        }
        Kii.getInstance().setCurrentUser(me);
        return me;
    }

    public static void loginWithStoredCredentials(final @NonNull KiiCallback<KiiUser> callback) {
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){

            @Override
            public void run() {
                try {
                    KiiUser.loginWithStoredCredentials();
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(KiiUser.getCurrentUser(), this.getException());
            }
        });
    }

    @WorkerThread
    void refreshAccessToken() throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(true);
        if (!Kii.getCurrentUser().getID().equals(this.getID())) {
            throw new IllegalStateException("This instance isn't current user.");
        }
        String refreshToken = Kii.getRefreshToken();
        if (refreshToken == null) {
            throw new IllegalStateException("User doesn't have the refresh token.");
        }
        try {
            JSONObject respObj = KiiUser.refreshAccessToken(refreshToken);
            String newAccessToken = respObj.getString("access_token");
            String newRefreshToken = respObj.getString("refresh_token");
            long expiresIn = respObj.getLong("expires_in");
            long expiresAt = KiiInternalUtil.safeCalculateExpiresAt(expiresIn, System.currentTimeMillis());
            this.updateAccessTokenExpiresAt(expiresAt);
            this.updateRefreshToken(newRefreshToken);
            KiiCloudEngine.updateAccessToken(newAccessToken);
            Kii.storeUserCredentials(UserCredentials.fromKiiUser(Kii.getCurrentUser()));
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    void refreshAccessToken(final KiiCallback<KiiUser> callback) {
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){

            @Override
            public void run() {
                try {
                    KiiUser.this.refreshAccessToken();
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(KiiUser.getCurrentUser(), this.getException());
            }
        });
    }

    private static JSONObject refreshAccessToken(String refreshToken) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        String postUri = Utils.path(Kii.getBaseURL(), "oauth2", "token");
        HttpPost request = new HttpPost(postUri);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        request.setHeader("Content-Type", "application/json");
        JSONObject refreshData = new JSONObject();
        try {
            refreshData.put("grant_type", (Object)"refresh_token");
            refreshData.put("refresh_token", (Object)refreshToken);
            long expiresAt = 0L;
            long tokenExpiration = Kii.getAccessTokenExpiration();
            if (tokenExpiration > 0L) {
                expiresAt = KiiInternalUtil.safeCalculateExpiresAt(tokenExpiration, System.currentTimeMillis());
                refreshData.put("expires_at", expiresAt);
            }
        }
        catch (JSONException expiresAt) {
            // empty catch block
        }
        StringEntity entity = new StringEntity(refreshData.toString(), "UTF-8");
        request.setEntity((HttpEntity)entity);
        ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        try {
            return new JSONObject(response.body);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    void updateAccessToken(String accessToken) {
        this.mAccessToken = accessToken;
    }

    void updateAccessTokenExpiresAt(long expiresAt) {
        this.mAccessTokenExpiresAt = expiresAt;
    }

    void clearAccessToken() {
        this.mAccessToken = null;
        this.mRefreshToken = null;
    }

    void updateRefreshToken(String refreshToken) {
        this.mRefreshToken = refreshToken;
    }

    @WorkerThread
    public void changePassword(@NonNull String newPassword, @NonNull String oldPassword) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(true);
        if (!KiiUser.isValidPassword(newPassword)) {
            throw new IllegalArgumentException("Invalid password format for new:" + newPassword);
        }
        if (!KiiUser.isValidPassword(oldPassword)) {
            throw new IllegalArgumentException("Invalid password format for old:" + oldPassword);
        }
        String uuid = this.getID();
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            throw new IllegalStateException("Object doesn't exist in the cloud, missing unique identifier.");
        }
        KiiUser user = Kii.getCurrentUser();
        if (!user.getID().equals(uuid)) {
            throw new IllegalStateException("Cannot update password except owner");
        }
        JSONObject password = new JSONObject();
        try {
            password.put("newPassword", (Object)newPassword);
            password.put("oldPassword", (Object)oldPassword);
            Log.v(TAG, "request body: " + password.toString(2));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        String passwdUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", "me", "password");
        HttpPut request = new HttpPut(passwdUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        StringEntity entity = new StringEntity(password.toString(), "UTF-8");
        entity.setContentType("application/vnd.kii.ChangePasswordRequest+json");
        request.setEntity((HttpEntity)entity);
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    @WorkerThread
    public void register(@NonNull String password) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(false);
        String username = this.getUsername();
        if (!KiiUser.isValidPassword(password)) {
            throw new IllegalArgumentException("Invalid password format:" + password);
        }
        JSONObject object = null;
        try {
            object = new JSONObject(this.mJSON.toString());
            object.put(PROPERTY_USERNAME, (Object)username);
            object.put("password", (Object)password);
            Log.v(TAG, "request body:" + object.toString(2));
        }
        catch (JSONException e1) {
            throw new IllegalArgumentException("The current user data has problem");
        }
        String postUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users");
        HttpPost request = new HttpPost(postUrl);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        request.setHeader("Content-Type", "application/vnd.kii.RegistrationRequest+json");
        request.setEntity((HttpEntity)new StringEntity(object.toString(), "UTF-8"));
        ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        try {
            JSONObject respObj;
            this.mJSON = respObj = new JSONObject(response.body);
        }
        catch (JSONException e) {
            Log.e(TAG, e.getMessage());
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
        JSONObject loginData = KiiUser.createLoginData(this.getIdentifier(), password);
        KiiUser.loginInner(this, loginData);
    }

    @WorkerThread
    @NonNull
    public static KiiUser registerAsPseudoUser(@Nullable UserFields userFields) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        Utils.checkInitialize(false);
        if (KiiUser.getCurrentUser() != null) {
            KiiUser.logOut();
        }
        ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)KiiUser.createRegisterPseudoUserRequest(userFields));
        KiiUser retval = null;
        try {
            retval = KiiUser.newPseudoUser(new JSONObject(response.body));
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException("Unexpected response", e);
        }
        if (userFields != null) {
            retval.setUserFields(userFields);
        }
        Kii.getInstance().setCurrentUser(retval);
        return retval;
    }

    @Deprecated
    @WorkerThread
    public void update() throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(true);
        String uuid = this.getID();
        if (uuid == null) {
            throw new IllegalStateException("Object doesn't exist in the cloud, missing unique identifier.");
        }
        KiiUser user = Kii.getCurrentUser();
        if (!user.getID().equals(uuid)) {
            throw new IllegalStateException("Cannot update except owner.");
        }
        String postUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", uuid);
        HttpPost request = new HttpPost(postUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        try {
            Log.v(TAG, "request body: " + this.mJSON.toString(2));
            StringEntity entity = new StringEntity(this.mJSON.toString(), "UTF-8");
            entity.setContentType("application/vnd.kii.UserUpdateRequest+json");
            request.setEntity((HttpEntity)entity);
            KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        }
        catch (JSONException e) {
            throw new IllegalStateException("The current user data has problem");
        }
        Kii.getInstance().setCurrentUser(this);
    }

    @WorkerThread
    public void putIdentity(@NonNull IdentityData identityData, @Nullable UserFields userFields, @NonNull String password) throws AlreadyHasIdentityException, IllegalArgumentException, IllegalStateException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        Utils.checkInitialize(true);
        if (identityData == null) {
            throw new IllegalArgumentException("identityData must not be null.");
        }
        if (!KiiUser.isValidPassword(password)) {
            throw new IllegalArgumentException("password is invalid.");
        }
        if (KiiUser.isValidLocalPhone(identityData.getPhone()) && (userFields == null || !userFields.has(PROPERTY_COUNTRY))) {
            throw new IllegalArgumentException("This is local phone number. Country code is needed.");
        }
        if (!this.isLoggedInUser()) {
            throw new IllegalStateException("A user which does not login yet can not use putIdentity.");
        }
        this.refresh();
        if (!this.isPseudoUser()) {
            throw new AlreadyHasIdentityException("This user already has identity.");
        }
        this.updateAttributes(identityData, userFields, password);
        this.setIdentityData(identityData);
        if (userFields != null) {
            this.setUserFields(userFields);
        }
        this.setReserveProperty("_hasPassword", true);
    }

    @WorkerThread
    public void update(@NonNull UserFields userFields) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        if (userFields == null) {
            throw new IllegalArgumentException("userFields must not be null.");
        }
        if (userFields.isEmpty()) {
            throw new IllegalArgumentException("userFields is empty.");
        }
        this.updateInner(null, userFields);
    }

    public void update(final @NonNull UserFields userFields, final @NonNull KiiUserUpdateCallback callBack) {
        if (callBack == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){

            @Override
            public void run() {
                try {
                    KiiUser.this.update(userFields);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callBack.onUpdateCompleted(KiiUser.this, this.getException());
            }
        });
    }

    @WorkerThread
    public void update(@Nullable IdentityData identityData, @Nullable UserFields userFields) throws IllegalArgumentException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        this.updateInner(identityData, userFields);
    }

    private void updateInner(IdentityData identityData, UserFields userFields) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        Utils.checkInitialize(true);
        if (identityData == null && (userFields == null || userFields.isEmpty())) {
            throw new IllegalArgumentException("Both of identityData and userFields must not be null.");
        }
        this.refresh();
        if (this.isPseudoUser() && identityData != null) {
            throw new IllegalArgumentException("Pseudo user can not update identity with this method.");
        }
        this.updateAttributes(identityData, userFields, null);
        if (identityData != null) {
            this.setIdentityData(identityData);
        }
        if (userFields != null) {
            this.setUserFields(userFields);
        }
    }

    public void update(final @Nullable IdentityData identityData, final @Nullable UserFields userFields, final @NonNull KiiUserUpdateCallback callBack) throws IllegalArgumentException {
        if (callBack == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){

            @Override
            public void run() {
                try {
                    KiiUser.this.update(identityData, userFields);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callBack.onUpdateCompleted(KiiUser.this, this.getException());
            }
        });
    }

    @WorkerThread
    public void delete() throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(true);
        String id = this.getID();
        if (TextUtils.isEmpty((CharSequence)id)) {
            throw new IllegalStateException("User does not exist in the cloud.");
        }
        boolean isCurrentUser = KiiUser.getCurrentUser().getID().equals(id);
        String deleteUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", id);
        HttpDelete request = new HttpDelete(deleteUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        if (isCurrentUser) {
            Kii.logOut();
        }
        this.mId = null;
        this.mJSON = new JSONObject();
    }

    @WorkerThread
    public void refresh() throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        String id = this.getID();
        if (TextUtils.isEmpty((CharSequence)id)) {
            throw new IllegalStateException("User does not exist in the cloud.");
        }
        String getUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", id);
        HttpGet request = new HttpGet(getUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        try {
            JSONObject respObj;
            this.mJSON = respObj = new JSONObject(response.body);
        }
        catch (JSONException e) {
            Log.e(TAG, e.getMessage());
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
        if (Kii.isLoggedIn() && id.equals(Kii.getCurrentUser().getID())) {
            Kii.storeUserCredentials(UserCredentials.fromKiiUser(this));
        }
    }

    public static int logIn(@NonNull KiiUserCallBack callBack, @NonNull String userIdentifier, @NonNull String password) {
        KiiUserTask userTask = new KiiUserTask(KiiUserTask.TaskType.LOGIN, null, callBack, userIdentifier, password);
        KiiTaskExecutor.getInstance().execute(userTask);
        return userTask.getTaskId();
    }

    public static int logInWithLocalPhone(@NonNull KiiUserCallBack callBack, @NonNull String localPhoneNumber, @NonNull String password, @NonNull String country) {
        KiiUserTask userTask = new KiiUserTask(KiiUserTask.TaskType.LOGIN_WITH_LOCALPHONE, null, callBack, localPhoneNumber, password, country);
        KiiTaskExecutor.getInstance().execute(userTask);
        return userTask.getTaskId();
    }

    public static int loginWithToken(@NonNull KiiUserCallBack callBack, @NonNull String token) {
        KiiUserTask userTask = new KiiUserTask(KiiUserTask.TaskType.LOGIN_WITH_TOKEN, null, callBack, token);
        KiiTaskExecutor.getInstance().execute(userTask);
        return userTask.getTaskId();
    }

    @NonNull
    public static KiiUser createWithEmail(@NonNull String username, @NonNull String email) {
        if (!KiiUser.isValidUserName(username)) {
            throw new IllegalArgumentException("Invalid username format:" + username);
        }
        KiiUser user = new KiiUser();
        if (!KiiUser.isValidEmail(email)) {
            throw new IllegalArgumentException("Invalid Email format:" + email);
        }
        user.setReserveProperty(PROPERTY_USERNAME, username);
        user.setReserveProperty(PROPERTY_EMAIL, email);
        return user;
    }

    @NonNull
    public static KiiUser createWithPhone(@NonNull String username, @NonNull String phone) {
        if (!KiiUser.isValidUserName(username)) {
            throw new IllegalArgumentException("Invalid username format:" + username);
        }
        KiiUser user = new KiiUser();
        if (!KiiUser.isValidPhone(phone)) {
            throw new IllegalArgumentException("Invalid Phone format:" + phone);
        }
        user.setReserveProperty(PROPERTY_USERNAME, username);
        user.setReserveProperty(PROPERTY_PHONE, KiiUser.formatPhoneNumber(phone));
        return user;
    }

    @NonNull
    public static KiiUser createWithUsername(@NonNull String username) {
        if (!KiiUser.isValidUserName(username)) {
            throw new IllegalArgumentException("Invalid username format:" + username);
        }
        KiiUser user = new KiiUser();
        user.setReserveProperty(PROPERTY_USERNAME, username);
        return user;
    }

    @NonNull
    public static Builder builderWithPhone(@NonNull String phone) {
        return new Builder().withPhone(phone);
    }

    @NonNull
    public static Builder builderWithLocalPhone(@NonNull String phone, @NonNull String country) {
        return new Builder().setLocalPhone(phone, country);
    }

    @NonNull
    public static Builder builderWithName(@NonNull String userName) {
        return new Builder().withName(userName);
    }

    @NonNull
    public static Builder builderWithEmail(@NonNull String email) {
        return new Builder().withEmail(email);
    }

    @NonNull
    public static Builder builderWithIdentifier(@NonNull String identifier) {
        Builder builder = new Builder();
        if (KiiUser.isValidGlobalPhone(identifier)) {
            builder.phone = identifier;
        } else if (KiiUser.isValidLocalPhone(identifier)) {
            builder.phone = identifier;
        } else if (KiiUser.isValidEmail(identifier)) {
            builder.email = identifier;
        } else if (KiiUser.isValidUserName(identifier)) {
            builder.userName = identifier;
        } else {
            throw new IllegalArgumentException("Unspecified identifier" + identifier);
        }
        return builder;
    }

    public int register(@NonNull KiiUserCallBack callBack, @NonNull String password) {
        KiiUserTask userTask = new KiiUserTask(KiiUserTask.TaskType.REGISTER, this, callBack, password);
        KiiTaskExecutor.getInstance().execute(userTask);
        return userTask.getTaskId();
    }

    public static void registerAsPseudoUser(final @Nullable UserFields userFields, final @NonNull KiiUserRegisterCallback callBack) {
        if (callBack == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){
            private KiiUser user = null;

            @Override
            public void run() {
                try {
                    this.user = KiiUser.registerAsPseudoUser(userFields);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callBack.onRegisterCompleted(this.user, this.getException());
            }
        });
    }

    public int changePassword(@NonNull KiiUserCallBack callBack, @NonNull String newPassword, @NonNull String oldPassword) {
        KiiUserTask userTask = new KiiUserTask(KiiUserTask.TaskType.CHANGE_PASSWORD, this, callBack, newPassword, oldPassword);
        KiiTaskExecutor.getInstance().execute(userTask);
        return userTask.getTaskId();
    }

    @Deprecated
    public int update(@NonNull KiiUserCallBack callBack) {
        KiiUserTask userTask = new KiiUserTask(KiiUserTask.TaskType.UPDATE, this, callBack, new Object[0]);
        KiiTaskExecutor.getInstance().execute(userTask);
        return userTask.getTaskId();
    }

    public void putIdentity(final @NonNull IdentityData identityData, final @Nullable UserFields userFields, final @NonNull String password, final @NonNull KiiUserPutIdentityCallback callBack) throws IllegalArgumentException {
        if (callBack == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){

            @Override
            public void run() {
                try {
                    KiiUser.this.putIdentity(identityData, userFields, password);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callBack.onPutIdentityCompleted(KiiUser.this, this.getException());
            }
        });
    }

    public int delete(@NonNull KiiUserCallBack callBack) {
        KiiUserTask userTask = new KiiUserTask(KiiUserTask.TaskType.DELETE, this, callBack, new Object[0]);
        KiiTaskExecutor.getInstance().execute(userTask);
        return userTask.getTaskId();
    }

    public int refresh(@NonNull KiiUserCallBack callBack) {
        KiiUserTask userTask = new KiiUserTask(KiiUserTask.TaskType.REFRESH, this, callBack, new Object[0]);
        KiiTaskExecutor.getInstance().execute(userTask);
        return userTask.getTaskId();
    }

    @WorkerThread
    public static void resetPassword(@NonNull String identifier) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(false);
        if (!KiiUser.isValidEmail(identifier)) {
            throw new IllegalArgumentException("identifier is not valid email address: " + identifier);
        }
        String resetUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", "EMAIL" + ":" + identifier, "password", "request-reset");
        HttpPost request = new HttpPost(resetUrl);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    @WorkerThread
    public static void resetPassword(@NonNull String identifier, @NonNull NotificationMethod notificationMethod) throws ForbiddenException, BadRequestException, UndefinedException, IOException, ConflictException, NotFoundException, UnauthorizedException {
        Utils.checkInitialize(false);
        if (TextUtils.isEmpty((CharSequence)identifier)) {
            throw new IllegalArgumentException("Identifier is null or empty.");
        }
        if (notificationMethod == null) {
            throw new IllegalArgumentException("notificationMethod is null.");
        }
        String encodedQualifiedID = KiiUser.toQualifiedID(identifier);
        String resetUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", encodedQualifiedID, "password", "request-reset");
        HttpPost request = new HttpPost(resetUrl);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        JSONObject reqBodyJson = new JSONObject();
        try {
            reqBodyJson.put("notificationMethod", (Object)notificationMethod.notificationMethod);
            if (!Utils.isEmpty(notificationMethod.smsResetMethod)) {
                reqBodyJson.put("smsResetMethod", (Object)notificationMethod.smsResetMethod);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Unexpected error.", e);
        }
        StringEntity ent = new StringEntity(reqBodyJson.toString(), "utf-8");
        ent.setContentType("application/vnd.kii.ResetPasswordRequest+json");
        request.setEntity((HttpEntity)ent);
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    public static int resetPassword(@NonNull KiiUserCallBack callBack, @NonNull String identifier) {
        KiiUserTask userTask = new KiiUserTask(KiiUserTask.TaskType.RESET_PASSWORD, null, callBack, identifier);
        KiiTaskExecutor.getInstance().execute(userTask);
        return userTask.getTaskId();
    }

    public static void resetPassword(final @NonNull String identifier, final @NonNull NotificationMethod notificationMethod, final @NonNull KiiCallback<Void> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){

            @Override
            public void run() {
                try {
                    KiiUser.resetPassword(identifier, notificationMethod);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(null, this.getException());
            }
        });
    }

    public static void completeResetPassword(@NonNull String identifier, @NonNull String pinCode, @Nullable String newPassword) throws IOException, ForbiddenException, BadRequestException, UndefinedException, ConflictException, NotFoundException, UnauthorizedException {
        if (Utils.isEmpty(identifier)) {
            throw new IllegalArgumentException("identifier is null or empty.");
        }
        if (Utils.isEmpty(pinCode)) {
            throw new IllegalArgumentException("pinCode is null or empty.");
        }
        JSONObject requestBody = new JSONObject();
        try {
            if (!Utils.isEmpty(newPassword)) {
                requestBody.put("newPassword", (Object)newPassword);
            }
            requestBody.put("pinCode", (Object)pinCode);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        HttpPost request = new HttpPost(Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", KiiUser.toQualifiedID(identifier), "password", "complete-reset"));
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        request.setHeader("Content-Type", "application/vnd.kii.CompletePasswordResetRequest+json");
        request.setEntity((HttpEntity)new StringEntity(requestBody.toString(), "UTF-8"));
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    public static void completeResetPassword(final @NonNull String identifier, final @NonNull String pinCode, final @Nullable String newPassword, final @NonNull KiiCallback<Void> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){

            @Override
            public void run() {
                try {
                    KiiUser.completeResetPassword(identifier, pinCode, newPassword);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(null, this.getException());
            }
        });
    }

    @WorkerThread
    public void verifyPhone(@NonNull String code) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(false);
        if (Utils.isEmpty(code)) {
            throw new IllegalArgumentException("Username or email or phone cannot be empty");
        }
        JSONObject jsonObject = new JSONObject();
        String jsonString = "";
        try {
            jsonObject.put("verificationCode", (Object)code);
            jsonString = jsonObject.toString();
            Log.v(TAG, "request body:" + jsonString);
        }
        catch (JSONException e1) {
            throw new IllegalArgumentException("The current user data has problem");
        }
        String postUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", this.getID(), "phone-number", "verify");
        HttpPost request = new HttpPost(postUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        request.setHeader("Content-Type", "application/vnd.kii.AddressVerificationRequest+json");
        request.setEntity((HttpEntity)new StringEntity(jsonString, "UTF-8"));
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        try {
            this.mJSON.put(PROPERTY_PHONE_NUMBER_VERIFIED, true);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public int verifyPhone(@NonNull KiiUserCallBack callBack, @NonNull String code) {
        KiiUserTask userTask = new KiiUserTask(KiiUserTask.TaskType.VERIFY_PHONE, this, callBack, code);
        KiiTaskExecutor.getInstance().execute(userTask);
        return userTask.getTaskId();
    }

    public boolean isPhoneVerified() {
        return this.mJSON.optBoolean(PROPERTY_PHONE_NUMBER_VERIFIED, false);
    }

    public boolean isEmailVerified() {
        return this.mJSON.optBoolean(PROPERTY_EMAIL_ADDRESS_VERIFIED, false);
    }

    public boolean isPseudoUser() {
        if (!(TextUtils.isEmpty((CharSequence)this.getUsername()) && TextUtils.isEmpty((CharSequence)this.getEmail()) && TextUtils.isEmpty((CharSequence)this.getPhone()))) {
            return false;
        }
        return this.getBoolean("_hasPassword", Boolean.FALSE) == false;
    }

    @NonNull
    public Map<KiiSocialNetworkConnector.Provider, SocialAccountInfo> getLinkedSocialAccounts() {
        EnumMap<KiiSocialNetworkConnector.Provider, SocialAccountInfo> accounts = new EnumMap<KiiSocialNetworkConnector.Provider, SocialAccountInfo>(KiiSocialNetworkConnector.Provider.class);
        if (!this.has("_thirdPartyAccounts")) {
            return accounts;
        }
        JSONObject thirdPartyAccounts = this.getJSONObject("_thirdPartyAccounts");
        if (thirdPartyAccounts.length() < 1) {
            return accounts;
        }
        Iterator it = thirdPartyAccounts.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            KiiSocialNetworkConnector.Provider p = _KiiSocialNetworkConnectorInternalBridge.providerWithLinkedSocialNetworkName(key);
            try {
                JSONObject info = thirdPartyAccounts.getJSONObject(key);
                accounts.put(p, _KiiSocialNetworkConnectorInternalBridge.newSocialAccountInfo(p, info.getString("id"), info.getLong("createdAt")));
            }
            catch (JSONException e) {
                throw new IllegalKiiBaseObjectFormatException("Unexpected _thirdPartyAccounts.", e);
            }
        }
        return accounts;
    }

    public boolean isLinkedWithSocialProvider(@NonNull KiiSocialNetworkConnector.Provider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider is null.");
        }
        if (!this.has("_thirdPartyAccounts")) {
            return false;
        }
        JSONObject thirdPartyAccounts = this.getJSONObject("_thirdPartyAccounts");
        if (provider == KiiSocialNetworkConnector.Provider.GOOGLE || provider == KiiSocialNetworkConnector.Provider.GOOGLEPLUS) {
            return thirdPartyAccounts.has(KiiSocialNetworkConnector.Provider.GOOGLE.getProviderLinkedSocialNetworkName()) || thirdPartyAccounts.has(KiiSocialNetworkConnector.Provider.GOOGLEPLUS.getProviderLinkedSocialNetworkName());
        }
        return thirdPartyAccounts.has(provider.getProviderLinkedSocialNetworkName());
    }

    @NonNull
    public static KiiUser userWithID(@NonNull String userID) {
        if (TextUtils.isEmpty((CharSequence)userID)) {
            throw new IllegalArgumentException("Specified ID is empty or null");
        }
        KiiUser user = new KiiUser();
        user.mId = userID;
        return user;
    }

    @NonNull
    public static KiiUser createByUri(@NonNull Uri uri) {
        String id = KiiUser.parseIdFromUri(uri);
        return KiiUser.userWithID(id);
    }

    private static String parseIdFromUri(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Input uri is null");
        }
        String scheme = uri.getScheme();
        List segments = uri.getPathSegments();
        if (!"kiicloud".equals(scheme)) {
            throw new IllegalArgumentException("Do not support this uri:" + uri);
        }
        String authority = uri.getAuthority();
        if (!"users".equals(authority)) {
            throw new IllegalArgumentException("Do not support this uri:" + uri);
        }
        if (segments.size() != 1) {
            throw new IllegalArgumentException("Do not support this uri:" + uri);
        }
        return (String)segments.get(0);
    }

    @Nullable
    public String getID() {
        if (this.mId == null) {
            this.mId = this.mJSON.optString(PROPERTY_ID, null);
        }
        return this.mId;
    }

    private void setId(String userId) {
        this.mId = userId;
    }

    @Nullable
    public Uri toUri() {
        Utils.checkInitialize(false);
        String uuid = this.getID();
        if (Utils.isEmpty(uuid)) {
            return null;
        }
        String url = Utils.path("kiicloud://", "users", uuid);
        return Uri.parse((String)url);
    }

    @Nullable
    public static KiiUser getCurrentUser() {
        Utils.checkInitialize(false);
        return Kii.getCurrentUser();
    }

    public static void logOut() {
        Utils.checkInitialize(false);
        Kii.logOut();
    }

    public static boolean isLoggedIn() {
        Utils.checkInitialize(false);
        return Kii.isLoggedIn();
    }

    @NonNull
    public String toString() {
        return this.toJSON().toString();
    }

    @NonNull
    public KiiBucket bucket(@NonNull String bucketName) {
        return new KiiBucket(this, bucketName);
    }

    @NonNull
    public KiiEncryptedBucket encryptedBucket(@NonNull String bucketName) {
        return new KiiEncryptedBucket(this, bucketName);
    }

    @WorkerThread
    public static void changePhone(@NonNull String phoneNumber) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(true);
        if (TextUtils.isEmpty((CharSequence)phoneNumber)) {
            throw new IllegalArgumentException("Phone cannot be empty");
        }
        if (!KiiUser.isValidPhone(phoneNumber)) {
            throw new IllegalArgumentException("Invalid Phone format:" + phoneNumber);
        }
        String uri = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", "me", "phone-number");
        HttpPut request = new HttpPut(uri);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        JSONObject requestBody = new JSONObject();
        phoneNumber = KiiUser.formatPhoneNumber(phoneNumber);
        try {
            requestBody.put(PROPERTY_PHONE, (Object)phoneNumber);
            Log.v(TAG, "request body: " + requestBody.toString());
        }
        catch (JSONException e1) {
            throw new IllegalArgumentException("Invalid Phone format:");
        }
        StringEntity entity = new StringEntity(requestBody.toString(), "UTF-8");
        entity.setContentType("application/vnd.kii.PhoneNumberModificationRequest+json");
        request.setEntity((HttpEntity)entity);
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    public static int changePhone(@NonNull KiiUserCallBack callback, @NonNull String phoneNumber) {
        KiiUserTask userTask = new KiiUserTask(KiiUserTask.TaskType.CHANGE_PHONE, null, callback, phoneNumber);
        KiiTaskExecutor.getInstance().execute(userTask);
        return userTask.getTaskId();
    }

    @WorkerThread
    public static void changeEmail(@NonNull String email) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(true);
        if (TextUtils.isEmpty((CharSequence)email)) {
            throw new IllegalArgumentException("Email cannot be empty");
        }
        if (!KiiUser.isValidEmail(email)) {
            throw new IllegalArgumentException("Invalid Email format:" + email);
        }
        String uri = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", "me", "email-address");
        HttpPut request = new HttpPut(uri);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        JSONObject requestBody = new JSONObject();
        try {
            requestBody.put(PROPERTY_EMAIL, (Object)email);
        }
        catch (JSONException e1) {
            throw new IllegalArgumentException("Invalid Email format:");
        }
        StringEntity entity = new StringEntity(requestBody.toString(), "UTF-8");
        entity.setContentType("application/vnd.kii.EmailAddressModificationRequest+json");
        request.setEntity((HttpEntity)entity);
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    public static int changeEmail(@NonNull KiiUserCallBack callback, @NonNull String email) {
        KiiUserTask userTask = new KiiUserTask(KiiUserTask.TaskType.CHANGE_EMAIL, null, callback, email);
        KiiTaskExecutor.getInstance().execute(userTask);
        return userTask.getTaskId();
    }

    @WorkerThread
    public static void requestResendPhoneVerificationCode() throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(true);
        String postUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", "me", "phone-number", "resend-verification");
        HttpPost request = new HttpPost(postUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    public static int requestResendPhoneVerificationCode(@NonNull KiiUserCallBack callback) {
        KiiUserTask userTask = new KiiUserTask(KiiUserTask.TaskType.REQUEST_RESEND_PHONE_VERIFICATION_CODE, null, callback, new Object[0]);
        KiiTaskExecutor.getInstance().execute(userTask);
        return userTask.getTaskId();
    }

    @WorkerThread
    public static void requestResendEmailVerification() throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(true);
        String postUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", "me", "email-address", "resend-verification");
        HttpPost request = new HttpPost(postUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    public static int requestResendEmailVerification(@NonNull KiiUserCallBack callback) {
        KiiUserTask userTask = new KiiUserTask(KiiUserTask.TaskType.REQUEST_RESEND_EMAIL_VERIFICATION, null, callback, new Object[0]);
        KiiTaskExecutor.getInstance().execute(userTask);
        return userTask.getTaskId();
    }

    private static boolean isValidUserIdentifier(String userIdentifier) {
        return KiiUser.isValidUserName(userIdentifier) || KiiUser.isValidGlobalPhone(userIdentifier) || KiiUser.isValidEmail(userIdentifier);
    }

    public static boolean isValidUserName(@Nullable String username) {
        return !TextUtils.isEmpty((CharSequence)username) && Utils.validateUsername(username);
    }

    public static boolean isValidDisplayName(@Nullable String displayname) {
        return !TextUtils.isEmpty((CharSequence)displayname) && Utils.validateDisplayname(displayname);
    }

    public static boolean isValidCountry(@Nullable String country) {
        return !TextUtils.isEmpty((CharSequence)country) && Utils.validateCountry(country);
    }

    public static boolean isValidEmail(@Nullable String email) {
        return !TextUtils.isEmpty((CharSequence)email) && Utils.validateEmail(email);
    }

    public static boolean isValidLocalPhone(@Nullable String phone) {
        return !TextUtils.isEmpty((CharSequence)phone) && Utils.validateLocalPhoneNumber(phone);
    }

    public static boolean isValidPhone(@Nullable String phone) {
        return !TextUtils.isEmpty((CharSequence)phone) && Utils.validatePhoneNumber(phone);
    }

    public static boolean isValidGlobalPhone(@Nullable String phone) {
        return Utils.validateGlobalPhone(phone);
    }

    public static boolean isValidPassword(@Nullable String password) {
        return !TextUtils.isEmpty((CharSequence)password) && Utils.validatePassword(password);
    }

    @WorkerThread
    @NonNull
    public List<KiiGroup> memberOfGroups() throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        Utils.checkInitialize(true);
        String id = this.getID();
        if (TextUtils.isEmpty((CharSequence)id)) {
            throw new IllegalStateException("User does not exist in the cloud.");
        }
        ArrayList<KiiGroup> groups = new ArrayList<KiiGroup>();
        String getUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "groups");
        getUrl = getUrl + "?is_member=" + id;
        HttpGet request = new HttpGet(getUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        request.setHeader("accept", "application/vnd.kii.GroupsRetrievalResponse+json");
        ApiResponse res = null;
        try {
            res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
            JSONObject respObj = new JSONObject(res.body);
            JSONArray array = respObj.getJSONArray("groups");
            if (array != null && array.length() > 0) {
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject obj = array.getJSONObject(i);
                    String groupId = obj.getString("groupID");
                    String ownerId = obj.optString("owner", null);
                    String name = obj.getString("name");
                    KiiGroup group = KiiGroup.groupWithID(groupId);
                    group.setGroupName(name);
                    group.setOwner(ownerId);
                    groups.add(group);
                }
            }
        }
        catch (JSONException jse) {
            throw new IllegalKiiBaseObjectFormatException(res.body);
        }
        return groups;
    }

    public int memberOfGroups(@NonNull KiiUserCallBack callBack) {
        KiiUserTask userTask = new KiiUserTask(KiiUserTask.TaskType.MEMBER_OF_GROUPS, this, callBack, new Object[0]);
        KiiTaskExecutor.getInstance().execute(userTask);
        return userTask.getTaskId();
    }

    @WorkerThread
    @NonNull
    public List<KiiGroup> ownerOfGroups() throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        Utils.checkInitialize(true);
        String id = this.getID();
        if (TextUtils.isEmpty((CharSequence)id)) {
            throw new IllegalStateException("User does not exist in the cloud.");
        }
        ArrayList<KiiGroup> groups = new ArrayList<KiiGroup>();
        String getUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "groups");
        getUrl = getUrl + "?owner=" + id;
        HttpGet request = new HttpGet(getUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        request.setHeader("accept", "application/vnd.kii.GroupsRetrievalResponse+json");
        ApiResponse res = null;
        try {
            res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
            JSONObject respObj = new JSONObject(res.body);
            JSONArray array = respObj.getJSONArray("groups");
            if (array != null && array.length() > 0) {
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject obj = array.getJSONObject(i);
                    String groupId = obj.getString("groupID");
                    String ownerId = obj.optString("owner", null);
                    String name = obj.getString("name");
                    KiiGroup group = KiiGroup.groupWithID(groupId);
                    group.setGroupName(name);
                    group.setOwner(ownerId);
                    groups.add(group);
                }
            }
        }
        catch (JSONException jse) {
            throw new IllegalKiiBaseObjectFormatException(res.body);
        }
        return groups;
    }

    public int ownerOfGroups(@NonNull KiiUserCallBack callBack) {
        KiiUserTask userTask = new KiiUserTask(KiiUserTask.TaskType.OWNER_OF_GROUPS, this, callBack, new Object[0]);
        KiiTaskExecutor.getInstance().execute(userTask);
        return userTask.getTaskId();
    }

    private String getIdentifier() {
        String identifier = null;
        identifier = this.getUsername();
        if (TextUtils.isEmpty((CharSequence)identifier) && this.isEmailVerified()) {
            identifier = this.getEmail();
        }
        if (TextUtils.isEmpty((CharSequence)identifier) && this.isPhoneVerified()) {
            identifier = this.getPhone();
        }
        return identifier;
    }

    @WorkerThread
    @NonNull
    public static KiiUser findUserByEmail(@NonNull String email) throws UnauthorizedException, ForbiddenException, NotFoundException, UndefinedException, IOException, BadRequestException {
        ApiResponse res;
        Utils.checkInitialize(true);
        String url = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", "EMAIL:" + email);
        HttpGet request = new HttpGet(url);
        request.setHeader("x-kii-appid", Kii.getAppId());
        request.setHeader("x-kii-appkey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        try {
            res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        }
        catch (ConflictException e) {
            throw new UndefinedException(e.getStatus(), e.getBody());
        }
        KiiUser found = new KiiUser();
        try {
            found.mJSON = new JSONObject(res.body);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException("Unexpected response.");
        }
        return found;
    }

    @WorkerThread
    @NonNull
    public static KiiUser findUserByPhone(@NonNull String phone) throws UnauthorizedException, ForbiddenException, NotFoundException, UndefinedException, IOException, BadRequestException {
        ApiResponse res;
        Utils.checkInitialize(true);
        String url = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", "PHONE:" + phone);
        HttpGet request = new HttpGet(url);
        request.setHeader("x-kii-appid", Kii.getAppId());
        request.setHeader("x-kii-appkey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        try {
            res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        }
        catch (ConflictException e) {
            throw new UndefinedException(e.getStatus(), e.getBody());
        }
        KiiUser found = new KiiUser();
        try {
            found.mJSON = new JSONObject(res.body);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException("Unexpected response.");
        }
        return found;
    }

    @WorkerThread
    @NonNull
    public static KiiUser findUserByUserName(@NonNull String username) throws UnauthorizedException, ForbiddenException, NotFoundException, UndefinedException, IOException, BadRequestException {
        ApiResponse res;
        Utils.checkInitialize(true);
        String url = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", "LOGIN_NAME:" + username);
        HttpGet request = new HttpGet(url);
        request.setHeader("x-kii-appid", Kii.getAppId());
        request.setHeader("x-kii-appkey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        try {
            res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        }
        catch (ConflictException e) {
            throw new UndefinedException(e.getStatus(), e.getBody());
        }
        KiiUser found = new KiiUser();
        try {
            found.mJSON = new JSONObject(res.body);
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException("Unexpected response.");
        }
        return found;
    }

    public static int findUserByEmail(@NonNull String email, @NonNull KiiUserCallBack callback) {
        KiiUserTask userTask = new KiiUserTask(KiiUserTask.TaskType.FIND_BY_EMAIL, KiiUser.getCurrentUser(), callback, email);
        KiiTaskExecutor.getInstance().execute(userTask);
        return userTask.getTaskId();
    }

    public static int findUserByPhone(@NonNull String phone, @NonNull KiiUserCallBack callback) {
        KiiUserTask userTask = new KiiUserTask(KiiUserTask.TaskType.FIND_BY_PHONE, KiiUser.getCurrentUser(), callback, phone);
        KiiTaskExecutor.getInstance().execute(userTask);
        return userTask.getTaskId();
    }

    public static int findUserByUserName(@NonNull String username, @NonNull KiiUserCallBack callback) {
        KiiUserTask userTask = new KiiUserTask(KiiUserTask.TaskType.FIND_BY_NAME, KiiUser.getCurrentUser(), callback, username);
        KiiTaskExecutor.getInstance().execute(userTask);
        return userTask.getTaskId();
    }

    @NonNull
    public KiiPushSubscription pushSubscription() {
        Utils.checkInitialize(true);
        return new KiiPushSubscription(this);
    }

    @NonNull
    public static KiiPushInstallation pushInstallation() {
        Utils.checkInitialize(true);
        if (KiiUser.getCurrentUser() == null) {
            throw new IllegalStateException("No user is logged in");
        }
        return new GCMPushInstallation();
    }

    @NonNull
    public static KiiPushInstallation pushInstallation(@NonNull KiiPushInstallation.PushBackend backend) {
        Utils.checkInitialize(true);
        if (KiiUser.getCurrentUser() == null) {
            throw new IllegalStateException("No user is logged in");
        }
        if (backend == null) {
            throw new IllegalArgumentException("backend should not be null");
        }
        switch (backend) {
            case GCM: {
                return new GCMPushInstallation();
            }
            case JPUSH: {
                return new JPushInstallation();
            }
        }
        throw new RuntimeException("Unexpected error");
    }

    @NonNull
    public static KiiPushInstallation pushInstallation(boolean development) {
        Utils.checkInitialize(true);
        if (KiiUser.getCurrentUser() == null) {
            throw new IllegalStateException("No user is logged in");
        }
        return new GCMPushInstallation(development);
    }

    @NonNull
    public static KiiPushInstallation pushInstallation(@NonNull KiiPushInstallation.PushBackend backend, boolean development) {
        Utils.checkInitialize(true);
        if (KiiUser.getCurrentUser() == null) {
            throw new IllegalStateException("No user is logged in");
        }
        if (backend == null) {
            throw new IllegalArgumentException("backend should not be null");
        }
        switch (backend) {
            case GCM: {
                return new GCMPushInstallation(development);
            }
            case JPUSH: {
                return new JPushInstallation(development);
            }
        }
        throw new RuntimeException("Unexpected error");
    }

    @NonNull
    public JSONObject toJSON() {
        JSONObject json = this.getJSONOfArbitraryFields();
        try {
            String username = this.getUsername();
            String email = this.getEmail();
            String phone = this.getPhone();
            String displayName = this.getDisplayname();
            String country = this.getCountry();
            Uri uri = this.toUri();
            json.put(PROPERTY_USERNAME, username == null ? JSONObject.NULL : username);
            json.put(PROPERTY_EMAIL, email == null ? JSONObject.NULL : email);
            json.put(PROPERTY_PHONE, phone == null ? JSONObject.NULL : phone);
            json.put(PROPERTY_DISPLAYNAME, displayName == null ? JSONObject.NULL : displayName);
            json.put(PROPERTY_COUNTRY, country == null ? JSONObject.NULL : country);
            json.put(PROPERTY_PHONE_NUMBER_VERIFIED, this.isPhoneVerified());
            json.put(PROPERTY_EMAIL_ADDRESS_VERIFIED, this.isEmailVerified());
            json.put(PROPERTY_URI, uri == null ? JSONObject.NULL : uri);
        }
        catch (JSONException e) {
            throw new RuntimeException("Unexpected error.", e);
        }
        return json;
    }

    @NonNull
    public static KiiTopic topic(@NonNull String name) {
        Utils.checkInitialize(true);
        KiiTopic topic = new KiiTopic(KiiUser.getCurrentUser(), name);
        return topic;
    }

    @NonNull
    public KiiTopic topicOfThisUser(@NonNull String name) {
        Utils.checkInitialize(true);
        if (TextUtils.isEmpty((CharSequence)this.getID())) {
            throw new IllegalStateException("KiiUser has deleted or not registered in KiiCloud yet.");
        }
        KiiTopic topic = new KiiTopic(this, name);
        return topic;
    }

    @NonNull
    public KiiListResult<KiiTopic> listTopics() throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        return this.listTopics((String)null);
    }

    @WorkerThread
    @NonNull
    public KiiListResult<KiiTopic> listTopics(@Nullable String paginationKey) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        Utils.checkInitialize(true);
        String uuid = this.getID();
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            throw new IllegalStateException("Object doesn't exist in the cloud, missing unique identifier.");
        }
        String topicUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", uuid, "topics");
        if (!Utils.isEmpty(paginationKey)) {
            topicUrl = topicUrl + "?paginationKey=" + URLEncoder.encode(paginationKey, "UTF-8");
        }
        HttpGet request = new HttpGet(topicUrl);
        request.addHeader("X-Kii-AppID", Kii.getAppId());
        request.addHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        try {
            JSONObject json = new JSONObject(response.body);
            String newPaginationKey = null;
            if (json.has("paginationKey")) {
                newPaginationKey = json.getString("paginationKey");
            }
            JSONArray array = json.getJSONArray("topics");
            ArrayList<KiiTopic> topics = new ArrayList<KiiTopic>();
            for (int i = 0; i < array.length(); ++i) {
                topics.add(this.topicOfThisUser(array.getJSONObject(i).getString("topicID")));
            }
            return new KiiListResult<KiiTopic>(topics, newPaginationKey);
        }
        catch (JSONException e) {
            Log.e(TAG, e.getMessage());
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public void listTopics(@NonNull KiiCallback<KiiListResult<KiiTopic>> callback) {
        this.listTopics(null, callback);
    }

    public void listTopics(final @Nullable String paginationKey, final @NonNull KiiCallback<KiiListResult<KiiTopic>> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){
            private KiiListResult<KiiTopic> result = null;

            @Override
            public void run() {
                try {
                    this.result = KiiUser.this.listTopics(paginationKey);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(this.result, this.getException());
            }
        });
    }

    public boolean equals(@Nullable Object user) {
        if (user == null || !(user instanceof KiiUser)) {
            return false;
        }
        String userID = ((KiiUser)user).getID();
        if (userID != null && userID.equals(this.getID())) {
            return true;
        }
        return super.equals(user);
    }

    public int hashCode() {
        String userID = this.getID();
        if (TextUtils.isEmpty((CharSequence)userID)) {
            return super.hashCode();
        }
        return userID.hashCode();
    }

    @Override
    boolean isValidKey(String key) {
        return KiiUser.isValidUserFieldKey(key);
    }

    static boolean isValidUserFieldKey(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return false;
        }
        return reservedKeys == null || reservedKeys.size() <= 0 || !reservedKeys.contains(key);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Bundle b = new Bundle();
        b.putString("mJSON", this.mJSON.toString());
        b.putString("mJSONPatch", this.mJSONPatch.toString());
        b.putString("userId", this.getID());
        b.putString("accessToken", this.getAccessToken());
        b.putString("refreshToken", this.mRefreshToken);
        b.putLong("accessTokenExpiresAt", this.mAccessTokenExpiresAt);
        b.putBundle("accessTokenBundle", this.mSocialAccessTokenBundle);
        dest.writeBundle(b);
    }

    private KiiUser(Bundle b) throws JSONException {
        super(new JSONObject(b.getString("mJSON")), new JSONObject(b.getString("mJSONPatch")));
        this.setId(b.getString("userId"));
        this.updateAccessToken(b.getString("accessToken"));
        this.updateRefreshToken(b.getString("refreshToken"));
        this.updateAccessTokenExpiresAt(b.getLong("accessTokenExpiresAt"));
        this.mSocialAccessTokenBundle = b.getBundle("accessTokenBundle");
    }

    @Nullable
    public Bundle getAccessTokenBundle() {
        if (KiiUser.getCurrentUser() == null) {
            return null;
        }
        Bundle b = new Bundle();
        b.putString("access_token", this.mAccessToken);
        b.putString("refresh_token", this.mRefreshToken);
        b.putLong("expires_at", this.mAccessTokenExpiresAt);
        return b;
    }

    Bundle getSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork network) {
        if (network == null) {
            throw new IllegalArgumentException("Specified network is null");
        }
        return this.mSocialAccessTokenBundle.getBundle(network.toString());
    }

    void updateSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork network, Bundle tokenBundle) {
        if (network == null || tokenBundle == null) {
            throw new IllegalArgumentException("Specified network or token bundle is null");
        }
        this.mSocialAccessTokenBundle.putBundle(network.toString(), tokenBundle);
    }

    void clearSocialAccessTokenBundle(KiiSocialConnect.SocialNetwork network) {
        if (network == null) {
            throw new IllegalArgumentException("Specified network is null");
        }
        this.mSocialAccessTokenBundle.remove(network.toString());
    }

    private static HttpPost createRegisterPseudoUserRequest(UserFields userFields) throws UnsupportedEncodingException {
        HttpPost retval = new HttpPost(Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users"));
        retval.setHeader("X-Kii-AppID", Kii.getAppId());
        retval.setHeader("X-Kii-AppKey", Kii.getAppKey());
        retval.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        retval.setHeader("Content-Type", "application/vnd.kii.RegistrationAndAuthorizationRequest+json");
        retval.setEntity(KiiUser.createPseudoUserRequestBody(userFields));
        return retval;
    }

    private static HttpEntity createPseudoUserRequestBody(UserFields userFields) throws UnsupportedEncodingException {
        if (userFields == null) {
            return new StringEntity("{}", "UTF-8");
        }
        try {
            return new StringEntity(userFields.toJsonString(), "UTF-8");
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException("Unexpected request.", e);
        }
    }

    private static KiiUser newPseudoUser(JSONObject json) {
        try {
            KiiUser retval = new KiiUser();
            retval.mJSON = json;
            retval.setId(json.getString(PROPERTY_ID));
            retval.updateAccessToken(json.getString("_accessToken"));
            Long expiresAt = Utils.safeAdd(System.currentTimeMillis(), 2147483647000L);
            retval.updateAccessTokenExpiresAt(expiresAt);
            retval.mJSON.remove("_accessToken");
            retval.set("_hasPassword", false);
            return retval;
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException("Unexpected response.", e);
        }
    }

    private void updateAttributes(IdentityData identityData, UserFields userFields, String password) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)this.createUpdateAttributeRequest(identityData, userFields, password));
    }

    private HttpPost createUpdateAttributeRequest(IdentityData identityData, UserFields userFields, String password) {
        HttpPost retval = new HttpPost(Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "users", "me"));
        retval.setHeader("X-Kii-AppID", Kii.getAppId());
        retval.setHeader("X-Kii-AppKey", Kii.getAppKey());
        retval.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.setAuthBearer((HttpUriRequest)retval);
        retval.setHeader("Content-Type", "application/vnd.kii.UserUpdateRequest+json");
        retval.setEntity(this.createUpdateAttributeRequestBody(identityData, userFields, password));
        return retval;
    }

    private HttpEntity createUpdateAttributeRequestBody(IdentityData identityData, UserFields userFields, String password) {
        try {
            JSONObject json = new JSONObject(this.mJSON.toString());
            for (String reservedKey : reservedKeys) {
                json.remove(reservedKey);
            }
            json.putOpt("password", (Object)password);
            if (identityData != null) {
                json.putOpt(PROPERTY_USERNAME, (Object)identityData.getUserName());
                json.putOpt(PROPERTY_EMAIL, (Object)identityData.getEmail());
                json.putOpt(PROPERTY_PHONE, (Object)identityData.getPhone());
            }
            if (userFields != null && !userFields.isEmpty()) {
                Iterator keys = userFields.mJSON.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    json.put(key, userFields.mJSON.get(key));
                }
                for (String key : userFields.getRemovingKeys()) {
                    json.remove(key);
                }
            }
            return new StringEntity(json.toString(), "UTF-8");
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException("Unexpected request.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalKiiBaseObjectFormatException("Unexpected request.", e);
        }
    }

    private void setIdentityData(IdentityData identityData) {
        try {
            this.mJSON.putOpt(PROPERTY_USERNAME, (Object)identityData.getUserName());
            this.mJSON.putOpt(PROPERTY_EMAIL, (Object)identityData.getEmail());
            this.mJSON.putOpt(PROPERTY_PHONE, (Object)identityData.getPhone());
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException("Unexpected response.", e);
        }
    }

    private void setUserFields(UserFields userFields) {
        try {
            Iterator<String> keys = userFields.mJSON.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.mJSON.put(key, userFields.mJSON.get(key));
            }
            for (String key : userFields.getRemovingKeys()) {
                this.remove(key);
            }
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException("Unexpected response.", e);
        }
    }

    private boolean isLoggedInUser() {
        if (!Kii.isLoggedIn()) {
            return false;
        }
        return Kii.getCurrentUser().getID().equals(this.getID());
    }

    static String formatPhoneNumber(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        return phoneNumber.replaceAll("[-.]", "");
    }

    @Override
    @Nullable
    public String getThingOwnerID() {
        String id = this.getID();
        if (id == null) {
            return null;
        }
        return "user:" + id;
    }

    private static String toQualifiedID(String identifier) {
        String qualifiedID = null;
        qualifiedID = KiiUser.isValidEmail(identifier) ? "EMAIL:" + identifier : (KiiUser.isValidGlobalPhone(identifier) ? "PHONE:" + identifier : identifier);
        return Uri.encode((String)qualifiedID);
    }

    static {
        reservedKeys.add(PROPERTY_ID);
        reservedKeys.add(PROPERTY_COUNTRY);
        reservedKeys.add(PROPERTY_USERNAME);
        reservedKeys.add(PROPERTY_PHONE);
        reservedKeys.add(PROPERTY_PENDING_PHONE);
        reservedKeys.add(PROPERTY_EMAIL);
        reservedKeys.add(PROPERTY_PENDING_EMAIL);
        reservedKeys.add(PROPERTY_DISPLAYNAME);
        reservedKeys.add(PROPERTY_INTERNAL_USER_ID);
        reservedKeys.add(PROPERTY_PHONE_NUMBER_VERIFIED);
        reservedKeys.add(PROPERTY_EMAIL_ADDRESS_VERIFIED);
        reservedKeys.add(PROPERTY_LOCALE);
        reservedKeys.add(PROPERTY_URI);
        CREATOR = new Parcelable.Creator<KiiUser>(){

            @NonNull
            public KiiUser createFromParcel(@NonNull Parcel in) {
                try {
                    return new KiiUser(in.readBundle());
                }
                catch (JSONException e) {
                    throw new RuntimeException("Unexpected error!", e);
                }
            }

            @NonNull
            public KiiUser[] newArray(int size) {
                return new KiiUser[size];
            }
        };
    }

    public static enum NotificationMethod {
        EMAIL("EMAIL", null),
        SMS("SMS", "URL"),
        SMS_PIN("SMS", "PIN");

        private final String notificationMethod;
        private final String smsResetMethod;

        private NotificationMethod(String notificationMethod, String smsResetMethod) {
            this.notificationMethod = notificationMethod;
            this.smsResetMethod = smsResetMethod;
        }
    }

    public static final class Builder {
        private String phone = null;
        private String email = null;
        private String userName = null;
        private String country = null;

        Builder() {
        }

        @Deprecated
        @NonNull
        public Builder withPhone(@NonNull String phone) {
            if (!KiiUser.isValidPhone(phone)) {
                throw new IllegalArgumentException("Invalid Phone format:" + phone);
            }
            this.phone = phone;
            return this;
        }

        @NonNull
        public Builder setGlobalPhone(@NonNull String phone) {
            if (!KiiUser.isValidGlobalPhone(phone)) {
                throw new IllegalArgumentException("Invalid Phone format:" + phone);
            }
            this.phone = phone;
            this.country = null;
            return this;
        }

        @NonNull
        public Builder setLocalPhone(@NonNull String phone, @NonNull String country) {
            if (!KiiUser.isValidLocalPhone(phone)) {
                throw new IllegalArgumentException("Invalid Phone format:" + phone);
            }
            if (!KiiUser.isValidCountry(country)) {
                throw new IllegalArgumentException("Invalid country format:" + country);
            }
            this.phone = phone;
            this.country = country;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder withEmail(@NonNull String email) {
            return this.setEmail(email);
        }

        @NonNull
        public Builder setEmail(@NonNull String email) {
            if (!KiiUser.isValidEmail(email)) {
                throw new IllegalArgumentException("Invalid Email format:" + email);
            }
            this.email = email;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder withName(@NonNull String userName) {
            return this.setName(userName);
        }

        @NonNull
        public Builder setName(@NonNull String userName) {
            if (!KiiUser.isValidUserName(userName)) {
                throw new IllegalArgumentException("Invalid username format:" + userName);
            }
            this.userName = userName;
            return this;
        }

        @NonNull
        public KiiUser build() {
            if (this.userName == null && this.email == null && this.phone == null) {
                throw new IllegalStateException("At least one of userName, phone, or email must be specified.");
            }
            KiiUser user = new KiiUser();
            if (this.userName != null) {
                user.setReserveProperty(KiiUser.PROPERTY_USERNAME, this.userName);
            }
            if (this.email != null) {
                user.setReserveProperty(KiiUser.PROPERTY_EMAIL, this.email);
            }
            if (this.phone != null) {
                user.setReserveProperty(KiiUser.PROPERTY_PHONE, KiiUser.formatPhoneNumber(this.phone));
            }
            if (this.country != null) {
                user.setReserveProperty(KiiUser.PROPERTY_COUNTRY, this.country);
            }
            return user;
        }
    }
}

