/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.SDKClientInfo;
import com.kii.cloud.storage.callback.KiiPushCallBack;
import com.kii.cloud.storage.engine.KiiCloudEngine;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.utils.Utils;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class KiiPushInstallation {
    private boolean development = false;

    KiiPushInstallation() {
        this(false);
    }

    KiiPushInstallation(boolean development) {
        this.development = development;
    }

    public abstract void install(@NonNull String var1) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException;

    public abstract int install(@NonNull String var1, @Nullable KiiPushCallBack var2);

    public abstract void uninstall(@NonNull String var1) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException;

    public abstract int uninstall(@NonNull String var1, @Nullable KiiPushCallBack var2);

    void install(String registrationId, PushBackend backEnd) throws IOException, BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException {
        if (TextUtils.isEmpty((CharSequence)registrationId)) {
            throw new IllegalArgumentException("Registration id must not be empty or null.");
        }
        Utils.checkInitialize(true);
        JSONObject object = new JSONObject();
        try {
            object.put("installationRegistrationID", (Object)registrationId);
            object.put("deviceType", (Object)backEnd.deviceType());
            if (this.development) {
                object.put("development", this.development);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("unexpected error!", e);
        }
        String postUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "installations");
        HttpPost request = new HttpPost(postUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        request.setHeader("Content-Type", "application/vnd.kii.InstallationCreationRequest+json");
        request.setEntity((HttpEntity)new StringEntity(object.toString()));
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    void uninstall(String registrationId, PushBackend backEnd) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        if (TextUtils.isEmpty((CharSequence)registrationId)) {
            throw new IllegalArgumentException("Registration id must not be empty or null.");
        }
        Utils.checkInitialize(true);
        String url = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "installations", backEnd.deviceType() + ":" + registrationId);
        HttpDelete request = new HttpDelete(url);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
    }

    public static enum PushBackend {
        GCM("ANDROID"),
        JPUSH("JPUSH");

        private final String value;

        private PushBackend(String value) {
            this.value = value;
        }

        @NonNull
        public String deviceType() {
            return this.value;
        }
    }
}

