/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.KiiGroup;
import com.kii.cloud.storage.KiiObject;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.utils.Utils;

public class KiiInternalUtil {
    public static void resetSDK() {
        Kii.clearInstance();
    }

    public static void setCurrentUser(@Nullable KiiUser user) {
        Kii.getInstance().setCurrentUser(user);
    }

    public static boolean isDeleted(@NonNull KiiGroup group) {
        return group.isDeleted();
    }

    @Nullable
    public static Uri toUri2(@NonNull KiiObject object) {
        return object.toUri2();
    }

    public static long safeCalculateExpiresAt(long expirationInSeconds, long baseUnixTimeInMills) {
        long expiresAt = 0L;
        try {
            expiresAt = Utils.safeAdd(baseUnixTimeInMills, Utils.safeMultiply(expirationInSeconds, 1000L));
        }
        catch (ArithmeticException e) {
            expiresAt = Long.MAX_VALUE;
        }
        return expiresAt;
    }
}

