/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.kii.cloud.async.executor.KiiGroupTask;
import com.kii.cloud.async.executor.KiiTaskExecutor;
import com.kii.cloud.async.executor.KiiUncancelabeTask;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.KiiBucket;
import com.kii.cloud.storage.KiiCallback;
import com.kii.cloud.storage.KiiEncryptedBucket;
import com.kii.cloud.storage.KiiListResult;
import com.kii.cloud.storage.KiiScope;
import com.kii.cloud.storage.KiiSubject;
import com.kii.cloud.storage.KiiThingOwner;
import com.kii.cloud.storage.KiiTopic;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.SDKClientInfo;
import com.kii.cloud.storage.callback.KiiGroupCallBack;
import com.kii.cloud.storage.engine.ApiResponse;
import com.kii.cloud.storage.engine.KiiCloudEngine;
import com.kii.cloud.storage.exception.GroupOperationException;
import com.kii.cloud.storage.exception.IllegalKiiBaseObjectFormatException;
import com.kii.cloud.storage.exception.app.AppException;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.utils.Log;
import com.kii.cloud.storage.utils.Utils;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class KiiGroup
implements KiiScope,
KiiSubject,
KiiThingOwner {
    private static final String TAG = "KiiGroup";
    private static final String URI_SCHEME = "kiicloud";
    private String mId;
    private String groupName;
    private String mOwnerId;
    private Set<KiiUser> addUsers;
    private Set<KiiUser> removeUsers;
    private boolean isDeleted = false;

    KiiGroup(String groupName, List<KiiUser> users) {
        this.groupName = groupName;
        this.addUsers = new CopyOnWriteArraySet<KiiUser>();
        this.removeUsers = new CopyOnWriteArraySet<KiiUser>();
        if (users != null) {
            for (KiiUser user : users) {
                if (TextUtils.isEmpty((CharSequence)user.getID())) continue;
                this.addUsers.add(user);
            }
        }
    }

    KiiGroup() {
        this.addUsers = new CopyOnWriteArraySet<KiiUser>();
        this.removeUsers = new CopyOnWriteArraySet<KiiUser>();
    }

    @WorkerThread
    @NonNull
    public static KiiGroup registerGroupWithID(@NonNull String id, @NonNull String name, @Nullable List<KiiUser> members) throws GroupOperationException {
        Utils.checkInitialize(true);
        if (TextUtils.isEmpty((CharSequence)id)) {
            throw new IllegalArgumentException("id is null or empty.");
        }
        if (!Utils.validateGroupID(id)) {
            throw new IllegalArgumentException("Invalid id format:" + id);
        }
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("name is null or empty.");
        }
        String url = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "groups", id);
        HttpPut request = new HttpPut(url);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("accept", "application/vnd.kii.GroupCreationResponse+json");
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        JSONObject obj = new JSONObject();
        try {
            obj.put("name", (Object)name);
            obj.put("owner", (Object)Kii.getCurrentUser().getID());
            if (members != null) {
                JSONArray memberIds = new JSONArray();
                for (KiiUser member : members) {
                    String userId = member.getID();
                    if (TextUtils.isEmpty((CharSequence)userId)) continue;
                    memberIds.put((Object)userId);
                }
                obj.put("members", (Object)memberIds);
            }
        }
        catch (JSONException e1) {
            throw new RuntimeException("unexpected error!", e1);
        }
        Log.v(TAG, "Create group with ID JSON:" + obj.toString());
        ApiResponse res = null;
        try {
            StringEntity entity = new StringEntity(obj.toString(), "UTF8");
            entity.setContentType("application/vnd.kii.GroupCreationRequest+json");
            request.setEntity((HttpEntity)entity);
            res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
            JSONObject respObj = new JSONObject(res.body);
            KiiGroup group = new KiiGroup(name, members);
            group.mId = respObj.getString("groupID");
            group.mOwnerId = Kii.getCurrentUser().getID();
            return group;
        }
        catch (JSONException jse) {
            throw new IllegalKiiBaseObjectFormatException(res.body);
        }
        catch (IOException ioe) {
            throw new GroupOperationException(ioe.getMessage(), ioe, members, null);
        }
        catch (AppException ae) {
            throw new GroupOperationException(ae.getMessage(), ae, members, null);
        }
    }

    public static void registerGroupWithID(final @NonNull String id, final @NonNull String name, final @Nullable List<KiiUser> members, final @NonNull KiiCallback<KiiGroup> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){
            KiiGroup result;

            @Override
            public void run() {
                try {
                    this.result = KiiGroup.registerGroupWithID(id, name, members);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(this.result, this.getException());
            }
        });
    }

    @NonNull
    public static KiiGroup createWithNameAndMember(@NonNull String name, @Nullable List<KiiUser> users) {
        return new KiiGroup(name, users);
    }

    @NonNull
    public static KiiGroup createWithName(@NonNull String name) {
        return new KiiGroup(name, null);
    }

    @NonNull
    public static KiiGroup groupWithID(@NonNull String groupID) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            throw new IllegalArgumentException("Specified ID is empty or null");
        }
        KiiGroup group = new KiiGroup();
        group.mId = groupID;
        return group;
    }

    @NonNull
    public static KiiGroup createByUri(@NonNull Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Input uri is null");
        }
        String scheme = uri.getScheme();
        if (!URI_SCHEME.equals(scheme)) {
            throw new IllegalArgumentException("Do not support this uri:" + uri);
        }
        String authority = uri.getAuthority();
        if (!"groups".equals(authority)) {
            throw new IllegalArgumentException("Do not support this uri:" + uri);
        }
        List segments = uri.getPathSegments();
        if (segments.size() != 1) {
            throw new IllegalArgumentException("Do not support this uri:" + uri);
        }
        KiiGroup group = new KiiGroup(null, null);
        group.mId = (String)segments.get(0);
        return group;
    }

    void setOwner(String ownerId) {
        this.mOwnerId = ownerId;
    }

    void setGroupName(String name) {
        this.groupName = name;
    }

    @Nullable
    public Uri toUri() {
        Utils.checkInitialize(false);
        String id = this.getID();
        if (Utils.isEmpty(id)) {
            return null;
        }
        String url = Utils.path("kiicloud://", "groups", id);
        return Uri.parse((String)url);
    }

    public void addUser(@NonNull KiiUser user) {
        if (user == null) {
            throw new IllegalArgumentException("Provided user is null");
        }
        if (TextUtils.isEmpty((CharSequence)user.getID())) {
            throw new IllegalArgumentException("Provided user is not saved to the cloud already");
        }
        this.addUsers.add(user);
        this.removeUsers.remove(user);
    }

    public void removeUser(@NonNull KiiUser user) {
        if (user == null) {
            throw new IllegalArgumentException("Provided user is null");
        }
        if (TextUtils.isEmpty((CharSequence)user.getID())) {
            throw new IllegalArgumentException("Provided user is not saved to the cloud already");
        }
        this.addUsers.remove(user);
        if (!TextUtils.isEmpty((CharSequence)this.getID())) {
            this.removeUsers.add(user);
        }
    }

    @Nullable
    public KiiUser getOwner() throws GroupOperationException {
        Utils.checkInitialize(true);
        if (this.getID() == null) {
            throw new IllegalStateException("Group does not exist in the cloud");
        }
        this.refresh();
        KiiUser owner = null;
        if (this.mOwnerId != null) {
            owner = KiiUser.userWithID(this.mOwnerId);
        }
        return owner;
    }

    public int getOwner(@NonNull KiiGroupCallBack callback) {
        KiiGroupTask groupTask = new KiiGroupTask(KiiGroupTask.TaskType.GET_OWNER, this, callback, null);
        KiiTaskExecutor.getInstance().execute(groupTask);
        return groupTask.getTaskId();
    }

    @Nullable
    public KiiUser getCachedOwner() {
        KiiUser owner = null;
        if (this.mOwnerId != null) {
            owner = KiiUser.userWithID(this.mOwnerId);
        }
        return owner;
    }

    @WorkerThread
    @NonNull
    public List<KiiUser> listMembers() throws GroupOperationException {
        Utils.checkInitialize(true);
        String groupId = this.getID();
        ArrayList<KiiUser> members = new ArrayList<KiiUser>();
        if (TextUtils.isEmpty((CharSequence)groupId)) {
            return new ArrayList<KiiUser>(this.addUsers);
        }
        String getUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "groups", groupId, "members");
        HttpGet request = new HttpGet(getUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        request.setHeader("accept", "application/vnd.kii.MembersRetrievalResponse+json");
        ApiResponse res = null;
        try {
            res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
            JSONObject respObj = new JSONObject(res.body);
            JSONArray array = respObj.getJSONArray("members");
            if (array != null && array.length() > 0) {
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject obj = array.getJSONObject(i);
                    String id = obj.getString("userID");
                    KiiUser user = KiiUser.userWithID(id);
                    members.add(user);
                }
            }
        }
        catch (JSONException jse) {
            throw new IllegalKiiBaseObjectFormatException(res.body);
        }
        catch (IOException ioe) {
            throw new GroupOperationException(ioe.getMessage(), ioe, null, null);
        }
        catch (AppException ae) {
            throw new GroupOperationException(ae.getMessage(), ae, null, null);
        }
        return members;
    }

    public int listMembers(@NonNull KiiGroupCallBack callback) {
        KiiGroupTask groupTask = new KiiGroupTask(KiiGroupTask.TaskType.LIST_MEMBERS, this, callback, null);
        KiiTaskExecutor.getInstance().execute(groupTask);
        return groupTask.getTaskId();
    }

    @WorkerThread
    public void refresh() throws GroupOperationException {
        Utils.checkInitialize(true);
        String uuid = this.getID();
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            throw new IllegalStateException("Group doesn't exist in the cloud, missing unique identifier.");
        }
        String getUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "groups", uuid);
        HttpGet request = new HttpGet(getUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        request.setHeader("accept", "application/vnd.kii.GroupRetrievalResponse+json");
        ApiResponse res = null;
        try {
            res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
            JSONObject respObj = new JSONObject(res.body);
            this.mId = respObj.getString("groupID");
            this.mOwnerId = respObj.optString("owner", null);
            this.groupName = respObj.getString("name");
        }
        catch (JSONException jse) {
            throw new IllegalKiiBaseObjectFormatException(res.body);
        }
        catch (IOException ioe) {
            throw new GroupOperationException(ioe.getMessage(), ioe, null, null);
        }
        catch (AppException e) {
            throw new GroupOperationException(e.getMessage(), e, null, null);
        }
    }

    @WorkerThread
    public void changeName(@NonNull String name) throws GroupOperationException {
        Utils.checkInitialize(true);
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("provided name is null");
        }
        String id = this.getID();
        if (TextUtils.isEmpty((CharSequence)id)) {
            throw new IllegalStateException("Group doesn't exist in the cloud, missing unique identifier.");
        }
        String url = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "groups", id, "name");
        HttpPut request = new HttpPut(url);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        try {
            StringEntity entity = new StringEntity(name, "UTF8");
            request.setEntity((HttpEntity)entity);
            KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        }
        catch (IOException ioe) {
            throw new GroupOperationException(ioe.getMessage(), ioe, null, null);
        }
        catch (AppException e) {
            throw new GroupOperationException(e.getMessage(), e, null, null);
        }
        this.groupName = name;
    }

    public int changeName(@NonNull KiiGroupCallBack callback, @NonNull String name) {
        KiiGroupTask groupTask = new KiiGroupTask(KiiGroupTask.TaskType.CHANGE_NAME, this, callback, name);
        KiiTaskExecutor.getInstance().execute(groupTask);
        return groupTask.getTaskId();
    }

    public int refresh(@NonNull KiiGroupCallBack callback) {
        KiiGroupTask groupTask = new KiiGroupTask(KiiGroupTask.TaskType.REFRESH, this, callback, null);
        KiiTaskExecutor.getInstance().execute(groupTask);
        return groupTask.getTaskId();
    }

    @WorkerThread
    public void save() throws GroupOperationException {
        Utils.checkInitialize(true);
        if (this.getID() == null) {
            this.saveToCloud();
        } else {
            this.addMembersToCloud();
            this.removeMembersFromCloud();
        }
    }

    private void saveToCloud() throws GroupOperationException {
        Utils.checkInitialize(true);
        String url = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "groups");
        HttpPost request = new HttpPost(url);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("accept", "application/vnd.kii.GroupCreationResponse+json");
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        JSONObject obj = new JSONObject();
        try {
            obj.put("name", (Object)this.groupName);
            obj.put("owner", (Object)Kii.getCurrentUser().getID());
            obj.put("members", (Object)this.userIds());
        }
        catch (JSONException e1) {
            throw new RuntimeException("unexpected error!", e1);
        }
        Log.v(TAG, "Create group JSON:" + obj.toString());
        ApiResponse res = null;
        try {
            StringEntity entity = new StringEntity(obj.toString(), "UTF8");
            entity.setContentType("application/vnd.kii.GroupCreationRequest+json");
            request.setEntity((HttpEntity)entity);
            res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
            JSONObject respObj = new JSONObject(res.body);
            this.mId = respObj.getString("groupID");
            this.mOwnerId = Kii.getCurrentUser().getID();
        }
        catch (JSONException jse) {
            throw new IllegalKiiBaseObjectFormatException(res.body);
        }
        catch (IOException ioe) {
            throw new GroupOperationException(ioe.getMessage(), ioe, new ArrayList<KiiUser>(this.addUsers), null);
        }
        catch (AppException ae) {
            throw new GroupOperationException(ae.getMessage(), ae, new ArrayList<KiiUser>(this.addUsers), null);
        }
        this.addUsers.clear();
    }

    private JSONArray userIds() {
        JSONArray ids = new JSONArray();
        for (KiiUser user : this.addUsers) {
            String uid = user.getID();
            if (TextUtils.isEmpty((CharSequence)uid)) continue;
            ids.put((Object)uid);
        }
        return ids;
    }

    private void addMembersToCloud() throws GroupOperationException {
        Utils.checkInitialize(true);
        String id = this.getID();
        if (TextUtils.isEmpty((CharSequence)id)) {
            throw new IllegalStateException("Group doesn't exist in the cloud, missing unique identifier.");
        }
        for (KiiUser user : this.addUsers) {
            String url = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "groups", id, "members", user.getID());
            HttpPut request = new HttpPut(url);
            KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
            request.setHeader("X-Kii-AppID", Kii.getAppId());
            request.setHeader("X-Kii-AppKey", Kii.getAppKey());
            request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
            try {
                KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
                this.addUsers.remove(user);
            }
            catch (IOException ioe) {
                throw new GroupOperationException(ioe.getMessage(), ioe, new ArrayList<KiiUser>(this.addUsers), new ArrayList<KiiUser>(this.removeUsers));
            }
            catch (AppException ae) {
                throw new GroupOperationException(ae.getMessage(), ae, new ArrayList<KiiUser>(this.addUsers), new ArrayList<KiiUser>(this.removeUsers));
            }
        }
    }

    private void removeMembersFromCloud() throws GroupOperationException {
        Utils.checkInitialize(true);
        String id = this.getID();
        if (TextUtils.isEmpty((CharSequence)id)) {
            throw new IllegalStateException("Group doesn't exist in the cloud, missing unique identifier.");
        }
        for (KiiUser user : this.removeUsers) {
            String url = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "groups", id, "members", user.getID());
            HttpDelete request = new HttpDelete(url);
            KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
            request.setHeader("X-Kii-AppID", Kii.getAppId());
            request.setHeader("X-Kii-AppKey", Kii.getAppKey());
            request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
            try {
                KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
                this.removeUsers.remove(user);
            }
            catch (IOException ioe) {
                throw new GroupOperationException(ioe.getMessage(), ioe, null, new ArrayList<KiiUser>(this.removeUsers));
            }
            catch (AppException ae) {
                throw new GroupOperationException(ae.getMessage(), ae, null, new ArrayList<KiiUser>(this.removeUsers));
            }
        }
    }

    public int save(@NonNull KiiGroupCallBack callback) {
        KiiGroupTask groupTask = new KiiGroupTask(KiiGroupTask.TaskType.SAVE, this, callback, null);
        KiiTaskExecutor.getInstance().execute(groupTask);
        return groupTask.getTaskId();
    }

    @WorkerThread
    public void delete() throws GroupOperationException {
        Utils.checkInitialize(true);
        String uuid = this.getID();
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            throw new IllegalStateException("Group doesn't exist in the cloud, missing unique identifier.");
        }
        String url = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "groups", uuid);
        HttpDelete request = new HttpDelete(url);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("accept", "application/vnd.kii.GroupRetrievalResponse+json");
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        try {
            KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
            this.setDeleted(true);
        }
        catch (IOException ioe) {
            throw new GroupOperationException(ioe.getMessage(), ioe, null, null);
        }
        catch (AppException ae) {
            throw new GroupOperationException(ae.getMessage(), ae, null, null);
        }
    }

    public int delete(@NonNull KiiGroupCallBack callback) {
        KiiGroupTask groupTask = new KiiGroupTask(KiiGroupTask.TaskType.DELETE, this, callback, null);
        KiiTaskExecutor.getInstance().execute(groupTask);
        return groupTask.getTaskId();
    }

    @NonNull
    public KiiBucket bucket(@NonNull String bucketName) {
        return new KiiBucket(this, bucketName);
    }

    @NonNull
    public KiiEncryptedBucket encryptedBucket(@NonNull String bucketName) {
        return new KiiEncryptedBucket(this, bucketName);
    }

    @Nullable
    public String getID() {
        return this.mId;
    }

    @Nullable
    public String getGroupName() {
        return this.groupName;
    }

    @NonNull
    public KiiTopic topic(@NonNull String name) {
        KiiTopic topic = new KiiTopic(this, name);
        return topic;
    }

    @NonNull
    public KiiListResult<KiiTopic> listTopics() throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        return this.listTopics((String)null);
    }

    @WorkerThread
    @NonNull
    public KiiListResult<KiiTopic> listTopics(@Nullable String paginationKey) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        Utils.checkInitialize(true);
        String uuid = this.getID();
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            throw new IllegalStateException("Group doesn't exist in the cloud, missing unique identifier.");
        }
        String topicUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "groups", uuid, "topics");
        if (!Utils.isEmpty(paginationKey)) {
            topicUrl = topicUrl + "?paginationKey=" + URLEncoder.encode(paginationKey, "UTF-8");
        }
        HttpGet request = new HttpGet(topicUrl);
        request.addHeader("X-Kii-AppID", Kii.getAppId());
        request.addHeader("X-Kii-AppKey", Kii.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        ApiResponse response = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        try {
            JSONObject json = new JSONObject(response.body);
            String newPaginationKey = null;
            if (json.has("paginationKey")) {
                newPaginationKey = json.getString("paginationKey");
            }
            JSONArray array = json.getJSONArray("topics");
            ArrayList<KiiTopic> topics = new ArrayList<KiiTopic>();
            for (int i = 0; i < array.length(); ++i) {
                topics.add(this.topic(array.getJSONObject(i).getString("topicID")));
            }
            return new KiiListResult<KiiTopic>(topics, newPaginationKey);
        }
        catch (JSONException e) {
            Log.e(TAG, e.getMessage());
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
    }

    public void listTopics(@NonNull KiiCallback<KiiListResult<KiiTopic>> callback) {
        this.listTopics(null, callback);
    }

    public void listTopics(final @Nullable String paginationKey, final @NonNull KiiCallback<KiiListResult<KiiTopic>> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null.");
        }
        KiiTaskExecutor.getInstance().execute(new KiiUncancelabeTask(){
            private KiiListResult<KiiTopic> result = null;

            @Override
            public void run() {
                try {
                    this.result = KiiGroup.this.listTopics(paginationKey);
                }
                catch (Exception e) {
                    this.setExeption(e);
                }
            }

            @Override
            public void executeCompletionCallback() {
                callback.onComplete(this.result, this.getException());
            }
        });
    }

    boolean isDeleted() {
        return this.isDeleted;
    }

    void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @Override
    @Nullable
    public String getThingOwnerID() {
        String id = this.getID();
        if (id == null) {
            return null;
        }
        return "group:" + id;
    }
}

