/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.KiiUser;

public class IdentityData {
    private final String userName;
    private final String email;
    private final String phone;

    private IdentityData(String userName, String email, String phone) {
        if (userName == null && email == null && phone == null) {
            throw new RuntimeException("Programming error: All fields are null.");
        }
        this.userName = userName;
        this.email = email;
        this.phone = KiiUser.formatPhoneNumber(phone);
    }

    @Nullable
    public String getUserName() {
        return this.userName;
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    @Nullable
    public String getPhone() {
        return this.phone;
    }

    public static class Builder {
        private String userName;
        private String email;
        private String phone;

        @NonNull
        public static Builder newWithName(@NonNull String userName) {
            Builder retval = new Builder();
            return retval.withName(userName);
        }

        @NonNull
        public static Builder newWithEmail(@NonNull String email) {
            Builder retval = new Builder();
            return retval.withEmail(email);
        }

        @NonNull
        public static Builder newWithPhone(@NonNull String phone) {
            Builder retval = new Builder();
            return retval.withPhone(phone);
        }

        private Builder() {
        }

        @NonNull
        public Builder withName(@NonNull String userName) {
            if (!KiiUser.isValidUserName(userName)) {
                throw new IllegalArgumentException("userName is invalid.");
            }
            this.userName = userName;
            return this;
        }

        @NonNull
        public Builder withEmail(@NonNull String email) {
            if (!KiiUser.isValidEmail(email)) {
                throw new IllegalArgumentException("email is invalid.");
            }
            this.email = email;
            return this;
        }

        @NonNull
        public Builder withPhone(@NonNull String phone) {
            if (!KiiUser.isValidPhone(phone) && !KiiUser.isValidLocalPhone(phone)) {
                throw new IllegalArgumentException("phone is invalid.");
            }
            this.phone = phone;
            return this;
        }

        @NonNull
        public IdentityData build() {
            return new IdentityData(this.userName, this.email, this.phone);
        }
    }
}

