/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.storage;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.storage.KiiPushMessage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class APNSMessage {
    private KiiPushMessage.Data data;
    private JSONObject parent;
    private JSONObject alert;

    APNSMessage(JSONObject parent, KiiPushMessage.Data data, JSONObject alert) {
        this.parent = parent;
        this.data = data;
        this.alert = alert;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public String toString() {
        return this.toJSON().toString();
    }

    @NonNull
    public JSONObject toJSON() {
        JSONObject ret = null;
        try {
            ret = new JSONObject(this.parent.toString());
            if (this.data != null) {
                ret.put("data", (Object)this.data.toJSONObject());
            }
            if (this.alert.length() > 0) {
                ret.put("alert", (Object)this.alert);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Unexpected error.", e);
        }
        return ret;
    }

    public static class Builder {
        private KiiPushMessage.Data data;
        private JSONObject parent = new JSONObject();
        private JSONObject alert = new JSONObject();

        @NonNull
        public APNSMessage build() {
            APNSMessage message = new APNSMessage(this.parent, this.data, this.alert);
            return message;
        }

        Builder() {
            try {
                this.parent.put("enabled", true);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
        }

        @NonNull
        public Builder enable(boolean enabled) {
            try {
                this.parent.put("enabled", enabled);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public Builder withData(@Nullable KiiPushMessage.Data data) {
            this.data = data;
            return this;
        }

        @NonNull
        public Builder withAPNSData(@Nullable APNSData data) {
            this.data = data;
            return this;
        }

        @NonNull
        public Builder withSound(@Nullable String sound) {
            try {
                this.parent.put("sound", (Object)sound);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public Builder withBadge(int badge) {
            try {
                this.parent.put("badge", badge);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error!", e);
            }
            return this;
        }

        @NonNull
        public Builder withAlertActionLocKey(@Nullable String actionLocKey) {
            try {
                this.alert.put("actionLocKey", (Object)actionLocKey);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error.", e);
            }
            return this;
        }

        @NonNull
        public Builder withAlertLocKey(@Nullable String locKey) {
            try {
                this.alert.put("locKey", (Object)locKey);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error.", e);
            }
            return this;
        }

        @NonNull
        public Builder withAlertLocArgs(@NonNull String[] locArgs) {
            if (locArgs == null || locArgs.length == 0) {
                throw new IllegalArgumentException("LocArgs can not be null or empty.");
            }
            try {
                JSONArray args = new JSONArray();
                for (String s : locArgs) {
                    args.put((Object)s);
                }
                this.alert.put("locArgs", (Object)args);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error.", e);
            }
            return this;
        }

        @NonNull
        public Builder withAlertLaunchImage(@Nullable String launchImage) {
            try {
                this.alert.put("launchImage", (Object)launchImage);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error.", e);
            }
            return this;
        }

        @NonNull
        public Builder withAlertBody(@Nullable String body) {
            try {
                this.alert.put("body", (Object)body);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error.", e);
            }
            return this;
        }

        @NonNull
        public Builder withAlertTitle(@Nullable String title) {
            try {
                this.alert.put("title", (Object)title);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error.", e);
            }
            return this;
        }

        @NonNull
        public Builder withAlertSubtitle(@Nullable String subtitle) {
            try {
                this.alert.put("subtitle", (Object)subtitle);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error.", e);
            }
            return this;
        }

        @NonNull
        public Builder withContentAvailable(int contentAvailable) {
            try {
                this.parent.put("contentAvailable", contentAvailable);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error.", e);
            }
            return this;
        }

        @NonNull
        public Builder withCategory(@Nullable String category) {
            try {
                this.parent.put("category", (Object)category);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error.", e);
            }
            return this;
        }

        @NonNull
        public Builder withMutableContent(int mutableContent) {
            try {
                this.parent.put("mutableContent", mutableContent);
            }
            catch (JSONException e) {
                throw new RuntimeException("Unexpected error.", e);
            }
            return this;
        }
    }

    public static class APNSData
    extends KiiPushMessage.Data {
        public static boolean isValidKey(@Nullable String key) {
            return KiiPushMessage.Data.isValidKey(key);
        }
    }
}

