/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.okhttp;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.apache.OkApacheClient;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public final class KiiHttpClient
implements HttpClient {
    private final OkApacheClient delegateClient;
    private List<HttpResponseInterceptor> interceptors = new ArrayList<HttpResponseInterceptor>();

    public KiiHttpClient(@NonNull OkApacheClient client) {
        this.delegateClient = client;
    }

    @NonNull
    public HttpParams getParams() {
        return this.delegateClient.getParams();
    }

    @Nullable
    public ClientConnectionManager getConnectionManager() {
        return this.delegateClient.getConnectionManager();
    }

    @NonNull
    public HttpResponse execute(@NonNull HttpUriRequest request) throws IOException {
        HttpResponse response = this.delegateClient.execute(request);
        this.processResponseInterceptor(response);
        return response;
    }

    @NonNull
    public HttpResponse execute(@NonNull HttpUriRequest request, @Nullable HttpContext context) throws IOException {
        HttpResponse response = this.delegateClient.execute(request, context);
        this.processResponseInterceptor(response);
        return response;
    }

    @NonNull
    public HttpResponse execute(@Nullable HttpHost host, @NonNull HttpRequest request) throws IOException {
        HttpResponse response = this.delegateClient.execute(host, request);
        this.processResponseInterceptor(response);
        return response;
    }

    @NonNull
    public HttpResponse execute(@Nullable HttpHost host, @NonNull HttpRequest request, @Nullable HttpContext context) throws IOException {
        HttpResponse response = this.delegateClient.execute(host, request, context);
        this.processResponseInterceptor(response);
        return response;
    }

    @NonNull
    public <T> T execute(@NonNull HttpUriRequest request, @NonNull ResponseHandler<? extends T> handler) throws IOException {
        return (T)this.delegateClient.execute(request, handler);
    }

    @NonNull
    public <T> T execute(@NonNull HttpUriRequest request, @NonNull ResponseHandler<? extends T> handler, @Nullable HttpContext context) throws IOException {
        return (T)this.delegateClient.execute(request, handler, context);
    }

    @NonNull
    public <T> T execute(@Nullable HttpHost host, @NonNull HttpRequest request, @NonNull ResponseHandler<? extends T> handler) throws IOException {
        return (T)this.delegateClient.execute(host, request, handler);
    }

    @NonNull
    public <T> T execute(@Nullable HttpHost host, @NonNull HttpRequest request, @NonNull ResponseHandler<? extends T> handler, @Nullable HttpContext context) throws IOException {
        return (T)this.delegateClient.execute(host, request, handler, context);
    }

    public void addResponseInterceptor(@NonNull HttpResponseInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public synchronized <T extends HttpResponseInterceptor> void removeResponseInterceptorByClass(@NonNull Class<T> clazz) {
        ArrayList<HttpResponseInterceptor> filteredInterceptors = new ArrayList<HttpResponseInterceptor>();
        for (HttpResponseInterceptor interceptor : this.interceptors) {
            if (interceptor.getClass() == clazz) continue;
            filteredInterceptors.add(interceptor);
        }
        this.interceptors = filteredInterceptors;
    }

    public void clearResponseInterceptors() {
        this.interceptors = new ArrayList<HttpResponseInterceptor>();
    }

    private void processResponseInterceptor(HttpResponse response) throws IOException {
        for (HttpResponseInterceptor interceptor : this.interceptors) {
            try {
                interceptor.process(response, null);
            }
            catch (HttpException e) {
                throw new IOException(e);
            }
        }
    }

    private static void consumeContentQuietly(HttpResponse response) {
        try {
            response.getEntity().consumeContent();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

