/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.async.executor;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.async.executor.KiiTask;
import com.kii.cloud.storage.KiiGroup;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.callback.KiiGroupCallBack;
import java.util.List;

public class KiiGroupTask
implements KiiTask,
Runnable {
    TaskType type;
    KiiGroupCallBack callback;
    KiiGroup target;
    String name;
    KiiUser owner;
    List<KiiUser> members;
    Exception e;
    int taskId;

    public KiiGroupTask(@NonNull TaskType type, @NonNull KiiGroup target, @NonNull KiiGroupCallBack callback, @Nullable String name) {
        this.type = type;
        this.callback = callback;
        this.name = name;
        this.target = target;
    }

    @Override
    public void run() {
        switch (this.type) {
            case SAVE: {
                this.doSave();
                break;
            }
            case CHANGE_NAME: {
                this.doChangeName();
                break;
            }
            case GET_OWNER: {
                this.doGetOwner();
                break;
            }
            case LIST_MEMBERS: {
                this.doListMembers();
                break;
            }
            case REFRESH: {
                this.doRefresh();
                break;
            }
            case DELETE: {
                this.doDelete();
                break;
            }
            default: {
                throw new RuntimeException("Unknown type");
            }
        }
    }

    private void doSave() {
        try {
            this.target.save();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doChangeName() {
        try {
            this.target.changeName(this.name);
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doGetOwner() {
        try {
            this.owner = this.target.getOwner();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doListMembers() {
        try {
            this.members = this.target.listMembers();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doRefresh() {
        try {
            this.target.refresh();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    private void doDelete() {
        try {
            this.target.delete();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    @Override
    public int getTaskId() {
        return this.taskId;
    }

    @Override
    public void setTaskId(int id) {
        this.taskId = id;
    }

    @Override
    public void setExeption(@Nullable Exception e) {
        this.e = e;
    }

    @Override
    @Nullable
    public Exception getException() {
        return this.e;
    }

    @Override
    public void executeCompletionCallback() {
        switch (this.type) {
            case SAVE: {
                this.callback.onSaveCompleted(this.taskId, this.target, this.e);
                break;
            }
            case CHANGE_NAME: {
                this.callback.onChangeNameCompleted(this.taskId, this.target, this.e);
                break;
            }
            case GET_OWNER: {
                this.callback.onGetOwnerCompleted(this.taskId, this.target, this.owner, this.e);
                break;
            }
            case LIST_MEMBERS: {
                this.callback.onListMembersCompleted(this.taskId, this.members, this.target, this.e);
                break;
            }
            case REFRESH: {
                this.callback.onRefreshCompleted(this.taskId, this.target, this.e);
                break;
            }
            case DELETE: {
                this.callback.onDeleteCompleted(this.taskId, this.e);
                break;
            }
            default: {
                throw new RuntimeException("Unknown type.");
            }
        }
    }

    @Override
    public void executeStartCallback() {
        this.callback.onTaskStart(this.taskId);
    }

    @Override
    public void executeCancelCallback() {
        this.callback.onTaskCancel(this.taskId);
    }

    public static enum TaskType {
        SAVE,
        CHANGE_NAME,
        GET_OWNER,
        LIST_MEMBERS,
        REFRESH,
        DELETE;

    }
}

