/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.async.executor;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.async.executor.KiiTask;
import com.kii.cloud.storage.KiiACL;
import com.kii.cloud.storage.KiiACLEntry;
import com.kii.cloud.storage.callback.KiiACLCallBack;
import java.util.Set;

public class KiiACLTask
implements KiiTask,
Runnable {
    TaskType type;
    KiiACLCallBack callback;
    KiiACL target;
    Set<KiiACLEntry> entries;
    Exception e;
    int taskId;

    public KiiACLTask(@NonNull TaskType type, @NonNull KiiACL target, @NonNull KiiACLCallBack callback) {
        this.type = type;
        this.callback = callback;
        this.target = target;
    }

    @Override
    public void run() {
        switch (this.type) {
            case SAVE: {
                try {
                    this.target.save();
                }
                catch (Exception e) {
                    this.e = e;
                }
                break;
            }
            case LISTENTRY: {
                try {
                    this.entries = this.target.listACLEntries();
                }
                catch (Exception e) {
                    this.e = e;
                }
                break;
            }
            default: {
                throw new RuntimeException("Unknown type.");
            }
        }
    }

    @Override
    public int getTaskId() {
        return this.taskId;
    }

    @Override
    public void setTaskId(int id) {
        this.taskId = id;
    }

    @Override
    public void setExeption(@Nullable Exception e) {
        this.e = e;
    }

    @Override
    @Nullable
    public Exception getException() {
        return this.e;
    }

    @Override
    public void executeCompletionCallback() {
        switch (this.type) {
            case SAVE: {
                this.callback.onSaveCompleted(this.taskId, this.target, this.e);
                break;
            }
            case LISTENTRY: {
                this.callback.onListACLEntriesCompleted(this.taskId, this.entries, this.target, this.e);
                break;
            }
            default: {
                throw new RuntimeException("Unknown type.");
            }
        }
    }

    @Override
    public void executeStartCallback() {
        this.callback.onTaskStart(this.taskId);
    }

    @Override
    public void executeCancelCallback() {
        this.callback.onTaskCancel(this.taskId);
    }

    public static enum TaskType {
        SAVE,
        LISTENTRY;

    }
}

