/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.scribe.kii.exceptions.OAuthConnectionException;
import org.scribe.kii.exceptions.OAuthException;
import org.scribe.kii.model.ParameterList;
import org.scribe.kii.model.RequestTuner;
import org.scribe.kii.model.Response;
import org.scribe.kii.model.Verb;

public class Request {
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String CONTENT_TYPE = "Content-Type";
    private static RequestTuner NOOP = new RequestTuner(){

        @Override
        public void tune(Request _) {
        }
    };
    public static final String DEFAULT_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private String url;
    private Verb verb;
    private ParameterList querystringParams;
    private ParameterList bodyParams;
    private Map<String, String> headers;
    private String payload = null;
    private HttpURLConnection connection;
    private String charset;
    private byte[] bytePayload = null;
    private boolean connectionKeepAlive = false;
    private boolean followRedirects = true;
    private Long connectTimeout = null;
    private Long readTimeout = null;

    public Request(@NonNull Verb verb, @NonNull String url) {
        this.verb = verb;
        this.url = url;
        this.querystringParams = new ParameterList();
        this.bodyParams = new ParameterList();
        this.headers = new HashMap<String, String>();
    }

    @NonNull
    public Response send(@NonNull RequestTuner tuner) {
        try {
            this.createConnection();
            return this.doSend(tuner);
        }
        catch (Exception e) {
            throw new OAuthConnectionException(e);
        }
    }

    @NonNull
    public Response send() {
        return this.send(NOOP);
    }

    private void createConnection() throws IOException {
        String completeUrl = this.getCompleteUrl();
        if (this.connection == null) {
            System.setProperty("http.keepAlive", this.connectionKeepAlive ? "true" : "false");
            this.connection = (HttpURLConnection)new URL(completeUrl).openConnection();
            this.connection.setInstanceFollowRedirects(this.followRedirects);
        }
    }

    @NonNull
    public String getCompleteUrl() {
        return this.querystringParams.appendTo(this.url);
    }

    Response doSend(RequestTuner tuner) throws IOException {
        this.connection.setRequestMethod(this.verb.name());
        if (this.connectTimeout != null) {
            this.connection.setConnectTimeout(this.connectTimeout.intValue());
        }
        if (this.readTimeout != null) {
            this.connection.setReadTimeout(this.readTimeout.intValue());
        }
        this.addHeaders(this.connection);
        if (this.verb.equals((Object)Verb.PUT) || this.verb.equals((Object)Verb.POST)) {
            this.addBody(this.connection, this.getByteBodyContents());
        }
        tuner.tune(this);
        return new Response(this.connection);
    }

    void addHeaders(HttpURLConnection conn) {
        for (String key : this.headers.keySet()) {
            conn.setRequestProperty(key, this.headers.get(key));
        }
    }

    void addBody(HttpURLConnection conn, byte[] content) throws IOException {
        conn.setRequestProperty(CONTENT_LENGTH, String.valueOf(content.length));
        if (conn.getRequestProperty(CONTENT_TYPE) == null) {
            conn.setRequestProperty(CONTENT_TYPE, DEFAULT_CONTENT_TYPE);
        }
        conn.setDoOutput(true);
        conn.getOutputStream().write(content);
    }

    public void addHeader(@NonNull String key, @NonNull String value) {
        this.headers.put(key, value);
    }

    public void addBodyParameter(@NonNull String key, @NonNull String value) {
        this.bodyParams.add(key, value);
    }

    public void addQuerystringParameter(@NonNull String key, @NonNull String value) {
        this.querystringParams.add(key, value);
    }

    public void addPayload(@Nullable String payload) {
        this.payload = payload;
    }

    public void addPayload(@Nullable byte[] payload) {
        this.bytePayload = (byte[])payload.clone();
    }

    @NonNull
    public ParameterList getQueryStringParams() {
        try {
            ParameterList result = new ParameterList();
            String queryString = new URL(this.url).getQuery();
            result.addQuerystring(queryString);
            result.addAll(this.querystringParams);
            return result;
        }
        catch (MalformedURLException mue) {
            throw new OAuthException("Malformed URL", mue);
        }
    }

    @NonNull
    public ParameterList getBodyParams() {
        return this.bodyParams;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    @NonNull
    public String getSanitizedUrl() {
        return this.url.replaceAll("\\?.*", "").replace("\\:\\d{4}", "");
    }

    @NonNull
    public String getBodyContents() {
        try {
            return new String(this.getByteBodyContents(), this.getCharset());
        }
        catch (UnsupportedEncodingException uee) {
            throw new OAuthException("Unsupported Charset: " + this.charset, uee);
        }
    }

    byte[] getByteBodyContents() {
        if (this.bytePayload != null) {
            return this.bytePayload;
        }
        String body = this.payload != null ? this.payload : this.bodyParams.asFormUrlEncodedString();
        try {
            return body.getBytes(this.getCharset());
        }
        catch (UnsupportedEncodingException uee) {
            throw new OAuthException("Unsupported Charset: " + this.getCharset(), uee);
        }
    }

    @NonNull
    public Verb getVerb() {
        return this.verb;
    }

    @NonNull
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @NonNull
    public String getCharset() {
        return this.charset == null ? Charset.defaultCharset().name() : this.charset;
    }

    public void setConnectTimeout(int duration, @NonNull TimeUnit unit) {
        this.connectTimeout = unit.toMillis(duration);
    }

    public void setReadTimeout(int duration, @NonNull TimeUnit unit) {
        this.readTimeout = unit.toMillis(duration);
    }

    public void setCharset(@Nullable String charsetName) {
        this.charset = charsetName;
    }

    public void setConnectionKeepAlive(boolean connectionKeepAlive) {
        this.connectionKeepAlive = connectionKeepAlive;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    void setConnection(HttpURLConnection connection) {
        this.connection = connection;
    }

    @NonNull
    public String toString() {
        return String.format("@Request(%s %s)", new Object[]{this.getVerb(), this.getUrl()});
    }
}

