/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.scribe.kii.model.Parameter;
import org.scribe.kii.utils.OAuthEncoder;
import org.scribe.kii.utils.Preconditions;

public class ParameterList {
    private static final char QUERY_STRING_SEPARATOR = '?';
    private static final String PARAM_SEPARATOR = "&";
    private static final String PAIR_SEPARATOR = "=";
    private static final String EMPTY_STRING = "";
    private final List<Parameter> params;

    public ParameterList() {
        this.params = new ArrayList<Parameter>();
    }

    ParameterList(List<Parameter> params) {
        this.params = new ArrayList<Parameter>(params);
    }

    public ParameterList(@NonNull Map<String, String> map) {
        this();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.params.add(new Parameter(entry.getKey(), entry.getValue()));
        }
    }

    public void add(@NonNull String key, @NonNull String value) {
        this.params.add(new Parameter(key, value));
    }

    @NonNull
    public String appendTo(@NonNull String url) {
        Preconditions.checkNotNull(url, "Cannot append to null URL");
        String queryString = this.asFormUrlEncodedString();
        if (queryString.equals(EMPTY_STRING)) {
            return url;
        }
        url = url + (url.indexOf(63) != -1 ? PARAM_SEPARATOR : Character.valueOf('?'));
        url = url + queryString;
        return url;
    }

    @NonNull
    public String asOauthBaseString() {
        return OAuthEncoder.encode(this.asFormUrlEncodedString());
    }

    @NonNull
    public String asFormUrlEncodedString() {
        if (this.params.size() == 0) {
            return EMPTY_STRING;
        }
        StringBuilder builder = new StringBuilder();
        for (Parameter p : this.params) {
            builder.append('&').append(p.asUrlEncodedPair());
        }
        return builder.toString().substring(1);
    }

    public void addAll(@NonNull ParameterList other) {
        this.params.addAll(other.params);
    }

    public void addQuerystring(@Nullable String queryString) {
        if (queryString != null && queryString.length() > 0) {
            for (String param : queryString.split(PARAM_SEPARATOR)) {
                String[] pair = param.split(PAIR_SEPARATOR);
                String key = OAuthEncoder.decode(pair[0]);
                String value = pair.length > 1 ? OAuthEncoder.decode(pair[1]) : EMPTY_STRING;
                this.params.add(new Parameter(key, value));
            }
        }
    }

    public boolean contains(@NonNull Parameter param) {
        return this.params.contains(param);
    }

    public int size() {
        return this.params.size();
    }

    @NonNull
    public ParameterList sort() {
        ParameterList sorted = new ParameterList(this.params);
        Collections.sort(sorted.params);
        return sorted;
    }
}

