/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import org.scribe.kii.model.Request;
import org.scribe.kii.model.Verb;

public class OAuthRequest
extends Request {
    private static final String OAUTH_PREFIX = "oauth_";
    private Map<String, String> oauthParameters = new HashMap<String, String>();

    public OAuthRequest(@NonNull Verb verb, @NonNull String url) {
        super(verb, url);
    }

    public void addOAuthParameter(@NonNull String key, @Nullable String value) {
        this.oauthParameters.put(this.checkKey(key), value);
    }

    private String checkKey(String key) {
        if (key.startsWith(OAUTH_PREFIX) || key.equals("scope")) {
            return key;
        }
        throw new IllegalArgumentException(String.format("OAuth parameters must either be '%s' or start with '%s'", "scope", OAUTH_PREFIX));
    }

    @NonNull
    public Map<String, String> getOauthParameters() {
        return this.oauthParameters;
    }

    @Override
    @NonNull
    public String toString() {
        return String.format("@OAuthRequest(%s, %s)", new Object[]{this.getVerb(), this.getUrl()});
    }
}

