/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.kii.builder.api;

import android.support.annotation.NonNull;
import org.scribe.kii.builder.api.DefaultApi10a;
import org.scribe.kii.model.Token;
import org.scribe.kii.model.Verb;

public class FreelancerApi
extends DefaultApi10a {
    private static final String AUTHORIZATION_URL = "http://www.freelancer.com/users/api-token/auth.php?oauth_token=%s";

    @Override
    @NonNull
    public String getAccessTokenEndpoint() {
        return "http://api.freelancer.com/RequestAccessToken/requestAccessToken.xml?";
    }

    @Override
    @NonNull
    public String getRequestTokenEndpoint() {
        return "http://api.freelancer.com/RequestRequestToken/requestRequestToken.xml";
    }

    @Override
    @NonNull
    public Verb getAccessTokenVerb() {
        return Verb.GET;
    }

    @Override
    @NonNull
    public Verb getRequestTokenVerb() {
        return Verb.GET;
    }

    @Override
    @NonNull
    public String getAuthorizationUrl(@NonNull Token requestToken) {
        return String.format(AUTHORIZATION_URL, requestToken.getToken());
    }

    public static class Sandbox
    extends FreelancerApi {
        private static final String SANDBOX_AUTHORIZATION_URL = "http://www.sandbox.freelancer.com/users/api-token/auth.php";

        @Override
        @NonNull
        public String getRequestTokenEndpoint() {
            return "http://api.sandbox.freelancer.com/RequestRequestToken/requestRequestToken.xml";
        }

        @Override
        @NonNull
        public String getAccessTokenEndpoint() {
            return "http://api.sandbox.freelancer.com/RequestAccessToken/requestAccessToken.xml?";
        }

        @Override
        @NonNull
        public String getAuthorizationUrl(@NonNull Token requestToken) {
            return String.format("http://www.sandbox.freelancer.com/users/api-token/auth.php?oauth_token=%s", requestToken.getToken());
        }
    }
}

